/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SoftHashMap;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTreeTailRenderer {
    private static final int MAX_LEVEL_TYPES = 5;
    private static final JBColor TREE_RED = new JBColor(new Color(184, 66, 55), new Color(204, 102, 102));
    private static final JBColor TREE_GRAY = new JBColor((Color)Gray._153, (Color)Gray._117);
    private final Map<HighlightSeverity, String> myPluralizedSeverityNames = new SoftHashMap();
    private final Map<HighlightSeverity, String> myUnpluralizedSeverityNames = new SoftHashMap();
    private final FactoryMap<HighlightDisplayLevel, Integer> myItemCounter;
    private final SeverityRegistrar myRegistrar;
    private final GlobalInspectionContextImpl myContext;

    public InspectionTreeTailRenderer(GlobalInspectionContextImpl context) {
        this.myRegistrar = SeverityRegistrar.getSeverityRegistrar(context.getProject());
        this.myContext = context;
        this.myItemCounter = new FactoryMap<HighlightDisplayLevel, Integer>(){

            @Nullable
            protected Integer create(HighlightDisplayLevel key2) {
                return 0;
            }

            protected Map<HighlightDisplayLevel, Integer> createMap() {
                return new TreeMap<HighlightDisplayLevel, Integer>((o1, o2) -> -InspectionTreeTailRenderer.this.myRegistrar.compare(o1.getSeverity(), o2.getSeverity()));
            }
        };
    }

    public void appendTailText(InspectionTreeNode node) {
        this.appendText("  ");
        String customizedTailText = node.getCustomizedTailText();
        if (customizedTailText != null) {
            this.appendText("  ");
            this.appendText(customizedTailText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            this.myItemCounter.clear();
            node.visitProblemSeverities(this.myItemCounter);
            if (this.myItemCounter.size() > 5) {
                this.appendText(InspectionsBundle.message((String)"inspection.problem.descriptor.count", (Object[])new Object[]{this.myItemCounter.values().stream().reduce(0, (i2, j) -> i2 + j)}) + " ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                for (Map.Entry entry : this.myItemCounter.entrySet()) {
                    HighlightDisplayLevel level = (HighlightDisplayLevel)entry.getKey();
                    Integer occur = (Integer)entry.getValue();
                    SimpleTextAttributes attrs = SimpleTextAttributes.GRAY_ATTRIBUTES;
                    attrs = attrs.derive(-1, (Color)(level == HighlightDisplayLevel.ERROR && !this.myContext.getUIOptions().GROUP_BY_SEVERITY ? TREE_RED : TREE_GRAY), null, null);
                    this.appendText(occur + " " + this.getPresentableName(level, occur > 1) + " ", attrs);
                }
            }
        }
    }

    protected abstract void appendText(String var1, SimpleTextAttributes var2);

    protected abstract void appendText(String var1);

    private String getPresentableName(HighlightDisplayLevel level, boolean pluralize) {
        HighlightSeverity severity = level.getSeverity();
        if (pluralize) {
            String name = this.myPluralizedSeverityNames.get(severity);
            if (name == null) {
                String lowerCaseName = level.getName().toLowerCase(Locale.ENGLISH);
                name = this.myRegistrar.isDefaultSeverity(severity) ? StringUtil.pluralize((String)lowerCaseName) : lowerCaseName;
                this.myPluralizedSeverityNames.put(severity, name);
            }
            return name;
        }
        String name = this.myUnpluralizedSeverityNames.get(severity);
        if (name == null) {
            name = level.getName().toLowerCase(Locale.ENGLISH);
            this.myUnpluralizedSeverityNames.put(severity, name);
        }
        return name;
    }
}

