/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixPreviewPanelFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixPreviewPanelFactory.class);
    private static final int MAX_FIX_COUNT = 3;

    @Nullable
    public static JComponent create(@NotNull InspectionResultsView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory", "create"));
        }
        if (view.isUpdating() && !view.getTree().areDescriptorNodesSelected()) {
            return new LoadingInProgressPreview(view);
        }
        QuickFixReadyPanel panel2 = new QuickFixReadyPanel(view);
        return panel2.isEmpty() ? null : panel2;
    }

    @NotNull
    private static SimpleColoredComponent getLabel(int problemsCount) {
        SimpleColoredComponent label = new SimpleColoredComponent();
        QuickFixPreviewPanelFactory.appendTextToLabel(label, problemsCount);
        label.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)2));
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory", "getLabel"));
        }
        return simpleColoredComponent;
    }

    private static void appendTextToLabel(SimpleColoredComponent label, int problemsCount) {
        label.append(problemsCount + " " + StringUtil.pluralize((String)"problem", (int)problemsCount) + ":");
    }

    private static class LoadingInProgressPreview
    extends JPanel
    implements InspectionTreeLoadingProgressAware {
        private final InspectionResultsView myView;
        private SimpleColoredComponent myWaitingLabel;

        private LoadingInProgressPreview(InspectionResultsView view) {
            this.myView = view;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(IdeBorderFactory.createEmptyBorder((int)16, (int)9, (int)13, (int)0));
            AsyncProcessIcon waitingIcon = new AsyncProcessIcon("Inspection preview panel updating...");
            Disposer.register((Disposable)this, (Disposable)waitingIcon);
            this.myWaitingLabel = QuickFixPreviewPanelFactory.getLabel(this.myView.getTree().getSelectedProblemCount(false));
            this.add((Component)this.myWaitingLabel);
            this.add((Component)waitingIcon);
        }

        @Override
        public void updateLoadingProgress() {
            if (this.myWaitingLabel != null) {
                this.myWaitingLabel.clear();
                InspectionTree tree = this.myView.getTree();
                QuickFixPreviewPanelFactory.appendTextToLabel(this.myWaitingLabel, tree.getSelectedProblemCount(false));
            }
        }

        @Override
        public void treeLoaded() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                }
            });
        }

        @Override
        public void dispose() {
        }
    }

    private static class QuickFixReadyPanel
    extends JPanel {
        @NotNull
        private final InspectionResultsView myView;
        private final InspectionToolWrapper myWrapper;
        private final boolean myEmpty;

        public QuickFixReadyPanel(@NotNull InspectionResultsView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel", "<init>"));
            }
            this.myView = view;
            this.myWrapper = view.getTree().getSelectedToolWrapper(true);
            LOG.assertTrue(this.myWrapper != null);
            CommonProblemDescriptor[] descriptors = this.myView.getTree().getSelectedDescriptors(false, null, false, true);
            QuickFixAction[] fixes = view.getProvider().getQuickFixes(this.myWrapper, view.getTree());
            this.myEmpty = this.fillPanel(fixes, descriptors);
        }

        public boolean isEmpty() {
            return this.myEmpty;
        }

        private boolean fillPanel(@Nullable QuickFixAction[] fixes, CommonProblemDescriptor[] descriptors) {
            AnAction suppressionCombo;
            boolean hasFixes = fixes != null && fixes.length != 0;
            int problemCount = descriptors.length;
            boolean multipleDescriptors = problemCount > 1;
            this.setLayout(new BoxLayout(this, 2));
            boolean hasComponents = false;
            int actualProblemCount = this.myView.getTree().getContext().getPresentation(this.myWrapper).getProblemsCount(this.myView.getTree());
            if (actualProblemCount > 1 || actualProblemCount == 1 && problemCount > 1) {
                this.add((Component)QuickFixPreviewPanelFactory.getLabel(actualProblemCount));
                hasComponents = true;
            }
            DefaultActionGroup actions = new DefaultActionGroup();
            if (hasFixes) {
                actions.addAll(QuickFixReadyPanel.createFixActions(fixes, multipleDescriptors));
            }
            if ((suppressionCombo = QuickFixReadyPanel.createSuppressionCombo(this.myView)) != null) {
                actions.add(suppressionCombo);
            }
            if (actions.getChildrenCount() != 0) {
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, true);
                JComponent component = toolbar.getComponent();
                toolbar.setTargetComponent((JComponent)this);
                this.add(component);
                hasComponents = true;
            }
            if (hasComponents) {
                this.setBorder(IdeBorderFactory.createEmptyBorder((int)(hasFixes ? 2 : 9), (int)(hasFixes || problemCount > 1 ? 8 : 5), (int)(hasFixes ? 0 : 8), (int)0));
            }
            return !hasComponents;
        }

        @Nullable
        private static AnAction createSuppressionCombo(InspectionResultsView view) {
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"CodeInspection", null, (DataContext)DataManager.getInstance().getDataContext((Component)view));
            final AnAction[] suppressors = new SuppressActionWrapper().getChildren(event);
            Stream<AnAction> suppressActionStream = Arrays.stream(suppressors).filter(s -> {
                s.update(event);
                return event.getPresentation().isEnabled();
            });
            if (!suppressActionStream.findFirst().isPresent()) {
                return null;
            }
            ComboBoxAction action = new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText("Suppress");
                    this.getTemplatePresentation().setEnabledAndVisible(suppressors.length != 0);
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                    DefaultCompactActionGroup group = new DefaultCompactActionGroup();
                    group.addAll(suppressors);
                    DefaultCompactActionGroup defaultCompactActionGroup = group;
                    if (defaultCompactActionGroup == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$1", "createPopupActionGroup"));
                    }
                    return defaultCompactActionGroup;
                }
            };
            action.setSmallVariant(false);
            return action;
        }

        @NotNull
        private static AnAction[] createFixActions(final QuickFixAction[] fixes, final boolean multipleDescriptors) {
            if (fixes.length > 3) {
                ComboBoxAction fixComboBox = new ComboBoxAction(){
                    {
                        this.getTemplatePresentation().setText("Apply quick fixes" + (multipleDescriptors ? " to all the problems" : ""));
                        this.getTemplatePresentation().setIcon(AllIcons.Actions.CreateFromUsage);
                        this.setSmallVariant(false);
                    }

                    @NotNull
                    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                        DefaultActionGroup actionGroup = new DefaultActionGroup();
                        for (QuickFixAction fix : fixes) {
                            actionGroup.add((AnAction)fix);
                        }
                        DefaultActionGroup defaultActionGroup = actionGroup;
                        if (defaultActionGroup == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel$2", "createPopupActionGroup"));
                        }
                        return defaultActionGroup;
                    }
                };
                AnAction[] anActionArray = new AnAction[]{fixComboBox};
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel", "createFixActions"));
                }
                return anActionArray;
            }
            if (fixes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/QuickFixPreviewPanelFactory$QuickFixReadyPanel", "createFixActions"));
            }
            return fixes;
        }
    }
}

