/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.Queue;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionSequentialTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SuppressActionSequentialTask.class);
    private SuppressableInspectionTreeNode[] myNodesToSuppress;
    @NotNull
    private final SuppressIntentionAction mySuppressAction;
    @NotNull
    private final InspectionToolWrapper myWrapper;
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    private int myCount;

    public SuppressActionSequentialTask(@NotNull SuppressableInspectionTreeNode[] nodesToSuppress, @NotNull SuppressIntentionAction suppressAction, @NotNull InspectionToolWrapper wrapper, @NotNull GlobalInspectionContextImpl context) {
        if (nodesToSuppress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodesToSuppress", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "<init>"));
        }
        if (suppressAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressAction", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "<init>"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "<init>"));
        }
        this.myCount = 0;
        this.myNodesToSuppress = nodesToSuppress;
        this.mySuppressAction = suppressAction;
        this.myWrapper = wrapper;
        this.myContext = context;
    }

    public boolean iteration() {
        SuppressableInspectionTreeNode node = this.myNodesToSuppress[this.myCount++];
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount / (double)this.myNodesToSuppress.length);
        }
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_MODAL, () -> {
            Pair<PsiElement, CommonProblemDescriptor> content = node.getSuppressContent();
            if (content.first != null) {
                PsiElement element = (PsiElement)content.first;
                RefEntity refEntity = node.getElement();
                LOG.assertTrue(refEntity != null);
                this.suppress(element, (CommonProblemDescriptor)content.second, this.mySuppressAction, refEntity, this.myWrapper, node);
            }
        });
        return false;
    }

    public boolean isDone() {
        return this.myCount > this.myNodesToSuppress.length - 1;
    }

    public void stop() {
    }

    public void prepare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(InspectionsBundle.message((String)"inspection.action.suppress", (Object[])new Object[]{this.myWrapper.getDisplayName()}));
        }
    }

    private void suppress(@NotNull PsiElement element, @Nullable CommonProblemDescriptor descriptor, @NotNull SuppressIntentionAction action, @NotNull RefEntity refEntity, InspectionToolWrapper wrapper, @NotNull SuppressableInspectionTreeNode node) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "suppress"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "suppress"));
        }
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "suppress"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "suppress"));
        }
        if (action instanceof SuppressIntentionActionFromFix && !(descriptor instanceof ProblemDescriptor)) {
            LOG.info("local suppression fix for specific problem descriptor:  " + wrapper.getTool().getClass().getName());
        }
        Project project2 = element.getProject();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "lambda$suppress$1"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "lambda$suppress$1"));
            }
            if (refEntity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "lambda$suppress$1"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/ui/actions/suppress/SuppressActionSequentialTask", "lambda$suppress$1"));
            }
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            try {
                PsiElement container = null;
                if (action instanceof SuppressIntentionActionFromFix) {
                    container = ((SuppressIntentionActionFromFix)action).getContainer(element);
                }
                if (container == null) {
                    container = element;
                }
                if (action.isAvailable(project2, null, element)) {
                    action.invoke(project2, null, element);
                }
                Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)element.getProject())).getRunningContexts();
                for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                    context.ignoreElement(wrapper.getTool(), container);
                    if (descriptor == null) continue;
                    context.getPresentation(wrapper).ignoreCurrentElementProblem(refEntity, descriptor);
                }
                RefElement containerRef = refEntity.getRefManager().getReference(container);
                Set<Object> suppressedNodes = this.myContext.getView().getSuppressedNodes(wrapper.getShortName());
                if (containerRef != null) {
                    Queue toIgnoreInView = new Queue(1);
                    toIgnoreInView.addLast((Object)containerRef);
                    while (!toIgnoreInView.isEmpty()) {
                        List children2;
                        RefEntity entity = (RefEntity)toIgnoreInView.pullFirst();
                        if (node instanceof ProblemDescriptionNode) {
                            CommonProblemDescriptor[] descriptors = this.myContext.getPresentation(wrapper).getIgnoredElements().get(entity);
                            if (descriptors != null) {
                                Collections.addAll(suppressedNodes, descriptors);
                            }
                        } else {
                            suppressedNodes.add(entity);
                        }
                        if ((children2 = entity.getChildren()) == null) continue;
                        for (RefEntity child : children2) {
                            toIgnoreInView.addLast((Object)child);
                        }
                    }
                }
                if (node instanceof ProblemDescriptionNode) {
                    suppressedNodes.add(descriptor);
                }
            }
            catch (IncorrectOperationException e1) {
                LOG.error((Throwable)e1);
            }
        });
        node.removeSuppressActionFromAvailable(this.mySuppressAction);
    }
}

