/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedLibraries;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedLibrariesInspection
extends GlobalInspectionTool {
    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "getAnnotator"));
        }
        return new UnusedLibraryGraphAnnotator(refManager);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "checkElement"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "checkElement"));
        }
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module2 = refModule.getModule();
            if (module2.isDisposed() || !scope.containsModule(module2)) {
                return CommonProblemDescriptor.EMPTY_ARRAY;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            Set usedRoots = (Set)refModule.getUserData(UnusedLibraryGraphAnnotator.USED_LIBRARY_ROOTS);
            ArrayList<CommonProblemDescriptor> result2 = new ArrayList<CommonProblemDescriptor>();
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).isExported()) continue;
                if (usedRoots == null) {
                    String message = InspectionsBundle.message((String)"unused.library.problem.descriptor", (Object[])new Object[]{entry.getPresentableName()});
                    result2.add(manager.createProblemDescriptor(message, new QuickFix[]{new RemoveUnusedLibrary(refModule, entry, null)}));
                    continue;
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>(Arrays.asList(((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)));
                files.removeAll(usedRoots);
                if (files.isEmpty()) continue;
                String unusedLibraryRoots = StringUtil.join(files, file2 -> file2.getPresentableName(), (String)",");
                String message = InspectionsBundle.message((String)"unused.library.roots.problem.descriptor", (Object[])new Object[]{unusedLibraryRoots, entry.getPresentableName()});
                processor2.addProblemElement((RefEntity)refModule, new CommonProblemDescriptor[]{manager.createProblemDescriptor(message, new QuickFix[]{new RemoveUnusedLibrary(refModule, entry, files)})});
            }
            return result2.isEmpty() ? null : result2.toArray(new CommonProblemDescriptor[result2.size()]);
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"unused.library.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("UnusedLibrary" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection", "getShortName"));
        }
        return "UnusedLibrary";
    }

    private static class UnusedLibraryGraphAnnotator
    extends RefGraphAnnotator {
        public static final Key<Set<VirtualFile>> USED_LIBRARY_ROOTS = Key.create((String)"inspection.dependencies");
        private final ProjectFileIndex myFileIndex;
        private final RefManager myManager;

        public UnusedLibraryGraphAnnotator(RefManager manager) {
            this.myManager = manager;
            this.myFileIndex = ProjectRootManager.getInstance((Project)manager.getProject()).getFileIndex();
        }

        public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
            if (what != null && from != null) {
                RefModule refModule;
                Module fromModule;
                VirtualFile libraryClassRoot;
                VirtualFile containingDir;
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)what);
                VirtualFile virtualFile2 = containingDir = virtualFile != null ? virtualFile.getParent() : null;
                if (containingDir != null && (libraryClassRoot = this.myFileIndex.getClassRootForFile(containingDir)) != null && (fromModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)from)) != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                    HashSet<VirtualFile> modules = (HashSet<VirtualFile>)refModule.getUserData(USED_LIBRARY_ROOTS);
                    if (modules == null) {
                        modules = new HashSet<VirtualFile>();
                        refModule.putUserData(USED_LIBRARY_ROOTS, modules);
                    }
                    modules.add(libraryClassRoot);
                }
            }
        }
    }

    private static class RemoveUnusedLibrary
    implements QuickFix {
        private final RefModule myRefModule;
        private final OrderEntry myOrderEntry;
        private final Set<VirtualFile> myFiles;

        public RemoveUnusedLibrary(RefModule refModule, OrderEntry orderEntry, Set<VirtualFile> files) {
            this.myRefModule = refModule;
            this.myOrderEntry = orderEntry;
            this.myFiles = files;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myFiles == null ? InspectionsBundle.message((String)"detach.library.quickfix.name", (Object[])new Object[0]) : InspectionsBundle.message((String)"detach.library.roots.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary", "applyFix"));
            }
            Module module2 = this.myRefModule.getModule();
            ApplicationManager.getApplication().runWriteAction(() -> {
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                for (OrderEntry entry : model.getOrderEntries()) {
                    if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)this.myOrderEntry.getPresentableName())) continue;
                    if (this.myFiles == null) {
                        model.removeOrderEntry(entry);
                        continue;
                    }
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    Library.ModifiableModel modifiableModel = library.getModifiableModel();
                    for (VirtualFile file2 : this.myFiles) {
                        modifiableModel.removeRoot(file2.getUrl(), OrderRootType.CLASSES);
                    }
                    modifiableModel.commit();
                }
                model.commit();
            });
        }
    }
}

