/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexFeature;
import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexFeaturesHolder;
import com.intellij.compiler.classFilesIndex.chainsSearch.ChainCompletionStringUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.ChainsSearcher;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodsChain;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodsChainLookupRangingHelper;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.CompletionContributorPatternUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ContextUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.TargetType;
import com.intellij.compiler.classFilesIndex.impl.MethodsUsageIndexReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodsChainsCompletionContributor
extends CompletionContributor {
    private static final boolean IS_UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    public static final int INVOCATIONS_THRESHOLD = 2;
    public static final CompletionType COMPLETION_TYPE = IS_UNIT_TEST_MODE ? CompletionType.BASIC : CompletionType.SMART;
    private static final int MAX_SEARCH_RESULT_SIZE = 5;
    private static final int MAX_CHAIN_SIZE = 4;
    private static final int FILTER_RATIO = 10;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/compiler/classFilesIndex/chainsSearch/completion/MethodsChainsCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/classFilesIndex/chainsSearch/completion/MethodsChainsCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getInvocationCount() >= 2 && ClassFilesIndexFeaturesHolder.getInstance(parameters.getPosition().getProject()).enableFeatureIfNeed(ClassFilesIndexFeature.METHOD_CHAINS_COMPLETION)) {
            super.fillCompletionVariants(parameters, result2);
        }
    }

    public MethodsChainsCompletionContributor() {
        ElementPattern pattern = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{CompletionContributorPatternUtil.patternForMethodParameter(), CompletionContributorPatternUtil.patternForVariableAssignment()});
        this.extend(COMPLETION_TYPE, pattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/compiler/classFilesIndex/chainsSearch/completion/MethodsChainsCompletionContributor$1", "addCompletions"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/classFilesIndex/chainsSearch/completion/MethodsChainsCompletionContributor$1", "addCompletions"));
                }
                ChainCompletionContext completionContext = MethodsChainsCompletionContributor.extractContext(parameters);
                if (completionContext == null) {
                    return;
                }
                Set<String> contextTypesKeysSet = completionContext.getContextTypes();
                HashSet<String> contextRelevantTypes = new HashSet<String>(contextTypesKeysSet.size() + 1);
                for (String type : contextTypesKeysSet) {
                    if (ChainCompletionStringUtil.isPrimitiveOrArrayOfPrimitives(type)) continue;
                    contextRelevantTypes.add(type);
                }
                TargetType target = completionContext.getTarget();
                contextRelevantTypes.remove(target.getClassQName());
                List elementsFoundByMethodsChainsSearch = MethodsChainsCompletionContributor.searchForLookups(target, contextRelevantTypes, completionContext);
                if (!IS_UNIT_TEST_MODE) {
                    result2.runRemainingContributors(parameters, completionResult -> {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/classFilesIndex/chainsSearch/completion/MethodsChainsCompletionContributor$1", "lambda$addCompletions$0"));
                        }
                        LookupElement lookupElement = completionResult.getLookupElement();
                        PsiElement lookupElementPsi = lookupElement.getPsiElement();
                        if (lookupElementPsi != null) {
                            for (LookupElement element : elementsFoundByMethodsChainsSearch) {
                                if (!lookupElementPsi.isEquivalentTo(element.getPsiElement())) continue;
                                elementsFoundByMethodsChainsSearch.remove(element);
                                break;
                            }
                        }
                        result2.passResult(completionResult);
                    });
                } else {
                    result2.stopHere();
                }
                result2.addAllElements((Iterable)elementsFoundByMethodsChainsSearch);
            }
        });
    }

    private static List<LookupElement> searchForLookups(TargetType target, Set<String> contextRelevantTypes, ChainCompletionContext completionContext) {
        Project project2 = completionContext.getProject();
        MethodsUsageIndexReader methodsUsageIndexReader = MethodsUsageIndexReader.getInstance(project2);
        List<MethodsChain> searchResult = MethodsChainsCompletionContributor.searchChains(target, contextRelevantTypes, 5, 4, completionContext, methodsUsageIndexReader);
        if (searchResult.size() < 5 && !target.isArray()) {
            SmartList inheritorFilteredSearchResult = new SmartList();
            Processor consumer = arg_0 -> MethodsChainsCompletionContributor.lambda$searchForLookups$0(contextRelevantTypes, completionContext, methodsUsageIndexReader, searchResult, (List)inheritorFilteredSearchResult, arg_0);
            DirectClassInheritorsSearch.search((PsiClass)((PsiClassType)target.getPsiType()).resolve()).forEach(psiClass -> {
                String inheritorQName = psiClass.getQualifiedName();
                if (inheritorQName == null) {
                    return true;
                }
                return consumer.process((Object)new TargetType(inheritorQName, false, (PsiType)new PsiImmediateClassType((PsiClass)psiClass, PsiSubstitutor.EMPTY)));
            });
        }
        List<MethodsChain> chains = searchResult.size() > 4 ? MethodsChainsCompletionContributor.chooseHead(searchResult) : searchResult;
        return MethodsChainLookupRangingHelper.chainsToWeightableLookupElements(MethodsChainsCompletionContributor.filterTailAndGetSumLastMethodOccurrence(chains), completionContext);
    }

    private static List<MethodsChain> chooseHead(List<MethodsChain> elements) {
        Collections.sort(elements, (o1, o2) -> o2.getChainWeight() - o1.getChainWeight());
        return elements.subList(0, 4);
    }

    @Nullable
    private static ChainCompletionContext extractContext(CompletionParameters parameters) {
        PsiParameter[] methodParameters;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{PsiAssignmentExpression.class, PsiLocalVariable.class, PsiMethodCallExpression.class});
        if (parent == null) {
            return null;
        }
        if (parent instanceof PsiAssignmentExpression) {
            return MethodsChainsCompletionContributor.tryExtractContextFromAssignment((PsiAssignmentExpression)parent);
        }
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)parent;
            return ContextUtil.createContext(localVariable.getType(), localVariable.getName(), PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDeclarationStatement.class));
        }
        PsiMethod method2 = ((PsiMethodCallExpression)parent).resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiExpression.class);
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiExpressionList.class);
        if (expressionList == null) {
            return null;
        }
        int exprPosition = Arrays.asList(expressionList.getExpressions()).indexOf(expression);
        if (exprPosition < (methodParameters = method2.getParameterList().getParameters()).length) {
            PsiParameter methodParameter = methodParameters[exprPosition];
            return ContextUtil.createContext(methodParameter.getType(), null, PsiTreeUtil.getParentOfType((PsiElement)expression, PsiDeclarationStatement.class));
        }
        return null;
    }

    @Nullable
    private static ChainCompletionContext tryExtractContextFromAssignment(PsiAssignmentExpression assignmentExpression) {
        PsiType type = assignmentExpression.getLExpression().getType();
        PsiIdentifier identifier = (PsiIdentifier)PsiTreeUtil.getChildOfType((PsiElement)assignmentExpression.getLExpression(), PsiIdentifier.class);
        if (identifier == null) {
            return null;
        }
        String identifierText = identifier.getText();
        return ContextUtil.createContext(type, identifierText, (PsiElement)assignmentExpression);
    }

    private static List<MethodsChain> filterTailAndGetSumLastMethodOccurrence(List<MethodsChain> chains) {
        int maxWeight = 0;
        for (MethodsChain chain : chains) {
            int chainWeight = chain.getChainWeight();
            if (chainWeight <= maxWeight) continue;
            maxWeight = chainWeight;
        }
        ArrayList<MethodsChain> filteredResult = new ArrayList<MethodsChain>();
        for (MethodsChain chain : chains) {
            int chainWeight = chain.getChainWeight();
            if (chainWeight * 10 < maxWeight) continue;
            filteredResult.add(chain);
        }
        return filteredResult;
    }

    private static List<MethodsChain> searchChains(TargetType target, Set<String> contextVarsQNames, int maxResultSize, int maxChainSize, ChainCompletionContext context, MethodsUsageIndexReader methodsUsageIndexReader) {
        return ChainsSearcher.search(maxChainSize, target, contextVarsQNames, maxResultSize, context, methodsUsageIndexReader);
    }

    private static /* synthetic */ boolean lambda$searchForLookups$0(Set contextRelevantTypes, ChainCompletionContext completionContext, MethodsUsageIndexReader methodsUsageIndexReader, List searchResult, List inheritorFilteredSearchResult, TargetType targetType) {
        for (MethodsChain chain : MethodsChainsCompletionContributor.searchChains(targetType, contextRelevantTypes, 5, 4, completionContext, methodsUsageIndexReader)) {
            boolean insert = true;
            for (MethodsChain baseChain : searchResult) {
                MethodsChain.CompareResult r = MethodsChain.compare(baseChain, chain, completionContext.getPsiManager());
                if (r == MethodsChain.CompareResult.NOT_EQUAL) continue;
                insert = false;
                break;
            }
            if (!insert) continue;
            inheritorFilteredSearchResult.add(chain);
        }
        searchResult.addAll(inheritorFilteredSearchResult);
        return searchResult.size() < 5;
    }
}

