/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub;

import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.ChainCompletionLookupElementUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.SubLookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import org.jetbrains.annotations.Nullable;

public class StaticMethodSubLookupElement
implements SubLookupElement {
    private final PsiMethod myMethod;
    private final TIntObjectHashMap<SubLookupElement> myReplaceElements;

    public StaticMethodSubLookupElement(PsiMethod method2, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements) {
        assert (method2.hasModifierProperty("static"));
        this.myReplaceElements = replaceElements;
        this.myMethod = method2;
    }

    @Override
    public void doImport(final PsiJavaFile javaFile) {
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (containingClass != null && javaFile.findImportReferenceTo(containingClass) == null) {
            javaFile.importClass(containingClass);
        }
        if (this.myReplaceElements != null) {
            this.myReplaceElements.forEachValue((TObjectProcedure)new TObjectProcedure<SubLookupElement>(){

                public boolean execute(SubLookupElement subLookupElement) {
                    subLookupElement.doImport(javaFile);
                    return false;
                }
            });
        }
    }

    @Override
    public String getInsertString() {
        return String.format("%s.%s(%s)", this.myMethod.getContainingClass().getName(), this.myMethod.getName(), ChainCompletionLookupElementUtil.fillMethodParameters(this.myMethod, this.myReplaceElements));
    }
}

