/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor
implements ApplicationComponent {
    public static boolean ourDebugMode = false;
    private static final Function<Collection<File>, Void> NOTIFY_CHANGED = files -> {
        TranslatingCompilerFilesMonitor.notifyFilesChanged(files);
        return null;
    };
    private static final Function<Collection<File>, Void> NOTIFY_DELETED = files -> {
        TranslatingCompilerFilesMonitor.notifyFilesDeleted(files);
        return null;
    };

    public TranslatingCompilerFilesMonitor(VirtualFileManager vfsManager, Application application) {
        vfsManager.addVirtualFileListener((VirtualFileListener)new MyVfsListener(), (Disposable)application);
    }

    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    @NotNull
    public String getComponentName() {
        if ("TranslatingCompilerFilesMonitor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor", "getComponentName"));
        }
        return "TranslatingCompilerFilesMonitor";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static void processRecursively(final VirtualFile fromFile, final boolean dbOnly, final FileProcessor processor2) {
        if (!(fromFile.getFileSystem() instanceof LocalFileSystem)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "visitFileEx"));
                }
                if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file2)) {
                    VirtualFileVisitor.Result result2 = SKIP_CHILDREN;
                    if (result2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "visitFileEx"));
                    }
                    return result2;
                }
                if (!file2.isDirectory()) {
                    processor2.execute(file2);
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "visitFileEx"));
                }
                return result3;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "getChildrenIterable"));
                }
                if (dbOnly) {
                    return file2.isDirectory() ? ((NewVirtualFile)file2).iterInDbChildren() : null;
                }
                if (file2.equals(fromFile) || !file2.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file2) ? null : ((NewVirtualFile)file2).iterInDbChildren();
            }
        });
    }

    private static boolean isInContentOfOpenedProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor", "isInContentOfOpenedProject"));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || !BuildManager.getInstance().isProjectWatched(project2) || !ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2)) continue;
            return true;
        }
        return false;
    }

    private static void collectPathsAndNotify(VirtualFile file2, Function<Collection<File>, Void> notification) {
        THashSet pathsToMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (!TranslatingCompilerFilesMonitor.isIgnoredOrUnderIgnoredDirectory(file2)) {
            boolean inContent = TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file2);
            TranslatingCompilerFilesMonitor.processRecursively(file2, !inContent, new FileProcessor((Set)pathsToMark){
                final /* synthetic */ Set val$pathsToMark;
                {
                    this.val$pathsToMark = set2;
                }

                @Override
                public void execute(VirtualFile file2) {
                    this.val$pathsToMark.add(new File(file2.getPath()));
                }
            });
        }
        if (!pathsToMark.isEmpty()) {
            notification.fun((Object)pathsToMark);
        }
    }

    private static boolean isIgnoredOrUnderIgnoredDirectory(VirtualFile file2) {
        if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file2)) {
            return true;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile current = file2.getParent(); current != null; current = current.getParent()) {
            if (!fileTypeManager.isFileIgnored(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredByBuild(VirtualFile file2) {
        return FileTypeManager.getInstance().isFileIgnored(file2) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2) || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)file2.getPath(), (boolean)false);
    }

    private static void notifyFilesChanged(Collection<File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesChanged(paths);
        }
    }

    private static void notifyFilesDeleted(Collection<File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesDeleted(paths);
        }
    }

    private static class MyVfsListener
    extends VirtualFileAdapter {
        private MyVfsListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile eventFile;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName()) && TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(eventFile = event.getFile())) {
                VirtualFile parent = event.getParent();
                if (parent != null) {
                    String oldName = (String)event.getOldValue();
                    final String root = parent.getPath() + "/" + oldName;
                    THashSet toMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    if (eventFile.isDirectory()) {
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)eventFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)toMark){
                            private StringBuilder filePath;
                            final /* synthetic */ Set val$toMark;
                            {
                                this.val$toMark = set2;
                                super(arg0);
                                this.filePath = new StringBuilder(root);
                            }

                            public boolean visitFile(@NotNull VirtualFile child) {
                                if (child == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener$1", "visitFile"));
                                }
                                if (child.isDirectory()) {
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        this.filePath.append("/").append(child.getName());
                                    }
                                } else {
                                    String childPath = this.filePath.toString();
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        childPath = childPath + "/" + child.getName();
                                    }
                                    this.val$toMark.add(new File(childPath));
                                }
                                return true;
                            }

                            public void afterChildrenVisited(@NotNull VirtualFile file2) {
                                if (file2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener$1", "afterChildrenVisited"));
                                }
                                if (file2.isDirectory() && !Comparing.equal((Object)file2, (Object)eventFile)) {
                                    this.filePath.delete(this.filePath.length() - file2.getName().length() - 1, this.filePath.length());
                                }
                            }
                        });
                    } else {
                        toMark.add(new File(root));
                    }
                    TranslatingCompilerFilesMonitor.notifyFilesDeleted((Collection)toMark);
                }
                TranslatingCompilerFilesMonitor.collectPathsAndNotify(eventFile, (Function<Collection<File>, Void>)NOTIFY_CHANGED);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "contentsChanged"));
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Function<Collection<File>, Void>)NOTIFY_CHANGED);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "fileCreated"));
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Function<Collection<File>, Void>)NOTIFY_CHANGED);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "fileCopied"));
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Function<Collection<File>, Void>)NOTIFY_CHANGED);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "fileMoved"));
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Function<Collection<File>, Void>)NOTIFY_CHANGED);
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "beforeFileDeletion"));
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Function<Collection<File>, Void>)NOTIFY_DELETED);
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "beforeFileMovement"));
            }
            TranslatingCompilerFilesMonitor.collectPathsAndNotify(event.getFile(), (Function<Collection<File>, Void>)NOTIFY_DELETED);
        }
    }

    private static interface FileProcessor {
        public void execute(VirtualFile var1);
    }
}

