/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.google.protobuf.MessageLite;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.AutoMakeMessageHandler;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.BuildMessageDispatcher;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.compiler.server.PreloadedProcessMessageHandler;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.internal.ThreadLocalRandom;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.api.TaskFutureAdapter;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.Launcher;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class BuildManager
implements Disposable {
    public static final Key<Boolean> ALLOW_AUTOMAKE = Key.create((String)"_allow_automake_when_process_is_active_");
    private static final Key<Integer> COMPILER_PROCESS_DEBUG_PORT = Key.create((String)"_compiler_process_debug_port_");
    private static final Key<String> FORCE_MODEL_LOADING_PARAMETER = Key.create((String)"_force_model_loading");
    private static final Key<CharSequence> STDERR_OUTPUT = Key.create((String)"_process_launch_errors_");
    private static final SimpleDateFormat USAGE_STAMP_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildManager");
    private static final String COMPILER_PROCESS_JDK_PROPERTY = "compiler.process.jdk";
    public static final String SYSTEM_ROOT = "compile-server";
    public static final String TEMP_DIR_NAME = "_temp_";
    private final boolean IS_UNIT_TEST_MODE;
    private static final String IWS_EXTENSION = ".iws";
    private static final String IPR_EXTENSION = ".ipr";
    private static final String IDEA_PROJECT_DIR_PATTERN = "/.idea/";
    private static final Function<String, Boolean> PATH_FILTER = SystemInfo.isFileSystemCaseSensitive ? s -> !s.contains(IDEA_PROJECT_DIR_PATTERN) && !s.endsWith(IWS_EXTENSION) && !s.endsWith(IPR_EXTENSION) : s -> !StringUtil.endsWithIgnoreCase((String)s, (String)IWS_EXTENSION) && !StringUtil.endsWithIgnoreCase((String)s, (String)IPR_EXTENSION) && !StringUtil.containsIgnoreCase((String)s, (String)IDEA_PROJECT_DIR_PATTERN);
    private final File mySystemDirectory;
    private final ProjectManager myProjectManager;
    private final Map<TaskFuture, Project> myAutomakeFutures = Collections.synchronizedMap(new HashMap());
    private final Map<String, RequestFuture> myBuildsInProgress = Collections.synchronizedMap(new HashMap());
    private final Map<String, Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>>> myPreloadedBuilds = Collections.synchronizedMap(new HashMap());
    private final BuildProcessClasspathManager myClasspathManager = new BuildProcessClasspathManager();
    private final ExecutorService myRequestsProcessor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager requestProcessor pool");
    private final Map<String, ProjectData> myProjectDataMap = Collections.synchronizedMap(new HashMap());
    private final BuildManagerPeriodicTask myAutoMakeTask = new BuildManagerPeriodicTask(this){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.automake.trigger.delay");
        }

        @Override
        protected void runTask() {
            BuildManager.this.runAutoMake();
        }
    };
    private final BuildManagerPeriodicTask myDocumentSaveTask = new BuildManagerPeriodicTask(this){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.document.save.trigger.delay");
        }

        @Override
        public void runTask() {
            if (this.shouldSaveDocuments()) {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false));
            }
        }

        private boolean shouldSaveDocuments() {
            Project contextProject = BuildManager.this.getCurrentContextProject();
            return contextProject != null && BuildManager.canStartAutoMake(contextProject);
        }
    };
    private final Runnable myGCTask = () -> {
        int unusedThresholdDays = Registry.intValue((String)"compiler.build.data.unused.threshold", (int)-1);
        if (unusedThresholdDays <= 0) {
            return;
        }
        File buildSystemDir = this.getBuildSystemDirectory();
        File[] dirs = buildSystemDir.listFiles(pathname -> pathname.isDirectory() && !TEMP_DIR_NAME.equals(pathname.getName()));
        if (dirs != null) {
            Date now = new Date();
            for (File buildDataProjectDir : dirs) {
                File usageFile = BuildManager.getUsageFile(buildDataProjectDir);
                if (usageFile.exists()) {
                    File projectFile;
                    Pair<Date, File> usageData = BuildManager.readUsageFile(usageFile);
                    if (usageData == null || ((projectFile = (File)usageData.second) == null || projectFile.exists()) && DateFormatUtil.getDifferenceInDays((Date)((Date)usageData.first), (Date)now) <= (long)unusedThresholdDays) continue;
                    LOG.info("Clearing project build data because the project does not exist or was not opened for more than " + unusedThresholdDays + " days: " + buildDataProjectDir.getPath());
                    FileUtil.delete((File)buildDataProjectDir);
                    continue;
                }
                BuildManager.updateUsageFile(null, buildDataProjectDir);
            }
        }
    };
    private final ChannelRegistrar myChannelRegistrar = new ChannelRegistrar();
    private final BuildMessageDispatcher myMessageDispatcher = new BuildMessageDispatcher();
    private volatile int myListenPort = -1;
    @NotNull
    private final Charset mySystemCharset = CharsetToolkit.getDefaultSystemCharset();
    private volatile boolean myBuildProcessDebuggingEnabled;

    public BuildManager(ProjectManager projectManager) {
        Application application = ApplicationManager.getApplication();
        this.IS_UNIT_TEST_MODE = application.isUnitTestMode();
        this.myProjectManager = projectManager;
        String systemPath = PathManager.getSystemPath();
        File system = new File(systemPath);
        try {
            system = system.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        this.mySystemDirectory = system;
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectWatcher());
        MessageBusConnection conn = application.getMessageBus().connect();
        conn.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/compiler/server/BuildManager$3", "after"));
                }
                if (!BuildManager.this.IS_UNIT_TEST_MODE && this.shouldTriggerMake(events)) {
                    BuildManager.this.scheduleAutoMake();
                }
            }

            private boolean shouldTriggerMake(List<? extends VFileEvent> events) {
                if (PowerSaveMode.isEnabled()) {
                    return false;
                }
                Project project2 = null;
                ProjectFileIndex fileIndex = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile eventFile = vFileEvent.getFile();
                    if (eventFile == null) continue;
                    if (!eventFile.isValid()) {
                        return true;
                    }
                    if (project2 == null) {
                        project2 = BuildManager.this.getCurrentContextProject();
                        if (project2 == null) {
                            return false;
                        }
                        fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                    }
                    if (!fileIndex.isInContent(eventFile) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)eventFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)eventFile, (Project)project2)) continue;
                    return true;
                }
                return false;
            }
        });
        conn.subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener.Adapter(){

            @Override
            public void batchChangeStarted(Project project2) {
                BuildManager.this.cancelAutoMakeTasks(project2);
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                VirtualFile file2;
                Document document = e.getDocument();
                if (FileDocumentManager.getInstance().isDocumentUnsaved(document) && (file2 = FileDocumentManager.getInstance().getFile(document)) != null && file2.isInLocalFileSystem()) {
                    BuildManager.this.scheduleProjectSave();
                }
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(this::stopListening);
        ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.runCommand(this.myGCTask), 3L, 180L, TimeUnit.MINUTES);
        Disposer.register((Disposable)this, () -> future2.cancel(false));
    }

    private List<Project> getOpenProjects() {
        Project[] projects = this.myProjectManager.getOpenProjects();
        if (projects.length == 0) {
            return Collections.emptyList();
        }
        SmartList projectList = new SmartList();
        for (Project project2 : projects) {
            if (!BuildManager.isValidProject(project2)) continue;
            projectList.add(project2);
        }
        return projectList;
    }

    private static boolean isValidProject(@Nullable Project project2) {
        return project2 != null && !project2.isDisposed() && !project2.isDefault() && project2.isInitialized();
    }

    public static BuildManager getInstance() {
        return (BuildManager)ApplicationManager.getApplication().getComponent(BuildManager.class);
    }

    public void notifyFilesChanged(Collection<File> paths) {
        this.doNotify(paths, false);
    }

    public void notifyFilesDeleted(Collection<File> paths) {
        this.doNotify(paths, true);
    }

    public void runCommand(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/compiler/server/BuildManager", "runCommand"));
        }
        this.myRequestsProcessor.submit(command);
    }

    private void doNotify(Collection<File> paths, boolean notifyDeletion) {
        this.runCommand(() -> {
            ArrayList<String> filtered = new ArrayList<String>(paths.size());
            for (File file2 : paths) {
                String path = FileUtil.toSystemIndependentName((String)file2.getPath());
                if (!((Boolean)PATH_FILTER.fun((Object)path)).booleanValue()) continue;
                filtered.add(path);
            }
            if (filtered.isEmpty()) {
                return;
            }
            Map<String, ProjectData> map = this.myProjectDataMap;
            synchronized (map) {
                for (Map.Entry<String, ProjectData> entry : this.myProjectDataMap.entrySet()) {
                    UUID sessionId;
                    Channel channel;
                    RequestFuture future2;
                    ProjectData data = entry.getValue();
                    if (notifyDeletion) {
                        data.addDeleted(filtered);
                    } else {
                        data.addChanged(filtered);
                    }
                    if ((future2 = this.myBuildsInProgress.get(entry.getKey())) == null || future2.isCancelled() || future2.isDone() || (channel = this.myMessageDispatcher.getConnectedChannel(sessionId = future2.getRequestID())) == null) continue;
                    CmdlineRemoteProto.Message.ControllerMessage message = CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.FS_EVENT).setFsEvent(data.createNextEvent()).build();
                    channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)message));
                }
            }
        });
    }

    public static void forceModelLoading(CompileContext context) {
        context.getCompileScope().putUserData(FORCE_MODEL_LOADING_PARAMETER, (Object)Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(Project project2) {
        String projectPath = BuildManager.getProjectPath(project2);
        this.cancelPreloadedBuilds(projectPath);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null) {
                data.dropChanges();
            }
        }
        this.scheduleAutoMake();
    }

    public boolean isProjectWatched(Project project2) {
        return this.myProjectDataMap.containsKey(BuildManager.getProjectPath(project2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFilesChangedSinceLastCompilation(Project project2) {
        String projectPath = BuildManager.getProjectPath(project2);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null && !data.myNeedRescan) {
                return BuildManager.convertToStringPaths(data.myChanged);
            }
            return null;
        }
    }

    private static List<String> convertToStringPaths(Collection<InternedPath> interned) {
        ArrayList<String> list = new ArrayList<String>(interned.size());
        for (InternedPath path : interned) {
            list.add(path.getValue());
        }
        return list;
    }

    @Nullable
    private static String getProjectPath(Project project2) {
        String url = project2.getPresentableUrl();
        if (url == null) {
            return null;
        }
        return VirtualFileManager.extractPath((String)url);
    }

    public void scheduleAutoMake() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            this.myAutoMakeTask.schedule();
        }
    }

    private void scheduleProjectSave() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            this.myAutoMakeTask.cancelPendingExecution();
            this.myDocumentSaveTask.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAutoMake() {
        Project project2 = this.getCurrentContextProject();
        if (project2 == null || !BuildManager.canStartAutoMake(project2)) {
            return;
        }
        List scopes = CmdlineProtoUtil.createAllModulesScopes((boolean)false);
        AutoMakeMessageHandler handler2 = new AutoMakeMessageHandler(project2);
        TaskFuture future2 = this.scheduleBuild(project2, false, true, false, scopes, Collections.emptyList(), Collections.emptyMap(), handler2);
        if (future2 != null) {
            this.myAutomakeFutures.put(future2, project2);
            try {
                future2.waitFor();
            }
            finally {
                this.myAutomakeFutures.remove(future2);
                if (handler2.unprocessedFSChangesDetected()) {
                    this.scheduleAutoMake();
                }
            }
        }
    }

    private static boolean canStartAutoMake(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager", "canStartAutoMake"));
        }
        if (project2.isDisposed()) {
            return false;
        }
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project2);
        if (!config.MAKE_PROJECT_ON_SAVE) {
            return false;
        }
        return config.allowAutoMakeWhileRunningApplication() || !BuildManager.hasRunningProcess(project2);
    }

    @Nullable
    private Project getCurrentContextProject() {
        return this.getContextProject(null);
    }

    @Nullable
    private Project getContextProject(@Nullable Window window) {
        Container _parent;
        List<Project> openProjects = this.getOpenProjects();
        if (openProjects.isEmpty()) {
            return null;
        }
        if (openProjects.size() == 1) {
            return openProjects.get(0);
        }
        if (window == null && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null) {
            return null;
        }
        Container comp = window;
        while ((_parent = comp.getParent()) != null) {
            comp = _parent;
        }
        Project project2 = null;
        if (comp instanceof IdeFrame) {
            project2 = ((IdeFrame)comp).getProject();
        }
        if (project2 == null) {
            project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)comp));
        }
        return BuildManager.isValidProject(project2) ? project2 : null;
    }

    private static boolean hasRunningProcess(Project project2) {
        for (ProcessHandler handler2 : ExecutionManager.getInstance((Project)project2).getRunningProcesses()) {
            if (handler2.isProcessTerminated() || ((Boolean)ALLOW_AUTOMAKE.get((UserDataHolder)handler2, (Object)Boolean.FALSE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskFuture> cancelAutoMakeTasks(Project project2) {
        SmartList futures = new SmartList();
        Map<TaskFuture, Project> map = this.myAutomakeFutures;
        synchronized (map) {
            for (Map.Entry<TaskFuture, Project> entry : this.myAutomakeFutures.entrySet()) {
                if (!entry.getValue().equals(project2)) continue;
                TaskFuture future2 = entry.getKey();
                future2.cancel(false);
                futures.add(future2);
            }
        }
        return futures;
    }

    private void cancelAllPreloadedBuilds() {
        String[] paths;
        for (String path : paths = ArrayUtil.toStringArray(this.myPreloadedBuilds.keySet())) {
            this.cancelPreloadedBuilds(path);
        }
    }

    private void cancelPreloadedBuilds(String projectPath) {
        this.runCommand(() -> {
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> pair = this.takePreloadedProcess(projectPath);
            if (pair != null) {
                RequestFuture future2 = (RequestFuture)pair.first;
                OSProcessHandler processHandler2 = (OSProcessHandler)pair.second;
                this.myMessageDispatcher.cancelSession(future2.getRequestID());
                this.getProjectData((String)projectPath).taskQueue.submit(() -> {
                    Throwable error = null;
                    try {
                        while (!processHandler2.waitFor()) {
                            LOG.info("processHandler.waitFor() returned false for session " + future2.getRequestID() + ", continue waiting");
                        }
                    }
                    catch (Throwable e) {
                        error = e;
                    }
                    finally {
                        this.notifySessionTerminationIfNeeded(future2.getRequestID(), error);
                    }
                });
            }
        });
    }

    @Nullable
    private Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> takePreloadedProcess(String projectPath) {
        Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> result2;
        Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> preloadProgress = this.myPreloadedBuilds.remove(projectPath);
        try {
            result2 = preloadProgress != null ? preloadProgress.get() : null;
        }
        catch (Throwable e) {
            LOG.info(e);
            result2 = null;
        }
        return result2 != null && !((RequestFuture)result2.first).isDone() ? result2 : null;
    }

    @Nullable
    public TaskFuture scheduleBuild(Project project2, boolean isRebuild, boolean isMake, boolean onlyCheckUpToDate, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Collection<String> paths, Map<String, String> userData, DefaultMessageHandler messageHandler) {
        String projectPath = BuildManager.getProjectPath(project2);
        boolean isAutomake = messageHandler instanceof AutoMakeMessageHandler;
        NotifyingMessageHandler handler2 = new NotifyingMessageHandler(project2, messageHandler, isAutomake);
        try {
            this.ensureListening();
        }
        catch (Exception e) {
            UUID sessionId = UUID.randomUUID();
            handler2.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), null));
            handler2.sessionTerminated(sessionId);
            return null;
        }
        DelegateFuture _future = new DelegateFuture();
        this.runCommand(() -> {
            UUID sessionId;
            boolean usingPreloadedProcess;
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> preloaded = this.takePreloadedProcess(projectPath);
            RequestFuture preloadedFuture = preloaded != null ? (RequestFuture)preloaded.first : null;
            boolean bl = usingPreloadedProcess = preloadedFuture != null;
            if (usingPreloadedProcess) {
                LOG.info("Using preloaded build process to compile " + projectPath);
                sessionId = preloadedFuture.getRequestID();
                ((PreloadedProcessMessageHandler)preloadedFuture.getMessageHandler()).setDelegateHandler(handler2);
            } else {
                sessionId = UUID.randomUUID();
            }
            RequestFuture future2 = usingPreloadedProcess ? preloadedFuture : new RequestFuture((Object)handler2, sessionId, new CancelBuildSessionAction());
            TaskFuture[] delegatesToWait = new TaskFuture[]{future2};
            if (!usingPreloadedProcess && (future2.isCancelled() || project2.isDisposed())) {
                handler2.sessionTerminated(sessionId);
                future2.setDone();
            } else {
                ExecutorService projectTaskQueue;
                CmdlineRemoteProto.Message.ControllerMessage.FSEvent currentFSChanges;
                boolean needRescan;
                CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings.newBuilder().setGlobalOptionsPath(PathManager.getOptionsPath()).build();
                Map<String, ProjectData> map = this.myProjectDataMap;
                synchronized (map) {
                    ProjectData data = this.getProjectData(projectPath);
                    if (isRebuild) {
                        data.dropChanges();
                    }
                    if (this.IS_UNIT_TEST_MODE) {
                        LOG.info("Scheduling build for " + projectPath + "; CHANGED: " + new HashSet<String>(BuildManager.convertToStringPaths(data.myChanged)) + "; DELETED: " + new HashSet<String>(BuildManager.convertToStringPaths(data.myDeleted)));
                    }
                    currentFSChanges = (needRescan = data.getAndResetRescanFlag()) ? null : data.createNextEvent();
                    projectTaskQueue = data.taskQueue;
                }
                CmdlineRemoteProto.Message.ControllerMessage params = isRebuild ? CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, Collections.emptyList(), (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, null) : (onlyCheckUpToDate ? CmdlineProtoUtil.createUpToDateCheckRequest((String)projectPath, (List)scopes, (Collection)paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges) : CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, isMake ? Collections.emptyList() : paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges));
                if (!usingPreloadedProcess) {
                    this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future2, params);
                }
                try {
                    Future<?> buildFuture = projectTaskQueue.submit(() -> {
                        Throwable execFailure = null;
                        try {
                            CharSequence errorsOnLaunch;
                            OSProcessHandler processHandler2;
                            if (project2.isDisposed()) {
                                if (usingPreloadedProcess) {
                                    future2.cancel(false);
                                } else {
                                    return;
                                }
                            }
                            this.myBuildsInProgress.put(projectPath, future2);
                            if (usingPreloadedProcess) {
                                boolean paramsSent = this.myMessageDispatcher.sendBuildParameters(future2.getRequestID(), params);
                                if (!paramsSent) {
                                    this.myMessageDispatcher.cancelSession(future2.getRequestID());
                                }
                                processHandler2 = (OSProcessHandler)preloaded.second;
                                errorsOnLaunch = (CharSequence)STDERR_OUTPUT.get((UserDataHolder)processHandler2);
                            } else {
                                if (isAutomake && needRescan) {
                                    try {
                                        TransactionGuard.getInstance().submitTransactionAndWait(() -> ((Project)project2).save());
                                    }
                                    catch (Throwable e) {
                                        LOG.info(e);
                                    }
                                }
                                processHandler2 = this.launchBuildProcess(project2, this.myListenPort, sessionId, false);
                                errorsOnLaunch = new StringBuffer();
                                processHandler2.addProcessListener((ProcessListener)new StdOutputCollector((Appendable)((Object)errorsOnLaunch)));
                                processHandler2.startNotify();
                            }
                            Integer debugPort = (Integer)processHandler2.getUserData(COMPILER_PROCESS_DEBUG_PORT);
                            if (debugPort != null) {
                                String message = "Build: waiting for debugger connection on port " + debugPort;
                                messageHandler.handleCompileMessage(sessionId, CmdlineProtoUtil.createCompileProgressMessageResponse((String)message).getCompileMessage());
                            }
                            while (!processHandler2.waitFor()) {
                                LOG.info("processHandler.waitFor() returned false for session " + sessionId + ", continue waiting");
                            }
                            int exitValue = processHandler2.getProcess().exitValue();
                            if (exitValue != 0) {
                                StringBuilder msg = new StringBuilder();
                                msg.append("Abnormal build process termination: ");
                                if (errorsOnLaunch != null && errorsOnLaunch.length() > 0) {
                                    msg.append("\n").append(errorsOnLaunch);
                                    if (StringUtil.contains((CharSequence)errorsOnLaunch, (CharSequence)"java.lang.NoSuchMethodError")) {
                                        msg.append("\nThe error may be caused by JARs in Java Extensions directory which conflicts with libraries used by the external build process.").append("\nTry adding -Djava.ext.dirs=\"\" argument to 'Build process VM options' in File | Settings | Build, Execution, Deployment | Compiler to fix the problem.");
                                    }
                                } else {
                                    msg.append("unknown error");
                                }
                                handler2.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)msg.toString(), null));
                            }
                        }
                        catch (Throwable e) {
                            execFailure = e;
                        }
                        finally {
                            this.myBuildsInProgress.remove(projectPath);
                            this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                            if (this.isProcessPreloadingEnabled(project2)) {
                                this.runCommand(() -> {
                                    if (!this.myPreloadedBuilds.containsKey(projectPath)) {
                                        try {
                                            Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> preloadResult = this.launchPreloadedBuildProcess(project2, projectTaskQueue);
                                            this.myPreloadedBuilds.put(projectPath, preloadResult);
                                        }
                                        catch (Throwable e) {
                                            LOG.info("Error pre-loading build process for project " + projectPath, e);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    delegatesToWait = new TaskFuture[]{future2, new TaskFutureAdapter(buildFuture)};
                }
                catch (Throwable e) {
                    this.handleProcessExecutionFailure(sessionId, e);
                }
            }
            boolean set2 = _future.setDelegates(delegatesToWait);
            assert (set2);
        });
        return _future;
    }

    private boolean isProcessPreloadingEnabled(Project project2) {
        if (this.IS_UNIT_TEST_MODE || !Registry.is((String)"compiler.process.preload") || this.myBuildProcessDebuggingEnabled) {
            return false;
        }
        if (project2.isDisposed()) {
            return true;
        }
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            if (provider.isProcessPreloadingEnabled()) continue;
            return false;
        }
        return true;
    }

    private void notifySessionTerminationIfNeeded(UUID sessionId, @Nullable Throwable execFailure) {
        BuilderMessageHandler unregistered;
        if (this.myMessageDispatcher.getAssociatedChannel(sessionId) == null && (unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
            if (execFailure != null) {
                unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)execFailure.getMessage(), (Throwable)execFailure));
            }
            unregistered.sessionTerminated(sessionId);
        }
    }

    private void handleProcessExecutionFailure(UUID sessionId, Throwable e) {
        BuilderMessageHandler unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId);
        if (unregistered != null) {
            unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), (Throwable)e));
            unregistered.sessionTerminated(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ProjectData getProjectData(String projectPath) {
        Map<String, ProjectData> map = this.myProjectDataMap;
        // MONITORENTER : map
        ProjectData data = this.myProjectDataMap.get(projectPath);
        if (data == null) {
            data = new ProjectData(SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager pool"));
            this.myProjectDataMap.put(projectPath, data);
        }
        ProjectData projectData = data;
        // MONITOREXIT : map
        if (projectData != null) return projectData;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager", "getProjectData"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureListening() throws Exception {
        if (this.myListenPort < 0) {
            BuildManager buildManager = this;
            synchronized (buildManager) {
                if (this.myListenPort < 0) {
                    this.myListenPort = this.startListening();
                }
            }
        }
    }

    public void dispose() {
        this.stopListening();
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getBuildProcessRuntimeSdk(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager", "getBuildProcessRuntimeSdk"));
        }
        Pair<Sdk, JavaSdkVersion> pair = BuildManager.getRuntimeSdk(project2, JavaSdkVersion.JDK_1_8);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager", "getBuildProcessRuntimeSdk"));
        }
        return pair;
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getJavacRuntimeSdk(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager", "getJavacRuntimeSdk"));
        }
        Pair<Sdk, JavaSdkVersion> pair = BuildManager.getRuntimeSdk(project2, JavaSdkVersion.JDK_1_6);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager", "getJavacRuntimeSdk"));
        }
        return pair;
    }

    private static Pair<Sdk, JavaSdkVersion> getRuntimeSdk(@NotNull Project project2, JavaSdkVersion oldestPossibleVersion) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager", "getRuntimeSdk"));
        }
        LinkedHashSet<Object> candidates = new LinkedHashSet<Object>();
        Sdk defaultSdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (defaultSdk != null && defaultSdk.getSdkType() instanceof JavaSdkType) {
            candidates.add(defaultSdk);
        }
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
            if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
            candidates.add(sdk);
        }
        JavaSdk javaSdkType = JavaSdk.getInstance();
        Sdk projectJdk = null;
        int sdkMinorVersion = 0;
        JavaSdkVersion sdkVersion = null;
        for (Sdk sdk : candidates) {
            JavaSdkVersion candidateVersion;
            String vs = sdk.getVersionString();
            if (vs == null || (candidateVersion = BuildManager.getSdkVersion(javaSdkType, vs)) == null) continue;
            int candidateMinorVersion = BuildManager.getMinorVersion(vs);
            if (projectJdk == null) {
                sdkVersion = candidateVersion;
                sdkMinorVersion = candidateMinorVersion;
                projectJdk = sdk;
                continue;
            }
            int result2 = candidateVersion.compareTo((Enum)sdkVersion);
            if (result2 <= 0 && (result2 != 0 || candidateMinorVersion <= sdkMinorVersion)) continue;
            sdkVersion = candidateVersion;
            sdkMinorVersion = candidateMinorVersion;
            projectJdk = sdk;
        }
        if (projectJdk == null || sdkVersion == null || !sdkVersion.isAtLeast(oldestPossibleVersion)) {
            Sdk internalJdk;
            projectJdk = internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            sdkVersion = javaSdkType.getVersion(internalJdk);
        }
        return Pair.create((Object)projectJdk, sdkVersion);
    }

    @Nullable
    private static JavaSdkVersion getSdkVersion(JavaSdk javaSdkType, String vs) {
        int parsed;
        JavaSdkVersion version = javaSdkType.getVersion(vs);
        if (version == null && (parsed = JpsJavaSdkType.parseVersion((String)vs)) > 0) {
            version = javaSdkType.getVersion(parsed + ".0");
        }
        return version;
    }

    private Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> launchPreloadedBuildProcess(Project project2, ExecutorService projectTaskQueue) throws Exception {
        this.ensureListening();
        return projectTaskQueue.submit(() -> {
            if (project2.isDisposed()) {
                return null;
            }
            RequestFuture future2 = new RequestFuture((Object)new PreloadedProcessMessageHandler(), UUID.randomUUID(), new CancelBuildSessionAction());
            try {
                this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future2, null);
                OSProcessHandler processHandler2 = this.launchBuildProcess(project2, this.myListenPort, future2.getRequestID(), true);
                StringBuffer errors = new StringBuffer();
                processHandler2.addProcessListener((ProcessListener)new StdOutputCollector(errors));
                STDERR_OUTPUT.set((UserDataHolder)processHandler2, (Object)errors);
                processHandler2.startNotify();
                return Pair.create((Object)future2, (Object)processHandler2);
            }
            catch (Throwable e) {
                this.handleProcessExecutionFailure(future2.getRequestID(), e);
                throw e instanceof Exception ? (Exception)e : new RuntimeException(e);
            }
        });
    }

    private OSProcessHandler launchBuildProcess(Project project2, int port, UUID sessionId, boolean requestProjectPreload) throws com.intellij.execution.ExecutionException {
        String[] propertiesToPass;
        String shouldGenerateIndex;
        String additionalOptions;
        String vmExecutablePath;
        String compilerPath;
        JavaSdkVersion sdkVersion = null;
        String forcedCompiledJdkHome = Registry.stringValue((String)COMPILER_PROCESS_JDK_PROPERTY);
        if (StringUtil.isEmptyOrSpaces((String)forcedCompiledJdkHome)) {
            Pair<Sdk, JavaSdkVersion> pair = BuildManager.getBuildProcessRuntimeSdk(project2);
            Sdk projectJdk = (Sdk)pair.first;
            sdkVersion = (JavaSdkVersion)pair.second;
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            JavaSdkType projectJdkType = (JavaSdkType)projectJdk.getSdkType();
            if (FileUtil.pathsEqual((String)projectJdk.getHomePath(), (String)internalJdk.getHomePath())) {
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                if (systemCompiler == null) {
                    throw new com.intellij.execution.ExecutionException("No system java compiler is provided by the JRE. Make sure tools.jar is present in IntelliJ IDEA classpath.");
                }
                compilerPath = ClasspathBootstrap.getResourcePath(systemCompiler.getClass());
            } else {
                compilerPath = projectJdkType.getToolsPath(projectJdk);
                if (compilerPath == null) {
                    throw new com.intellij.execution.ExecutionException("Cannot determine path to 'tools.jar' library for " + projectJdk.getName() + " (" + projectJdk.getHomePath() + ")");
                }
            }
            vmExecutablePath = projectJdkType.getVMExecutablePath(projectJdk);
        } else {
            compilerPath = new File(forcedCompiledJdkHome, "lib/tools.jar").getAbsolutePath();
            vmExecutablePath = new File(forcedCompiledJdkHome, "bin/java").getAbsolutePath();
        }
        CompilerConfiguration projectConfig = CompilerConfiguration.getInstance((Project)project2);
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project2);
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setExePath(vmExecutablePath);
        boolean isProfilingMode = false;
        String userDefinedHeapSize = null;
        SmartList userAdditionalOptionsList = new SmartList();
        String userAdditionalVMOptions = config.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        boolean userLocalOptionsActive = !StringUtil.isEmptyOrSpaces((String)userAdditionalVMOptions);
        String string = additionalOptions = userLocalOptionsActive ? userAdditionalVMOptions : projectConfig.getBuildProcessVMOptions();
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String option = tokenizer.nextToken();
                if (StringUtil.startsWithIgnoreCase((String)option, (String)"-Xmx")) {
                    if (!userLocalOptionsActive) continue;
                    userDefinedHeapSize = option;
                    continue;
                }
                if ("-Dprofiling.mode=true".equals(option)) {
                    isProfilingMode = true;
                }
                userAdditionalOptionsList.add(option);
            }
        }
        if (userDefinedHeapSize != null) {
            cmdLine.addParameter(userDefinedHeapSize);
        } else {
            int heapSize = projectConfig.getBuildProcessHeapSize(JavacConfiguration.getOptions((Project)project2, JavacConfiguration.class).MAXIMUM_HEAP_SIZE);
            cmdLine.addParameter("-Xmx" + heapSize + "m");
        }
        if (SystemInfo.isMac && sdkVersion != null && JavaSdkVersion.JDK_1_6.equals((Object)sdkVersion) && Registry.is((String)"compiler.process.32bit.vm.on.mac")) {
            cmdLine.addParameter("-d32");
        }
        cmdLine.addParameter("-Djava.awt.headless=true");
        if (sdkVersion != null && sdkVersion.ordinal() < JavaSdkVersion.JDK_1_9.ordinal()) {
            cmdLine.addParameter("-Djava.endorsed.dirs=\"\"");
        }
        if (this.IS_UNIT_TEST_MODE) {
            cmdLine.addParameter("-Dtest.mode=true");
        }
        cmdLine.addParameter("-Djdt.compiler.useSingleThread=true");
        if (requestProjectPreload) {
            cmdLine.addParameter("-Dpreload.project.path=" + FileUtil.toCanonicalPath((String)BuildManager.getProjectPath(project2)));
            cmdLine.addParameter("-Dpreload.config.path=" + FileUtil.toCanonicalPath((String)PathManager.getOptionsPath()));
        }
        if ((shouldGenerateIndex = System.getProperty("generate.classpath.index")) != null) {
            cmdLine.addParameter("-Dgenerate.classpath.index=" + shouldGenerateIndex);
        }
        cmdLine.addParameter("-Dcompile.parallel=" + Boolean.toString(config.PARALLEL_COMPILATION));
        cmdLine.addParameter("-Drebuild.on.dependency.change=" + Boolean.toString(config.REBUILD_ON_DEPENDENCY_CHANGE));
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")))) {
            cmdLine.addParameter("-Djava.net.preferIPv4Stack=true");
        }
        cmdLine.addParameter("-Dio.netty.initialSeedUniquifier=" + ThreadLocalRandom.getInitialSeedUniquifier());
        for (String option : userAdditionalOptionsList) {
            cmdLine.addParameter(option);
        }
        if (isProfilingMode) {
            cmdLine.addParameter("-agentlib:yjpagent=disablealloc,delay=10000,sessionname=ExternalBuild");
        }
        int debugPort = -1;
        if (this.myBuildProcessDebuggingEnabled) {
            debugPort = Registry.intValue((String)"compiler.process.debug.port");
            if (debugPort <= 0) {
                try {
                    debugPort = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    throw new com.intellij.execution.ExecutionException("Cannot find free port to debug build process", (Throwable)e);
                }
            }
            if (debugPort > 0) {
                cmdLine.addParameter("-XX:+HeapDumpOnOutOfMemoryError");
                cmdLine.addParameter("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
            }
        }
        if (!Registry.is((String)"compiler.process.use.memory.temp.cache")) {
            cmdLine.addParameter("-Duse.memory.temp.cache=false");
        }
        cmdLine.setCharset(this.mySystemCharset);
        cmdLine.addParameter("-Dfile.encoding=" + this.mySystemCharset.name());
        cmdLine.addParameter("-Djps.file.types.component.name=" + FileTypeManagerImpl.getFileTypeComponentName());
        for (String name : propertiesToPass = new String[]{"user.language", "user.country", "user.region", "idea.paths.selector", "idea.case.sensitive.fs"}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            cmdLine.addParameter("-D" + name + "=" + value);
        }
        cmdLine.addParameter("-Didea.home.path=" + PathManager.getHomePath());
        cmdLine.addParameter("-Didea.config.path=" + PathManager.getConfigPath());
        cmdLine.addParameter("-Didea.plugins.path=" + PathManager.getPluginsPath());
        cmdLine.addParameter("-Djps.log.dir=" + FileUtil.toSystemIndependentName((String)this.getBuildLogDirectory().getAbsolutePath()));
        cmdLine.addParameter("-Djps.fallback.jdk.home=" + FileUtil.toSystemIndependentName((String)SystemProperties.getJavaHome()));
        cmdLine.addParameter("-Djps.fallback.jdk.version=" + SystemProperties.getJavaVersion());
        File workDirectory = this.getBuildSystemDirectory();
        workDirectory.mkdirs();
        cmdLine.addParameter("-Djava.io.tmpdir=" + FileUtil.toSystemIndependentName((String)workDirectory.getPath()) + "/" + TEMP_DIR_NAME);
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            List<String> args = provider.getVMArguments();
            cmdLine.addParameters(args);
        }
        Class<Launcher> launcherClass = Launcher.class;
        ArrayList<String> launcherCp = new ArrayList<String>();
        launcherCp.add(ClasspathBootstrap.getResourcePath(launcherClass));
        launcherCp.addAll(BuildProcessClasspathManager.getLauncherClasspath(project2));
        launcherCp.add(compilerPath);
        ClasspathBootstrap.appendJavaCompilerClasspath(launcherCp, (boolean)this.shouldIncludeEclipseCompiler(projectConfig));
        cmdLine.addParameter("-classpath");
        cmdLine.addParameter(BuildManager.classpathToString(launcherCp));
        cmdLine.addParameter(launcherClass.getName());
        List cp = ClasspathBootstrap.getBuildProcessApplicationClasspath();
        cp.addAll(this.myClasspathManager.getBuildProcessPluginsClasspath(project2));
        if (isProfilingMode) {
            cp.add(new File(workDirectory, "yjp-controller-api-redist.jar").getPath());
        }
        cmdLine.addParameter(BuildManager.classpathToString(cp));
        cmdLine.addParameter(BuildMain.class.getName());
        cmdLine.addParameter(Boolean.valueOf(System.getProperty("java.net.preferIPv6Addresses", "false")) != false ? "::1" : "127.0.0.1");
        cmdLine.addParameter(Integer.toString(port));
        cmdLine.addParameter(sessionId.toString());
        cmdLine.addParameter(FileUtil.toSystemIndependentName((String)workDirectory.getPath()));
        cmdLine.setWorkDirectory(workDirectory);
        try {
            ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).beforeBuildProcessStarted(project2, sessionId);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        OSProcessHandler processHandler2 = new OSProcessHandler(cmdLine){

            protected boolean shouldDestroyProcessRecursively() {
                return true;
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager$6", "readerOptions"));
                }
                return options;
            }
        };
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    LOG.info("BUILDER_PROCESS [" + outputType.toString() + "]: " + text.trim());
                }
            }
        });
        if (debugPort > 0) {
            processHandler2.putUserData(COMPILER_PROCESS_DEBUG_PORT, (Object)debugPort);
        }
        return processHandler2;
    }

    private boolean shouldIncludeEclipseCompiler(CompilerConfiguration config) {
        if (config instanceof CompilerConfigurationImpl) {
            BackendCompiler javaCompiler = ((CompilerConfigurationImpl)config).getDefaultCompiler();
            String compilerId = javaCompiler != null ? javaCompiler.getId() : null;
            return "Eclipse".equals(compilerId) || "EclipseEmbedded".equals(compilerId);
        }
        return true;
    }

    public File getBuildSystemDirectory() {
        return new File(this.mySystemDirectory, SYSTEM_ROOT);
    }

    public File getBuildLogDirectory() {
        return new File(PathManager.getLogPath(), "build-log");
    }

    @Nullable
    public File getProjectSystemDirectory(Project project2) {
        String projectPath = BuildManager.getProjectPath(project2);
        return projectPath != null ? Utils.getDataStorageRoot((File)this.getBuildSystemDirectory(), (String)projectPath) : null;
    }

    private static File getUsageFile(@NotNull File projectSystemDir) {
        if (projectSystemDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemDir", "com/intellij/compiler/server/BuildManager", "getUsageFile"));
        }
        return new File(projectSystemDir, "ustamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUsageFile(@Nullable Project project2, @NotNull File projectSystemDir) {
        if (projectSystemDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemDir", "com/intellij/compiler/server/BuildManager", "updateUsageFile"));
        }
        File usageFile = BuildManager.getUsageFile(projectSystemDir);
        StringBuilder content = new StringBuilder();
        try {
            String projectFilePath;
            SimpleDateFormat simpleDateFormat = USAGE_STAMP_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                content.append(USAGE_STAMP_DATE_FORMAT.format(System.currentTimeMillis()));
            }
            if (project2 != null && !project2.isDisposed() && !StringUtil.isEmptyOrSpaces((String)(projectFilePath = project2.getProjectFilePath()))) {
                content.append("\n").append(FileUtil.toCanonicalPath((String)projectFilePath));
            }
            FileUtil.writeToFile((File)usageFile, (String)content.toString());
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Pair<Date, File> readUsageFile(File usageFile) {
        block5: {
            try {
                Date date;
                List lines = FileUtil.loadLines((File)usageFile, (String)CharsetToolkit.UTF8_CHARSET.name());
                if (lines.isEmpty()) break block5;
                String dateString = (String)lines.get(0);
                SimpleDateFormat simpleDateFormat = USAGE_STAMP_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    date = USAGE_STAMP_DATE_FORMAT.parse(dateString);
                }
                File projectFile = lines.size() > 1 ? new File((String)lines.get(1)) : null;
                return Pair.create((Object)date, (Object)projectFile);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return null;
    }

    private static int getMinorVersion(String vs) {
        int dashIndex = vs.lastIndexOf(95);
        if (dashIndex >= 0) {
            char ch;
            StringBuilder builder = new StringBuilder();
            for (int idx = dashIndex + 1; idx < vs.length() && Character.isDigit(ch = vs.charAt(idx)); ++idx) {
                builder.append(ch);
            }
            if (builder.length() > 0) {
                try {
                    return Integer.parseInt(builder.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    private void stopListening() {
        this.myListenPort = -1;
        this.myChannelRegistrar.close();
    }

    private int startListening() throws Exception {
        BuiltInServer mainServer = StartupUtil.getServer();
        boolean isOwnEventLoopGroup = !Registry.is((String)"compiler.shared.event.group", (boolean)true) || mainServer == null || mainServer.getEventLoopGroup() instanceof OioEventLoopGroup;
        Object group = isOwnEventLoopGroup ? new NioEventLoopGroup(1, ConcurrencyUtil.newNamedThreadFactory((String)"External compiler")) : mainServer.getEventLoopGroup();
        ServerBootstrap bootstrap = NettyKt.serverBootstrap(group);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(@NotNull Channel channel) throws Exception {
                if (channel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/compiler/server/BuildManager$8", "initChannel"));
                }
                channel.pipeline().addLast(new ChannelHandler[]{BuildManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), BuildManager.this.myMessageDispatcher});
            }
        });
        Channel serverChannel = bootstrap.bind(InetAddress.getLoopbackAddress(), 0).syncUninterruptibly().channel();
        this.myChannelRegistrar.setServerChannel(serverChannel, isOwnEventLoopGroup);
        return ((InetSocketAddress)serverChannel.localAddress()).getPort();
    }

    private static String classpathToString(List<String> cp) {
        StringBuilder builder = new StringBuilder();
        for (String file2 : cp) {
            if (builder.length() > 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(FileUtil.toCanonicalPath((String)file2));
        }
        return builder.toString();
    }

    public boolean isBuildProcessDebuggingEnabled() {
        return this.myBuildProcessDebuggingEnabled;
    }

    public void setBuildProcessDebuggingEnabled(boolean buildProcessDebuggingEnabled) {
        this.myBuildProcessDebuggingEnabled = buildProcessDebuggingEnabled;
        if (this.myBuildProcessDebuggingEnabled) {
            this.cancelAllPreloadedBuilds();
        }
    }

    private class CancelBuildSessionAction<T extends BuilderMessageHandler>
    implements RequestFuture.CancelAction<T> {
        private CancelBuildSessionAction() {
        }

        public void cancel(RequestFuture<T> future2) throws Exception {
            BuildManager.this.myMessageDispatcher.cancelSession(future2.getRequestID());
        }
    }

    private static final class DelegateFuture
    implements TaskFuture {
        @Nullable
        private TaskFuture[] myDelegates;
        private Boolean myRequestedCancelState;

        private DelegateFuture() {
        }

        @NotNull
        private synchronized TaskFuture[] getDelegates() {
            TaskFuture[] delegates = this.myDelegates;
            while (delegates == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delegates = this.myDelegates;
            }
            if (delegates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager$DelegateFuture", "getDelegates"));
            }
            return delegates;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean setDelegates(TaskFuture ... delegates) {
            if (delegates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegates", "com/intellij/compiler/server/BuildManager$DelegateFuture", "setDelegates"));
            }
            if (this.myDelegates == null) {
                try {
                    this.myDelegates = delegates;
                    if (this.myRequestedCancelState != null) {
                        for (TaskFuture delegate : delegates) {
                            delegate.cancel(this.myRequestedCancelState.booleanValue());
                        }
                    }
                }
                finally {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            TaskFuture[] delegates = this.myDelegates;
            if (delegates == null) {
                this.myRequestedCancelState = mayInterruptIfRunning;
                return true;
            }
            Stream.of(delegates).forEach(delegate -> delegate.cancel(mayInterruptIfRunning));
            return this.isDone();
        }

        public void waitFor() {
            Stream.of(this.getDelegates()).forEach(TaskFuture::waitFor);
        }

        public boolean waitFor(long timeout, TimeUnit unit) {
            Stream.of(this.getDelegates()).forEach(delegate -> delegate.waitFor(timeout, unit));
            return this.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            TaskFuture[] delegates;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegates = this.myDelegates;
                if (delegates == null) {
                    return this.myRequestedCancelState != null;
                }
            }
            return Stream.of(delegates).anyMatch(Future::isCancelled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            TaskFuture[] delegates;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegates = this.myDelegates;
                if (delegates == null) {
                    return false;
                }
            }
            return Stream.of(delegates).allMatch(Future::isDone);
        }

        public Object get() throws InterruptedException, ExecutionException {
            for (TaskFuture delegate : this.getDelegates()) {
                delegate.get();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Object get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (timeUnit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/compiler/server/BuildManager$DelegateFuture", "get"));
            }
            for (TaskFuture delegate : this.getDelegates()) {
                void unit;
                delegate.get(timeout, (TimeUnit)unit);
            }
            return null;
        }
    }

    private static class XInternedPath
    extends InternedPath {
        private XInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length > 0) {
                StringBuilder buf = new StringBuilder();
                for (int element : this.myPath) {
                    buf.append("/").append(FileNameCache.getVFileName(element));
                }
                return buf.toString();
            }
            return "/";
        }
    }

    private static class WinInternedPath
    extends InternedPath {
        private WinInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length == 1) {
                String name = FileNameCache.getVFileName(this.myPath[0]).toString();
                return name.length() == 2 && name.endsWith(":") ? name + "/" : name;
            }
            StringBuilder buf = new StringBuilder();
            for (int element : this.myPath) {
                if (buf.length() > 0) {
                    buf.append("/");
                }
                buf.append(FileNameCache.getVFileName(element));
            }
            return buf.toString();
        }
    }

    private static abstract class InternedPath {
        protected final int[] myPath;

        protected InternedPath(String path) {
            IntArrayList list = new IntArrayList();
            StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                list.add(FileNameCache.storeName(element));
            }
            this.myPath = list.toArray();
        }

        public abstract String getValue();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedPath path = (InternedPath)o;
            return Arrays.equals(this.myPath, path.myPath);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myPath);
        }

        public static InternedPath create(String path) {
            return path.startsWith("/") ? new XInternedPath(path) : new WinInternedPath(path);
        }
    }

    private static class ProjectData {
        @NotNull
        final ExecutorService taskQueue;
        private final Set<InternedPath> myChanged;
        private final Set<InternedPath> myDeleted;
        private long myNextEventOrdinal;
        private boolean myNeedRescan;

        private ProjectData(@NotNull ExecutorService taskQueue) {
            if (taskQueue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskQueue", "com/intellij/compiler/server/BuildManager$ProjectData", "<init>"));
            }
            this.myChanged = new THashSet();
            this.myDeleted = new THashSet();
            this.myNeedRescan = true;
            this.taskQueue = taskQueue;
        }

        public void addChanged(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myDeleted.remove(_path);
                    this.myChanged.add(_path);
                }
            }
        }

        public void addDeleted(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myChanged.remove(_path);
                    this.myDeleted.add(_path);
                }
            }
        }

        public CmdlineRemoteProto.Message.ControllerMessage.FSEvent createNextEvent() {
            CmdlineRemoteProto.Message.ControllerMessage.FSEvent.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.FSEvent.newBuilder();
            builder.setOrdinal(++this.myNextEventOrdinal);
            for (InternedPath path : this.myChanged) {
                builder.addChangedPaths(path.getValue());
            }
            this.myChanged.clear();
            for (InternedPath path : this.myDeleted) {
                builder.addDeletedPaths(path.getValue());
            }
            this.myDeleted.clear();
            return builder.build();
        }

        public boolean getAndResetRescanFlag() {
            boolean rescan = this.myNeedRescan;
            this.myNeedRescan = false;
            return rescan;
        }

        public void dropChanges() {
            this.myNeedRescan = true;
            this.myNextEventOrdinal = 0L;
            this.myChanged.clear();
            this.myDeleted.clear();
        }
    }

    private class ProjectWatcher
    extends ProjectManagerAdapter {
        private final Map<Project, MessageBusConnection> myConnections = new HashMap<Project, MessageBusConnection>();

        private ProjectWatcher() {
        }

        public void projectOpened(final Project project2) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MessageBusConnection conn = project2.getMessageBus().connect();
            this.myConnections.put(project2, conn);
            conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                public void rootsChanged(ModuleRootEvent event) {
                    Object source = event.getSource();
                    if (source instanceof Project) {
                        BuildManager.this.clearState((Project)source);
                    }
                }
            });
            conn.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                    if (executorId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    if (env == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    if (handler2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    BuildManager.this.scheduleAutoMake();
                }
            });
            conn.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                private final Set<String> myRootsToRefresh = new THashSet(FileUtil.PATH_HASHING_STRATEGY);

                public void automakeCompilationFinished(int errors, int warnings, CompileContext compileContext) {
                    if (!compileContext.getProgressIndicator().isCanceled()) {
                        this.refreshSources(compileContext);
                    }
                }

                public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    this.refreshSources(compileContext);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void refreshSources(CompileContext compileContext) {
                    if (project2.isDisposed()) {
                        return;
                    }
                    THashSet candidates = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                    Set<String> set2 = this.myRootsToRefresh;
                    synchronized (set2) {
                        candidates.addAll(this.myRootsToRefresh);
                        this.myRootsToRefresh.clear();
                    }
                    if (compileContext.isAnnotationProcessorsEnabled()) {
                        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project2);
                        for (Module module2 : compileContext.getCompileScope().getAffectedModules()) {
                            String testsPath;
                            if (!config.getAnnotationProcessingConfiguration(module2).isEnabled()) continue;
                            String productionPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module2, (boolean)false);
                            if (productionPath != null) {
                                candidates.add(productionPath);
                            }
                            if ((testsPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module2, (boolean)true)) == null) continue;
                            candidates.add(testsPath);
                        }
                    }
                    if (!candidates.isEmpty()) {
                        ApplicationManager.getApplication().executeOnPooledThread(() -> 3.lambda$refreshSources$2(project2, (Set)candidates));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileGenerated(String outputRoot, String relativePath) {
                    Set<String> set2 = this.myRootsToRefresh;
                    synchronized (set2) {
                        this.myRootsToRefresh.add(outputRoot);
                    }
                }

                private static /* synthetic */ void lambda$refreshSources$2(Project project22, Set candidates) {
                    if (project22.isDisposed()) {
                        return;
                    }
                    CompilerUtil.refreshOutputRoots(candidates);
                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project22).getFileIndex();
                    Set toRefresh = (Set)ReadAction.compute(() -> {
                        if (project22.isDisposed()) {
                            return Collections.emptySet();
                        }
                        return candidates.stream().map(arg_0 -> ((LocalFileSystem)lfs).findFileByPath(arg_0)).filter(root -> root != null && fileIndex.isInSourceContent(root)).collect(Collectors.toSet());
                    });
                    if (!toRefresh.isEmpty()) {
                        lfs.refreshFiles((Iterable)toRefresh, true, true, null);
                    }
                }
            });
            final String projectPath = BuildManager.getProjectPath(project2);
            Disposer.register((Disposable)project2, (Disposable)new Disposable(){

                public void dispose() {
                    BuildManager.this.cancelPreloadedBuilds(projectPath);
                    BuildManager.this.myProjectDataMap.remove(projectPath);
                }
            });
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> {
                BuildManager.this.runCommand(() -> {
                    File projectSystemDir = BuildManager.this.getProjectSystemDirectory(project2);
                    if (projectSystemDir != null) {
                        BuildManager.updateUsageFile(project2, projectSystemDir);
                    }
                });
                BuildManager.this.scheduleAutoMake();
            });
        }

        public boolean canCloseProject(Project project2) {
            BuildManager.this.cancelAutoMakeTasks(project2);
            return super.canCloseProject(project2);
        }

        public void projectClosing(Project project2) {
            BuildManager.this.cancelPreloadedBuilds(BuildManager.getProjectPath(project2));
            for (TaskFuture future2 : BuildManager.this.cancelAutoMakeTasks(project2)) {
                future2.waitFor(500L, TimeUnit.MILLISECONDS);
            }
        }

        public void projectClosed(Project project2) {
            BuildManager.this.myProjectDataMap.remove(BuildManager.getProjectPath(project2));
            MessageBusConnection conn = this.myConnections.remove(project2);
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static final class StdOutputCollector
    extends ProcessAdapter {
        private final Appendable myOutput;
        private int myStoredLength;

        StdOutputCollector(@NotNull Appendable outputSink) {
            if (outputSink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputSink", "com/intellij/compiler/server/BuildManager$StdOutputCollector", "<init>"));
            }
            this.myOutput = outputSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTextAvailable(ProcessEvent event, Key outputType) {
            String text;
            StdOutputCollector stdOutputCollector = this;
            synchronized (stdOutputCollector) {
                if (this.myStoredLength > 16384) {
                    return;
                }
                text = event.getText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    return;
                }
                this.myStoredLength += text.length();
            }
            try {
                this.myOutput.append(text);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class NotifyingMessageHandler
    extends DelegatingMessageHandler {
        private final Project myProject;
        private final BuilderMessageHandler myDelegateHandler;
        private final boolean myIsAutomake;

        public NotifyingMessageHandler(@NotNull Project project2, @NotNull BuilderMessageHandler delegateHandler, boolean isAutomake) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler", "<init>"));
            }
            if (delegateHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateHandler", "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler", "<init>"));
            }
            this.myProject = project2;
            this.myDelegateHandler = delegateHandler;
            this.myIsAutomake = isAutomake;
        }

        @Override
        protected BuilderMessageHandler getDelegateHandler() {
            return this.myDelegateHandler;
        }

        @Override
        public void buildStarted(UUID sessionId) {
            super.buildStarted(sessionId);
            try {
                ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildStarted(this.myProject, sessionId, this.myIsAutomake);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void sessionTerminated(UUID sessionId) {
            try {
                super.sessionTerminated(sessionId);
            }
            finally {
                try {
                    ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildFinished(this.myProject, sessionId, this.myIsAutomake);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private static abstract class BuildManagerPeriodicTask
    implements Runnable {
        private final Alarm myAlarm;
        private final AtomicBoolean myInProgress;
        private final Runnable myTaskRunnable;

        protected BuildManagerPeriodicTask(@NotNull Disposable disposable) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/compiler/server/BuildManager$BuildManagerPeriodicTask", "<init>"));
            }
            this.myInProgress = new AtomicBoolean(false);
            this.myTaskRunnable = () -> {
                try {
                    this.runTask();
                }
                finally {
                    this.myInProgress.set(false);
                }
            };
            this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, disposable);
        }

        public final void schedule() {
            this.cancelPendingExecution();
            int delay = Math.max(100, this.getDelay());
            this.myAlarm.addRequest((Runnable)this, delay);
        }

        public void cancelPendingExecution() {
            this.myAlarm.cancelAllRequests();
        }

        protected abstract int getDelay();

        protected abstract void runTask();

        @Override
        public final void run() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && !this.myInProgress.getAndSet(true)) {
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(this.myTaskRunnable);
                }
                catch (RejectedExecutionException ignored) {
                    this.myInProgress.set(false);
                }
                catch (Throwable e) {
                    this.myInProgress.set(false);
                    throw new RuntimeException(e);
                }
            } else {
                this.schedule();
            }
        }
    }
}

