/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import java.io.InputStream;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamProviderWrapper
implements StreamProvider {
    private StreamProvider myStreamProvider;

    @Nullable
    public static StreamProvider getOriginalProvider(@Nullable StreamProvider provider) {
        if (provider instanceof StreamProviderWrapper) {
            return ((StreamProviderWrapper)provider).myStreamProvider;
        }
        return null;
    }

    public void setStreamProvider(@Nullable StreamProvider streamProvider) {
        this.myStreamProvider = streamProvider;
    }

    public boolean getEnabled() {
        return this.myStreamProvider != null && this.myStreamProvider.getEnabled();
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/configurationStore/StreamProviderWrapper", "isApplicable"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/configurationStore/StreamProviderWrapper", "isApplicable"));
        }
        return this.getEnabled() && this.myStreamProvider.isApplicable(fileSpec, roamingType);
    }

    @Nullable
    public InputStream read(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/configurationStore/StreamProviderWrapper", "read"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/configurationStore/StreamProviderWrapper", "read"));
        }
        return this.myStreamProvider.read(fileSpec, roamingType);
    }

    public void processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/configurationStore/StreamProviderWrapper", "processChildren"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/configurationStore/StreamProviderWrapper", "processChildren"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/configurationStore/StreamProviderWrapper", "processChildren"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/configurationStore/StreamProviderWrapper", "processChildren"));
        }
        this.myStreamProvider.processChildren(path, roamingType, filter, processor2);
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/configurationStore/StreamProviderWrapper", "write"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/configurationStore/StreamProviderWrapper", "write"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/configurationStore/StreamProviderWrapper", "write"));
        }
        this.myStreamProvider.write(fileSpec, content, size, roamingType);
    }

    public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/configurationStore/StreamProviderWrapper", "delete"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/configurationStore/StreamProviderWrapper", "delete"));
        }
        this.myStreamProvider.delete(fileSpec, roamingType);
    }
}

