/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SimplePropertyGetterProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JavaSimpleGetterProvider
implements SimplePropertyGetterProvider {
    public boolean isInsideSimpleGetter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/debugger/engine/JavaSimpleGetterProvider", "isInsideSimpleGetter"));
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method2 == null) {
            return false;
        }
        PsiCodeBlock body = method2.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement2 = statements[0];
        if (!(statement2 instanceof PsiReturnStatement)) {
            return false;
        }
        PsiExpression value = ((PsiReturnStatement)statement2).getReturnValue();
        if (!(value instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier != null && !"this".equals(qualifier.getText())) {
            return false;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return false;
        }
        if (!(referent instanceof PsiField)) {
            return false;
        }
        return Comparing.equal((Object)((PsiField)referent).getContainingClass(), (Object)method2.getContainingClass());
    }
}

