/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;

class LiteralEvaluator
implements Evaluator {
    private final Object myValue;
    private final String myExpectedType;

    public LiteralEvaluator(Object value, String expectedType) {
        this.myValue = value;
        this.myExpectedType = expectedType;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (this.myValue == null) {
            return null;
        }
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        if (this.myValue instanceof Boolean) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, (Boolean)this.myValue);
        }
        if (this.myValue instanceof Character) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Character)this.myValue).charValue());
        }
        if (this.myValue instanceof Double) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).doubleValue());
        }
        if (this.myValue instanceof Float) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).floatValue());
        }
        if (this.myValue instanceof Number) {
            return DebuggerUtilsEx.createValue(vm, this.myExpectedType, ((Number)this.myValue).longValue());
        }
        if (this.myValue instanceof String) {
            return vm.mirrorOf((String)this.myValue);
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{this.myExpectedType}));
    }

    public String toString() {
        return this.myValue != null ? this.myValue.toString() : "null";
    }
}

