/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnBoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;
    private static final Map<String, Couple<String>> TYPES_TO_CONVERSION_METHOD_MAP = new HashMap();

    public static boolean isTypeUnboxable(String typeName) {
        return TYPES_TO_CONVERSION_METHOD_MAP.containsKey(typeName);
    }

    public UnBoxingEvaluator(@NotNull Evaluator operand) {
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/debugger/engine/evaluation/expression/UnBoxingEvaluator", "<init>"));
        }
        this.myOperand = new DisableGC(operand);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return UnBoxingEvaluator.unbox(this.myOperand.evaluate(context), context);
    }

    public static Object unbox(@Nullable Object value, EvaluationContextImpl context) throws EvaluateException {
        String valueTypeName;
        Couple<String> pair;
        if (value == null) {
            throw new EvaluateException("java.lang.NullPointerException: cannot unbox null value");
        }
        if (value instanceof ObjectReference && (pair = TYPES_TO_CONVERSION_METHOD_MAP.get(valueTypeName = ((ObjectReference)value).type().name())) != null) {
            return UnBoxingEvaluator.convertToPrimitive(context, (ObjectReference)value, (String)pair.getFirst(), (String)pair.getSecond());
        }
        return value;
    }

    private static Value convertToPrimitive(EvaluationContextImpl context, ObjectReference value, String conversionMethodName, String conversionMethodSignature) throws EvaluateException {
        DebugProcessImpl process2 = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)value.referenceType();
        List<Method> methods = wrapperClass.methodsByName(conversionMethodName, conversionMethodSignature);
        if (methods.size() == 0) {
            throw new EvaluateException("Cannot convert to primitive value of type " + value.type() + ": Unable to find method " + conversionMethodName + conversionMethodSignature);
        }
        return process2.invokeMethod((EvaluationContext)context, value, methods.get(0), Collections.emptyList());
    }

    static {
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Boolean", (Couple<String>)Couple.of((Object)"booleanValue", (Object)"()Z"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Byte", (Couple<String>)Couple.of((Object)"byteValue", (Object)"()B"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Character", (Couple<String>)Couple.of((Object)"charValue", (Object)"()C"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Short", (Couple<String>)Couple.of((Object)"shortValue", (Object)"()S"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Integer", (Couple<String>)Couple.of((Object)"intValue", (Object)"()I"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Long", (Couple<String>)Couple.of((Object)"longValue", (Object)"()J"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Float", (Couple<String>)Couple.of((Object)"floatValue", (Object)"()F"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Double", (Couple<String>)Couple.of((Object)"doubleValue", (Object)"()D"));
    }
}

