/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.apiAdapters.TransportServiceWrapper;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUtilsImpl
extends DebuggerUtilsEx {
    public static final Key<PsiType> PSI_TYPE_KEY = Key.create((String)"PSI_TYPE_KEY");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsImpl");

    public PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue, StackFrameContext context) throws EvaluateException {
        return DebuggerTreeNodeExpression.substituteThis((PsiElement)expressionWithThis, howToEvaluateThis, howToEvaluateThisValue);
    }

    @Override
    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    @Override
    public DebuggerTreeNode getSelectedNode(DataContext context) {
        return DebuggerAction.getSelectedNode(context);
    }

    public DebuggerContextImpl getDebuggerContext(DataContext context) {
        return DebuggerAction.getDebuggerContext(context);
    }

    public Element writeTextWithImports(TextWithImports text) {
        Element element = new Element("TextWithImports");
        element.setAttribute("text", text.toExternalForm());
        element.setAttribute("type", text.getKind() == CodeFragmentKind.EXPRESSION ? "expression" : "code fragment");
        return element;
    }

    public TextWithImports readTextWithImports(Element element) {
        LOG.assertTrue("TextWithImports".equals(element.getName()));
        String text = element.getAttributeValue("text");
        if ("expression".equals(element.getAttributeValue("type"))) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text);
        }
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, text);
    }

    public void writeTextWithImports(Element root, String name, TextWithImports value) {
        if (value.getKind() == CodeFragmentKind.EXPRESSION) {
            JDOMExternalizerUtil.writeField((Element)root, (String)name, (String)value.toExternalForm());
        } else {
            Element element = JDOMExternalizerUtil.writeOption((Element)root, (String)name);
            XExpression expression = TextWithImportsImpl.toXExpression(value);
            if (expression != null) {
                XmlSerializer.serializeInto((Object)new XExpressionState(expression), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
            }
        }
    }

    public TextWithImports readTextWithImports(Element root, String name) {
        String s = JDOMExternalizerUtil.readField((Element)root, (String)name);
        if (s != null) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, s);
        }
        Element option = JDOMExternalizerUtil.getOption((Element)root, (String)name);
        if (option != null) {
            XExpressionState state = new XExpressionState();
            XmlSerializer.deserializeInto((Object)state, (Element)option);
            return TextWithImportsImpl.fromXExpression(state.toXExpression());
        }
        return null;
    }

    public TextWithImports createExpressionWithImports(String expression) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression);
    }

    public PsiElement getContextElement(StackFrameContext context) {
        return PositionUtil.getContextElement(context);
    }

    @NotNull
    public static Pair<PsiElement, PsiType> getPsiClassAndType(@Nullable String className, Project project2) {
        PsiClass contextClass = null;
        PsiPrimitiveType contextType = null;
        if (!StringUtil.isEmpty((String)className)) {
            PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(className);
            if (primitiveType != null) {
                contextClass = JavaPsiFacade.getInstance((Project)project2).findClass(primitiveType.getBoxedTypeName(), GlobalSearchScope.allScope((Project)project2));
                contextType = primitiveType;
            } else {
                contextClass = DebuggerUtilsImpl.findClass((String)className, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
                if (contextClass != null) {
                    contextClass = contextClass.getNavigationElement();
                }
                if (contextClass instanceof PsiCompiledElement) {
                    contextClass = ((PsiCompiledElement)contextClass).getMirror();
                }
                contextType = DebuggerUtilsImpl.getType((String)className, (Project)project2);
            }
            if (contextClass != null) {
                contextClass.putUserData(PSI_TYPE_KEY, (Object)contextType);
            }
        }
        Pair pair = Pair.create(contextClass, contextType);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerUtilsImpl", "getPsiClassAndType"));
        }
        return pair;
    }

    public PsiClass chooseClassDialog(String title, Project project2) {
        TreeClassChooser dialog2 = TreeClassChooserFactory.getInstance((Project)project2).createAllProjectScopeChooser(title);
        dialog2.showDialog();
        return dialog2.getSelected();
    }

    public String findAvailableDebugAddress(boolean useSockets) throws ExecutionException {
        if (useSockets) {
            int freePort;
            try {
                freePort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException(DebugProcessImpl.processError(e));
            }
            return Integer.toString(freePort);
        }
        TransportServiceWrapper transportService = TransportServiceWrapper.getTransportService(false);
        try {
            return DebuggerUtilsImpl.tryShmemConnect(transportService, null);
        }
        catch (IOException e) {
            int tryNum = 0;
            while (true) {
                try {
                    return DebuggerUtilsImpl.tryShmemConnect(transportService, "javadebug_" + (int)(Math.random() * 1000.0));
                }
                catch (Exception ex) {
                    if (tryNum++ <= 10) continue;
                    throw new ExecutionException(DebugProcessImpl.processError(ex));
                }
                break;
            }
        }
    }

    private static String tryShmemConnect(TransportServiceWrapper transportService, String address) throws IOException {
        TransportService.ListenKey listenKey = transportService.startListening(address);
        address = listenKey.address();
        transportService.stopListening(listenKey);
        return address;
    }

    public static boolean isRemote(DebugProcess debugProcess) {
        return Boolean.TRUE.equals(debugProcess.getUserData(BatchEvaluator.REMOTE_SESSION_KEY));
    }

    public static <T, E extends Exception> T suppressExceptions(SupplierThrowing<T, E> supplier, T defaultValue) throws E {
        return DebuggerUtilsImpl.suppressExceptions(supplier, defaultValue, true, null);
    }

    public static <T, E extends Exception> T suppressExceptions(SupplierThrowing<T, E> supplier, T defaultValue, boolean ignorePCE, Class<E> rethrow) throws E {
        try {
            return supplier.get();
        }
        catch (ProcessCanceledException e) {
            if (!ignorePCE) {
                throw e;
            }
        }
        catch (ObjectCollectedException | VMDisconnectedException e) {
            throw e;
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        catch (AssertionError | Exception e) {
            if (rethrow != null && rethrow.isInstance(e)) {
                throw e;
            }
            LOG.error((Throwable)e);
        }
        return defaultValue;
    }

    public static <T> T runInReadActionWithWriteActionPriorityWithRetries(@NotNull Computable<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/debugger/impl/DebuggerUtilsImpl", "runInReadActionWithWriteActionPriorityWithRetries"));
        }
        Ref res = Ref.create();
        while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/debugger/impl/DebuggerUtilsImpl", "lambda$runInReadActionWithWriteActionPriorityWithRetries$0"));
            }
            res.set(action.compute());
        })) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return (T)res.get();
    }

    public static interface SupplierThrowing<T, E extends Throwable> {
        public T get() throws E;
    }
}

