/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BasicRendererProperties
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BasicRendererProperties");
    @NonNls
    private static final String NAME_OPTION = "NAME";
    private String myName;
    @NonNls
    private static final String ENABLED_OPTION = "ENABLED";
    private boolean myEnabled;
    @NonNls
    private static final String CLASSNAME_OPTION = "QUALIFIED_NAME";
    private String myClassName;
    @NonNls
    private static final String SHOW_TYPE_OPTION = "SHOW_TYPE";
    private boolean myShowType = true;
    private final boolean myEnabledDefaultValue;

    public BasicRendererProperties(boolean enabledDefaultValue) {
        this.myEnabledDefaultValue = enabledDefaultValue;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(String className) {
        this.myClassName = className;
    }

    public boolean isShowType() {
        return this.myShowType;
    }

    public void setShowType(boolean showType) {
        this.myShowType = showType;
    }

    public void readExternal(Element element) {
        this.myName = null;
        this.myClassName = null;
        for (Element option : element.getChildren("option")) {
            String optionName;
            switch (optionName = option.getAttributeValue("name")) {
                case "NAME": {
                    this.myName = option.getAttributeValue("value");
                    break;
                }
                case "ENABLED": {
                    String value = option.getAttributeValue("value");
                    if (value == null) break;
                    this.myEnabled = Boolean.parseBoolean(value);
                    break;
                }
                case "QUALIFIED_NAME": {
                    this.myClassName = option.getAttributeValue("value");
                    break;
                }
                case "SHOW_TYPE": {
                    this.myShowType = !"false".equalsIgnoreCase(option.getAttributeValue("value"));
                }
            }
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/debugger/ui/tree/render/BasicRendererProperties", "writeExternal"));
        }
        if (this.myName != null) {
            JDOMExternalizerUtil.writeField((Element)element, (String)NAME_OPTION, (String)this.myName);
        }
        if (this.myEnabled != this.myEnabledDefaultValue) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ENABLED_OPTION, (String)Boolean.toString(this.myEnabled));
        }
        if (this.myClassName != null) {
            JDOMExternalizerUtil.writeField((Element)element, (String)CLASSNAME_OPTION, (String)this.myClassName);
        }
        if (!this.myShowType) {
            JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_TYPE_OPTION, (String)Boolean.toString(this.myShowType));
        }
    }

    public BasicRendererProperties clone() {
        try {
            return (BasicRendererProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

