/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BasicRendererProperties;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeRendererImpl
implements NodeRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.NodeRendererImpl");
    protected BasicRendererProperties myProperties;

    protected NodeRendererImpl() {
        this("unnamed");
    }

    protected NodeRendererImpl(@NotNull String presentableName) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/debugger/ui/tree/render/NodeRendererImpl", "<init>"));
        }
        this(presentableName, false);
    }

    protected NodeRendererImpl(@NotNull String presentableName, boolean enabledDefaultValue) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/debugger/ui/tree/render/NodeRendererImpl", "<init>"));
        }
        this.myProperties = new BasicRendererProperties(enabledDefaultValue);
        this.myProperties.setName(presentableName);
        this.myProperties.setEnabled(enabledDefaultValue);
    }

    @Override
    public String getName() {
        return this.myProperties.getName();
    }

    @Override
    public void setName(String name) {
        this.myProperties.setName(name);
    }

    @Override
    public boolean isEnabled() {
        return this.myProperties.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myProperties.setEnabled(enabled);
    }

    public boolean isShowType() {
        return this.myProperties.isShowType();
    }

    public void setShowType(boolean showType) {
        this.myProperties.setShowType(showType);
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        return null;
    }

    @Override
    public NodeRendererImpl clone() {
        try {
            NodeRendererImpl cloned = (NodeRendererImpl)super.clone();
            cloned.myProperties = this.myProperties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void readExternal(Element element) {
        this.myProperties.readExternal(element);
    }

    public void writeExternal(Element element) {
        this.myProperties.writeExternal(element);
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public String getIdLabel(Value value, DebugProcess process2) {
        return value instanceof ObjectReference && this.isShowType() ? ValueDescriptorImpl.getIdLabel((ObjectReference)value) : null;
    }
}

