/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByChar {
    @NotNull
    public static FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "compare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByChar", "compare"));
        }
        indicator.checkCanceled();
        int[] chars1 = ByChar.getAllChars(text1);
        int[] chars2 = ByChar.getAllChars(text2);
        FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(chars1, chars2, indicator);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "compare"));
        }
        return fairDiffIterable;
    }

    @NotNull
    public static FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "compareTwoStep"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "compareTwoStep"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByChar", "compareTwoStep"));
        }
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getNonSpaceChars(text1);
        CharOffsets chars2 = ByChar.getNonSpaceChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        FairDiffIterable fairDiffIterable = ByChar.matchAdjustmentSpaces(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "compareTwoStep"));
        }
        return fairDiffIterable;
    }

    @NotNull
    public static DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "compareIgnoreWhitespaces"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "compareIgnoreWhitespaces"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByChar", "compareIgnoreWhitespaces"));
        }
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getNonSpaceChars(text1);
        CharOffsets chars2 = ByChar.getNonSpaceChars(text2);
        FairDiffIterable changes = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        DiffIterable diffIterable = ByChar.matchAdjustmentSpacesIW(chars1, chars2, text1, text2, changes);
        if (diffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "compareIgnoreWhitespaces"));
        }
        return diffIterable;
    }

    @NotNull
    public static FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "comparePunctuation"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "comparePunctuation"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByChar", "comparePunctuation"));
        }
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getPunctuationChars(text1);
        CharOffsets chars2 = ByChar.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        FairDiffIterable fairDiffIterable = ByChar.transfer(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "comparePunctuation"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable transfer(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        if (chars1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars1", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        if (chars2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars2", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range : changes.iterateUnchanged()) {
            int count = range.end1 - range.start1;
            for (int i2 = 0; i2 < count; ++i2) {
                int offset1 = chars1.offsets[range.start1 + i2];
                int offset2 = chars2.offsets[range.start2 + i2];
                builder.markEqual(offset1, offset2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "transfer"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentSpaces(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        if (chars1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars1", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        if (chars2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars2", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        FairDiffIterable fairDiffIterable = new ChangeCorrector.DefaultCharChangeCorrector(chars1, chars2, text1, text2, changes, indicator).build();
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpaces"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable matchAdjustmentSpacesIW(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes) {
        if (chars1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars1", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpacesIW"));
        }
        if (chars2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars2", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpacesIW"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpacesIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpacesIW"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpacesIW"));
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range ch : changes.iterateChanges()) {
            int startOffset2;
            int endOffset2;
            int startOffset1;
            int endOffset1;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = ByChar.expandForwardW(chars1, chars2, text1, text2, ch, true);
            } else {
                startOffset1 = chars1.offsets[ch.start1];
                endOffset1 = chars1.offsets[ch.end1 - 1] + 1;
            }
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = ByChar.expandForwardW(chars1, chars2, text1, text2, ch, false);
            } else {
                startOffset2 = chars2.offsets[ch.start2];
                endOffset2 = chars2.offsets[ch.end2 - 1] + 1;
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        DiffIterable diffIterable = DiffIterableUtil.create(ranges, text1.length(), text2.length());
        if (diffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "matchAdjustmentSpacesIW"));
        }
        return diffIterable;
    }

    private static int expandForwardW(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range ch, boolean left) {
        if (chars1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars1", "com/intellij/diff/comparison/ByChar", "expandForwardW"));
        }
        if (chars2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars2", "com/intellij/diff/comparison/ByChar", "expandForwardW"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByChar", "expandForwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByChar", "expandForwardW"));
        }
        if (ch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ch", "com/intellij/diff/comparison/ByChar", "expandForwardW"));
        }
        int offset1 = ch.start1 == 0 ? 0 : chars1.offsets[ch.start1 - 1] + 1;
        int offset2 = ch.start2 == 0 ? 0 : chars2.offsets[ch.start2 - 1] + 1;
        int start = left ? offset1 : offset2;
        return start + TrimUtil.expandForwardW(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    @NotNull
    private static int[] getAllChars(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByChar", "getAllChars"));
        }
        int[] chars = new int[text.length()];
        for (int i2 = 0; i2 < text.length(); ++i2) {
            chars[i2] = text.charAt(i2);
        }
        if (chars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "getAllChars"));
        }
        return chars;
    }

    @NotNull
    private static CharOffsets getNonSpaceChars(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByChar", "getNonSpaceChars"));
        }
        TIntArrayList chars = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (StringUtil.isWhiteSpace((char)c)) continue;
            chars.add((int)c);
            offsets.add(i2);
        }
        CharOffsets charOffsets = new CharOffsets(chars.toNativeArray(), offsets.toNativeArray());
        if (charOffsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "getNonSpaceChars"));
        }
        return charOffsets;
    }

    @NotNull
    private static CharOffsets getPunctuationChars(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByChar", "getPunctuationChars"));
        }
        TIntArrayList chars = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (!TrimUtil.isPunctuation(c)) continue;
            chars.add((int)c);
            offsets.add(i2);
        }
        CharOffsets charOffsets = new CharOffsets(chars.toNativeArray(), offsets.toNativeArray());
        if (charOffsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByChar", "getPunctuationChars"));
        }
        return charOffsets;
    }

    static class CharOffsets {
        public final int[] characters;
        public final int[] offsets;

        public CharOffsets(int[] characters, int[] offsets) {
            this.characters = characters;
            this.offsets = offsets;
        }
    }
}

