/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ChunkOptimizer<T> {
    @NotNull
    protected final List<T> myData1;
    @NotNull
    protected final List<T> myData2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    protected final ProgressIndicator myIndicator;
    @NotNull
    private final List<Range> myRanges;

    public ChunkOptimizer(@NotNull List<T> data1, @NotNull List<T> data2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        if (data1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data1", "com/intellij/diff/comparison/ChunkOptimizer", "<init>"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data2", "com/intellij/diff/comparison/ChunkOptimizer", "<init>"));
        }
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/ChunkOptimizer", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ChunkOptimizer", "<init>"));
        }
        this.myData1 = data1;
        this.myData2 = data2;
        this.myIterable = iterable;
        this.myIndicator = indicator;
        this.myRanges = new ArrayList<Range>();
    }

    @NotNull
    public FairDiffIterable build() {
        for (Range range : this.myIterable.iterateUnchanged()) {
            this.myRanges.add(range);
            this.processLastRanges();
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged(this.myRanges, this.myData1.size(), this.myData2.size()));
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ChunkOptimizer", "build"));
        }
        return fairDiffIterable;
    }

    private void processLastRanges() {
        if (this.myRanges.size() < 2) {
            return;
        }
        Range range1 = this.myRanges.get(this.myRanges.size() - 2);
        Range range2 = this.myRanges.get(this.myRanges.size() - 1);
        if (range1.end1 != range2.start1 && range1.end2 != range2.start2) {
            return;
        }
        int count1 = range1.end1 - range1.start1;
        int count2 = range2.end1 - range2.start1;
        int equalForward = TrimUtil.expandForward(this.myData1, this.myData2, range1.end1, range1.end2, range1.end1 + count2, range1.end2 + count2);
        int equalBackward = TrimUtil.expandBackward(this.myData1, this.myData2, range2.start1 - count1, range2.start2 - count1, range2.start1, range2.start2);
        if (equalForward == 0 && equalBackward == 0) {
            return;
        }
        if (equalForward == count2) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + count2, range1.start2, range1.end2 + count2));
            this.processLastRanges();
            return;
        }
        if (equalBackward == count1) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range2.start1 - count1, range2.end1, range2.start2 - count1, range2.end2));
            this.processLastRanges();
            return;
        }
        Side touchSide = Side.fromLeft((range1.end1 == range2.start1 ? 1 : 0) != 0);
        int shift = this.getShift(touchSide, equalForward, equalBackward, range1, range2);
        if (shift != 0) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + shift, range1.start2, range1.end2 + shift));
            this.myRanges.add(new Range(range2.start1 + shift, range2.end1, range2.start2 + shift, range2.end2));
        }
    }

    protected abstract int getShift(@NotNull Side var1, int var2, int var3, @NotNull Range var4, @NotNull Range var5);

    public static class LineChunkOptimizer
    extends ChunkOptimizer<ByLine.Line> {
        private final int myThreshold;

        public LineChunkOptimizer(@NotNull List<ByLine.Line> lines1, @NotNull List<ByLine.Line> lines2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (lines1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "<init>"));
            }
            if (lines2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "<init>"));
            }
            super(lines1, lines2, changes, indicator);
            this.myThreshold = Registry.intValue((String)"diff.unimportant.line.char.count");
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            if (touchSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touchSide", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getShift"));
            }
            if (range1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range1", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getShift"));
            }
            if (range2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range2", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getShift"));
            }
            Integer shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, this.myThreshold);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, this.myThreshold);
            if (shift != null) {
                return shift;
            }
            return 0;
        }

        @Nullable
        private Integer getUnchangedBoundaryShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2, int threshold) {
            if (touchSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touchSide", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getUnchangedBoundaryShift"));
            }
            if (range1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range1", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getUnchangedBoundaryShift"));
            }
            if (range2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range2", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getUnchangedBoundaryShift"));
            }
            List touchLines = (List)touchSide.select((Object)this.myData1, (Object)this.myData2);
            int touchStart = touchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.findNextUnimportantLine(touchLines, touchStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.findPrevUnimportantLine(touchLines, touchStart - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.getShift(shiftForward, shiftBackward);
        }

        @Nullable
        private Integer getChangedBoundaryShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2, int threshold) {
            if (touchSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touchSide", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getChangedBoundaryShift"));
            }
            if (range1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range1", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getChangedBoundaryShift"));
            }
            if (range2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range2", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "getChangedBoundaryShift"));
            }
            Side nonTouchSide = touchSide.other();
            List nonTouchLines = (List)nonTouchSide.select((Object)this.myData1, (Object)this.myData2);
            int changeStart = nonTouchSide.select(range1.end1, range1.end2);
            int changeEnd = nonTouchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.findNextUnimportantLine(nonTouchLines, changeStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.findPrevUnimportantLine(nonTouchLines, changeEnd - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.getShift(shiftForward, shiftBackward);
        }

        private static int findNextUnimportantLine(@NotNull List<ByLine.Line> lines, int offset, int count, int threshold) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "findNextUnimportantLine"));
            }
            for (int i2 = 0; i2 < count; ++i2) {
                if (lines.get(offset + i2).getNonSpaceChars() > threshold) continue;
                return i2;
            }
            return -1;
        }

        private static int findPrevUnimportantLine(@NotNull List<ByLine.Line> lines, int offset, int count, int threshold) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer", "findPrevUnimportantLine"));
            }
            for (int i2 = 0; i2 < count; ++i2) {
                if (lines.get(offset - i2).getNonSpaceChars() > threshold) continue;
                return i2;
            }
            return -1;
        }

        @Nullable
        private static Integer getShift(int shiftForward, int shiftBackward) {
            if (shiftForward == -1 && shiftBackward == -1) {
                return null;
            }
            if (shiftForward == 0 || shiftBackward == 0) {
                return 0;
            }
            return shiftForward != -1 ? shiftForward : -shiftBackward;
        }
    }

    public static class WordChunkOptimizer
    extends ChunkOptimizer<ByWord.InlineChunk> {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public WordChunkOptimizer(@NotNull List<ByWord.InlineChunk> words1, @NotNull List<ByWord.InlineChunk> words2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (words1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words1", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "<init>"));
            }
            if (words2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words2", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "<init>"));
            }
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "<init>"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "<init>"));
            }
            super(words1, words2, changes, indicator);
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            int touchStart;
            if (touchSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "touchSide", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "getShift"));
            }
            if (range1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range1", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "getShift"));
            }
            if (range2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range2", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "getShift"));
            }
            List touchWords = (List)touchSide.select((Object)this.myData1, (Object)this.myData2);
            CharSequence touchText = (CharSequence)touchSide.select((Object)this.myText1, (Object)this.myText2);
            if (WordChunkOptimizer.isSeparatedWithWhitespace(touchText, (ByWord.InlineChunk)touchWords.get((touchStart = touchSide.select(range2.start1, range2.start2)) - 1), (ByWord.InlineChunk)touchWords.get(touchStart))) {
                return 0;
            }
            int leftShift = WordChunkOptimizer.findSequenceEdgeShift(touchText, touchWords, touchStart, equalForward, true);
            if (leftShift > 0) {
                return leftShift;
            }
            int rightShift = WordChunkOptimizer.findSequenceEdgeShift(touchText, touchWords, touchStart - 1, equalBackward, false);
            if (rightShift > 0) {
                return -rightShift;
            }
            return 0;
        }

        private static int findSequenceEdgeShift(@NotNull CharSequence text, @NotNull List<ByWord.InlineChunk> words, int offset, int count, boolean leftToRight) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "findSequenceEdgeShift"));
            }
            if (words == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "findSequenceEdgeShift"));
            }
            for (int i2 = 0; i2 < count; ++i2) {
                ByWord.InlineChunk word2;
                ByWord.InlineChunk word1;
                if (leftToRight) {
                    word1 = words.get(offset + i2);
                    word2 = words.get(offset + i2 + 1);
                } else {
                    word1 = words.get(offset - i2 - 1);
                    word2 = words.get(offset - i2);
                }
                if (!WordChunkOptimizer.isSeparatedWithWhitespace(text, word1, word2)) continue;
                return i2 + 1;
            }
            return -1;
        }

        private static boolean isSeparatedWithWhitespace(@NotNull CharSequence text, @NotNull ByWord.InlineChunk word1, @NotNull ByWord.InlineChunk word2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "isSeparatedWithWhitespace"));
            }
            if (word1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word1", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "isSeparatedWithWhitespace"));
            }
            if (word2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word2", "com/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer", "isSeparatedWithWhitespace"));
            }
            if (word1 instanceof ByWord.NewlineChunk || word2 instanceof ByWord.NewlineChunk) {
                return true;
            }
            int offset1 = word1.getOffset2();
            int offset2 = word2.getOffset1();
            for (int i2 = offset1; i2 < offset2; ++i2) {
                if (!StringUtil.isWhiteSpace((char)text.charAt(i2))) continue;
                return true;
            }
            return false;
        }
    }
}

