/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComparisonManagerImpl
extends ComparisonManager {
    public static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        FairDiffIterable iterable = ByLine.compare(lines1, lines2, policy, indicator);
        List<LineFragment> list = ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, iterable);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return list;
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List<Line> lines3 = ComparisonManagerImpl.getLines(text3);
        List<MergeRange> ranges = ByLine.compare(lines1, lines2, lines3, policy, indicator);
        List<MergeLineFragment> list = ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return list;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        ArrayList<LineFragment> fineFragments = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
            CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
            if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
                if (this.isEquals(subSequence1, subSequence2, policy)) {
                    fineFragments.add((LineFragment)new LineFragmentImpl(fragment, Collections.emptyList()));
                    continue;
                }
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                continue;
            }
            if (tooBigChunksCount >= 3) {
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                continue;
            }
            try {
                List<ByWord.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
                assert (lineBlocks.size() != 0);
                int startOffset1 = fragment.getStartOffset1();
                int startOffset2 = fragment.getStartOffset2();
                int currentStartLine1 = fragment.getStartLine1();
                int currentStartLine2 = fragment.getStartLine2();
                for (int i2 = 0; i2 < lineBlocks.size(); ++i2) {
                    ByWord.LineBlock block = lineBlocks.get(i2);
                    Range offsets = block.offsets;
                    int currentEndLine1 = i2 != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
                    int currentEndLine2 = i2 != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
                    fineFragments.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
                    currentStartLine1 = currentEndLine1;
                    currentStartLine2 = currentEndLine2;
                }
            }
            catch (DiffTooBigException e) {
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                ++tooBigChunksCount;
            }
        }
        ArrayList<LineFragment> arrayList = fineFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (lineFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        List<LineFragment> list = this.compareLinesInner(text1, text2, policy, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        return list;
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        List<DiffFragment> list = ByWord.compare(text1, text2, policy, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        return list;
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            List<DiffFragment> list = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
            }
            return list;
        }
        if (policy == ComparisonPolicy.DEFAULT) {
            List<DiffFragment> list = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
            }
            return list;
        }
        LOG.warn(policy.toString() + " is not supported by ByChar comparison");
        List<DiffFragment> list = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        return list;
    }

    @NotNull
    public List<Range> compareLines(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        FairDiffIterable iterable = ByLine.compare(lines1, lines2, policy, indicator);
        ArrayList arrayList = ContainerUtil.newArrayList(iterable.iterateChanges());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return arrayList;
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoDiffFragments"));
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        ArrayList<DiffFragment> arrayList = fragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoDiffFragments"));
        }
        return arrayList;
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes.iterateChanges()) {
            IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, ch.start1, ch.end1);
            IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, ch.start2, ch.end2);
            fragments.add((LineFragment)new LineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        ArrayList<LineFragment> arrayList = fragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoLineFragments"));
        }
        return arrayList;
    }

    @NotNull
    private static IntPair getOffsets(@NotNull List<Line> lines, int startIndex, int endIndex) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/diff/comparison/ComparisonManagerImpl", "getOffsets"));
        }
        if (startIndex == endIndex) {
            int offset = startIndex < lines.size() ? lines.get(startIndex).getOffset1() : lines.get(lines.size() - 1).getOffset2();
            IntPair intPair = new IntPair(offset, offset);
            if (intPair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getOffsets"));
            }
            return intPair;
        }
        int offset1 = lines.get(startIndex).getOffset1();
        int offset2 = lines.get(endIndex - 1).getOffset2();
        IntPair intPair = new IntPair(offset1, offset2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getOffsets"));
        }
        return intPair;
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<MergeRange> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeLineFragments"));
        }
        List list = ContainerUtil.map(conflicts, ch -> new MergeLineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeLineFragments"));
        }
        return list;
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<MergeRange> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeWordFragments"));
        }
        List list = ContainerUtil.map(conflicts, ch -> new MergeWordFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "convertIntoMergeWordFragments"));
        }
        return list;
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
            }
            return list;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (!squash && !trim) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
            }
            return list;
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
            }
            return list;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$3"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$3"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$3"));
            }
            newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim));
        }));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        return arrayList;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        int startIndex = 0;
        for (int i2 = 1; i2 < oldFragments.size(); ++i2) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i2 - 1), oldFragments.get(i2))) continue;
            consumer.consume(oldFragments.subList(startIndex, i2));
            startIndex = i2;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start;
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start = 0; start < end; ++start) {
                fragment = fragments.get(start);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start == end) {
            List<LineFragment> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
            }
            return list;
        }
        if (squash) {
            List<LineFragment> list = Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start, end)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
            }
            return list;
        }
        List<LineFragment> list = fragments.subList(start, end);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        return list;
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
        }
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            LineFragment lineFragment = oldFragments.get(0);
            if (lineFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
            }
            return lineFragment;
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment diffFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, diffFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(diffFragment.getStartOffset1() + shift1, diffFragment.getEndOffset1() + shift1, diffFragment.getStartOffset2() + shift2, diffFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), diffFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), diffFragment.getEndOffset2() + shift2));
            }
        }
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
        if (lineFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
        }
        return lineFragmentImpl;
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        if (beforeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoining"));
        }
        if (afterFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoining"));
        }
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        if (beforeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoiningInner"));
        }
        if (afterFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoiningInner"));
        }
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<? extends DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
        }
        if (lineFragment.getInnerFragments() != null) {
            List list = lineFragment.getInnerFragments();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
            }
            return list;
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        List<DiffFragmentImpl> list = Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
        }
        return list;
    }

    @NotNull
    private static List<Line> getLines(@NotNull CharSequence text) {
        int lineEnd;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ComparisonManagerImpl", "getLines"));
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        int offset = 0;
        while ((lineEnd = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)offset)) != -1) {
            lines.add(new Line(text, offset, lineEnd, true));
            offset = lineEnd + 1;
        }
        lines.add(new Line(text, offset, text.length(), false));
        ArrayList<Line> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "getLines"));
        }
        return arrayList;
    }

    private static class Line
    extends CharSequenceSubSequence {
        private final int myOffset1;
        private final int myOffset2;
        private final boolean myNewline;

        public Line(@NotNull CharSequence chars, int offset1, int offset2, boolean newline) {
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/diff/comparison/ComparisonManagerImpl$Line", "<init>"));
            }
            super(chars, offset1, offset2);
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.myNewline = newline;
        }

        public int getOffset1() {
            return this.myOffset1;
        }

        public int getOffset2() {
            return this.myOffset2 + (this.myNewline ? 1 : 0);
        }
    }
}

