/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.NextChangeAction;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.diff.actions.impl.PrevChangeAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBProgressBar;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DiffRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<DiffTool> myAvailableTools;
    @NotNull
    private final List<DiffTool> myToolOrder;
    @NotNull
    private final OpenInEditorAction myOpenInEditorAction;
    @NotNull
    private final DefaultActionGroup myToolbarGroup;
    @NotNull
    private final DefaultActionGroup myPopupActionGroup;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    private final Wrapper myContentPanel;
    @NotNull
    private final ActionToolbar myToolbar;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final MyProgressBar myProgressBar;
    @NotNull
    private DiffRequest myActiveRequest;
    @NotNull
    private ViewerState myState;
    @Nullable
    private ApplyData myQueuedApplyRequest;
    @NotNull
    private IterationState myIterationState;

    public DiffRequestProcessor(@Nullable Project project2) {
        this(project2, (UserDataHolder)new UserDataHolderBase());
    }

    public DiffRequestProcessor(@Nullable Project project2, @NotNull String place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/diff/impl/DiffRequestProcessor", "<init>"));
        }
        this(project2, (UserDataHolder)DiffUtil.createUserDataHolder(DiffUserDataKeys.PLACE, place));
    }

    public DiffRequestProcessor(@Nullable Project project2, @NotNull UserDataHolder context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/impl/DiffRequestProcessor", "<init>"));
        }
        this.myIterationState = IterationState.NONE;
        this.myProject = project2;
        this.myContext = new MyDiffContext(context);
        this.myActiveRequest = new LoadingDiffRequest();
        this.mySettings = DiffSettingsHolder.getInstance().getSettings((String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
        this.myAvailableTools = DiffManagerEx.getInstance().getDiffTools();
        this.myToolOrder = new ArrayList<DiffTool>(this.getToolOrderFromSettings(this.myAvailableTools));
        this.myToolbarGroup = new DefaultActionGroup();
        this.myPopupActionGroup = new DefaultActionGroup();
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarStatusPanel = new Wrapper();
        this.myProgressBar = new MyProgressBar();
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)this.myToolbarGroup, true);
        this.myToolbar.setTargetComponent((JComponent)((Object)this.myMainPanel));
        this.myPanel = JBUI.Panels.simplePanel((Component)((Object)this.myMainPanel));
        BorderLayoutPanel statusPanel = JBUI.Panels.simplePanel((Component)this.myToolbarStatusPanel).addToLeft((Component)this.myProgressBar);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbar.getComponent()).addToRight((Component)statusPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        JComponent bottomPanel = (JComponent)this.myContext.getUserData(DiffUserDataKeysEx.BOTTOM_PANEL);
        if (bottomPanel != null) {
            this.myMainPanel.add(bottomPanel, "South");
        }
        if (bottomPanel instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)bottomPanel));
        }
        this.myState = EmptyState.INSTANCE;
        this.myContentPanel.setContent((JComponent)DiffUtil.createMessagePanel(((LoadingDiffRequest)this.myActiveRequest).getMessage()));
        this.myOpenInEditorAction = new OpenInEditorAction(() -> this.onAfterNavigate());
    }

    protected void reloadRequest() {
        this.updateRequest(true);
    }

    public void updateRequest() {
        this.updateRequest(false);
    }

    public void updateRequest(boolean force) {
        this.updateRequest(force, null);
    }

    public abstract void updateRequest(boolean var1, @Nullable DiffUserDataKeysEx.ScrollToPolicy var2);

    @NotNull
    private FrameDiffTool getFittedTool() {
        List<FrameDiffTool> tools = this.filterFittedTools(this.myToolOrder);
        ErrorDiffTool errorDiffTool = tools.isEmpty() ? ErrorDiffTool.INSTANCE : tools.get(0);
        if (errorDiffTool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getFittedTool"));
        }
        return errorDiffTool;
    }

    @NotNull
    private List<FrameDiffTool> getAvailableFittedTools() {
        List<FrameDiffTool> list = this.filterFittedTools(this.myAvailableTools);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getAvailableFittedTools"));
        }
        return list;
    }

    @NotNull
    private List<FrameDiffTool> filterFittedTools(@NotNull List<DiffTool> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/diff/impl/DiffRequestProcessor", "filterFittedTools"));
        }
        ArrayList<FrameDiffTool> result2 = new ArrayList<FrameDiffTool>();
        for (DiffTool tool : tools) {
            try {
                if (!(tool instanceof FrameDiffTool) || !tool.canShow(this.myContext, this.myActiveRequest)) continue;
                result2.add((FrameDiffTool)tool);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        List<FrameDiffTool> list = DiffUtil.filterSuppressedTools(result2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "filterFittedTools"));
        }
        return list;
    }

    private void moveToolOnTop(@NotNull DiffTool tool) {
        int index;
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/diff/impl/DiffRequestProcessor", "moveToolOnTop"));
        }
        this.myToolOrder.remove(tool);
        FrameDiffTool toolToReplace = this.getFittedTool();
        for (index = 0; index < this.myToolOrder.size() && this.myToolOrder.get(index) != toolToReplace; ++index) {
        }
        this.myToolOrder.add(index, tool);
        this.updateToolOrderSettings(this.myToolOrder);
    }

    @NotNull
    private ViewerState createState() {
        FrameDiffTool frameTool = this.getFittedTool();
        FrameDiffTool.DiffViewer viewer = frameTool.createComponent(this.myContext, this.myActiveRequest);
        for (DiffExtension extension : (DiffExtension[])DiffExtension.EP_NAME.getExtensions()) {
            try {
                extension.onViewerCreated(viewer, this.myContext, this.myActiveRequest);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        DiffViewerWrapper wrapper = (DiffViewerWrapper)this.myActiveRequest.getUserData(DiffViewerWrapper.KEY);
        if (wrapper == null) {
            DefaultState defaultState = new DefaultState(viewer, frameTool);
            if (defaultState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "createState"));
            }
            return defaultState;
        }
        WrapperState wrapperState = new WrapperState(viewer, frameTool, wrapper);
        if (wrapperState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "createState"));
        }
        return wrapperState;
    }

    protected void applyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor", "applyRequest"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myIterationState = IterationState.NONE;
        force = force || this.myQueuedApplyRequest != null && this.myQueuedApplyRequest.force;
        this.myQueuedApplyRequest = new ApplyData(request, force, scrollToChangePolicy);
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(() -> {
            if (this.myQueuedApplyRequest == null || this.myDisposed) {
                return;
            }
            this.doApplyRequest(this.myQueuedApplyRequest.request, this.myQueuedApplyRequest.force, this.myQueuedApplyRequest.scrollToChangePolicy);
            this.myQueuedApplyRequest = null;
        }, ModalityState.current());
    }

    private void doApplyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor", "doApplyRequest"));
        }
        if (!force && request == this.myActiveRequest) {
            return;
        }
        request.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, (Object)scrollToChangePolicy);
        boolean hadFocus = this.isFocused();
        this.myState.destroy();
        this.myToolbarStatusPanel.setContent(null);
        this.myContentPanel.setContent(null);
        this.myToolbarGroup.removeAll();
        this.myPopupActionGroup.removeAll();
        ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
        this.myActiveRequest.onAssigned(false);
        this.myActiveRequest = request;
        this.myActiveRequest.onAssigned(true);
        try {
            this.myState = this.createState();
            this.myState.init();
        }
        catch (Throwable e) {
            LOG.error(e);
            this.myState = new ErrorState(this, (MessageDiffRequest)new ErrorDiffRequest("Error: can't show diff"), (DiffTool)this.getFittedTool());
            this.myState.init();
        }
        if (hadFocus) {
            this.requestFocusInternal();
        }
    }

    protected void setWindowTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/impl/DiffRequestProcessor", "setWindowTitle"));
        }
    }

    protected void onAfterNavigate() {
    }

    protected void onDispose() {
    }

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/impl/DiffRequestProcessor", "getContextUserData"));
        }
        return (T)this.myContext.getUserData(key2);
    }

    public <T> void putContextUserData(@NotNull Key<T> key2, @Nullable T value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/impl/DiffRequestProcessor", "putContextUserData"));
        }
        this.myContext.putUserData(key2, value);
    }

    @NotNull
    protected List<AnAction> getNavigationActions() {
        List list = ContainerUtil.list((Object[])new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction(), new MyPrevChangeAction(), new MyNextChangeAction()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getNavigationActions"));
        }
        return list;
    }

    public boolean isWindowFocused() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        return window != null && window.isFocused();
    }

    public boolean isFocused() {
        return DiffUtil.isFocusedComponent(this.myProject, this.myPanel);
    }

    public void requestFocus() {
        DiffUtil.requestFocus(this.myProject, this.getPreferredFocusedComponent());
    }

    protected void requestFocusInternal() {
        JComponent component = this.getPreferredFocusedComponent();
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    @NotNull
    protected List<DiffTool> getToolOrderFromSettings(@NotNull List<DiffTool> availableTools) {
        if (availableTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableTools", "com/intellij/diff/impl/DiffRequestProcessor", "getToolOrderFromSettings"));
        }
        ArrayList<DiffTool> result2 = new ArrayList<DiffTool>();
        List<String> savedOrder = this.getSettings().getDiffToolsOrder();
        for (String clazz : savedOrder) {
            DiffTool tool = (DiffTool)ContainerUtil.find(availableTools, t -> t.getClass().getCanonicalName().equals(clazz));
            if (tool == null) continue;
            result2.add(tool);
        }
        for (DiffTool tool : availableTools) {
            if (result2.contains(tool)) continue;
            result2.add(tool);
        }
        ArrayList<DiffTool> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getToolOrderFromSettings"));
        }
        return arrayList;
    }

    protected void updateToolOrderSettings(@NotNull List<DiffTool> toolOrder) {
        if (toolOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolOrder", "com/intellij/diff/impl/DiffRequestProcessor", "updateToolOrderSettings"));
        }
        ArrayList<String> savedOrder = new ArrayList<String>();
        for (DiffTool tool : toolOrder) {
            savedOrder.add(tool.getClass().getCanonicalName());
        }
        this.getSettings().setDiffToolsOrder(savedOrder);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            this.myActiveRequest.onAssigned(false);
            this.myState = EmptyState.INSTANCE;
            this.myActiveRequest = NoDiffRequest.INSTANCE;
        });
    }

    protected void collectToolbarActions(@Nullable List<AnAction> viewerActions) {
        this.myToolbarGroup.removeAll();
        ArrayList<Object> navigationActions = new ArrayList<Object>();
        navigationActions.addAll(this.getNavigationActions());
        navigationActions.add((Object)this.myOpenInEditorAction);
        navigationActions.add((Object)new MyChangeDiffToolAction());
        DiffUtil.addActionBlock(this.myToolbarGroup, navigationActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, viewerActions);
        List requestContextActions = (List)this.myActiveRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, contextActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, new AnAction[]{new ShowInExternalToolAction(), ActionManager.getInstance().getAction("ContextHelp")});
    }

    protected void collectPopupActions(@Nullable List<AnAction> viewerActions) {
        this.myPopupActionGroup.removeAll();
        ArrayList<DiffToolToggleAction> selectToolActions = new ArrayList<DiffToolToggleAction>();
        for (DiffTool diffTool : this.getAvailableFittedTools()) {
            if (diffTool == this.myState.getActiveTool()) continue;
            selectToolActions.add(new DiffToolToggleAction(diffTool));
        }
        DiffUtil.addActionBlock(this.myPopupActionGroup, selectToolActions);
        DiffUtil.addActionBlock(this.myPopupActionGroup, viewerActions);
    }

    protected void buildToolbar(@Nullable List<AnAction> viewerActions) {
        this.collectToolbarActions(viewerActions);
        this.myToolbar.updateActionsImmediately();
        for (AnAction action : this.myToolbarGroup.getChildren(null)) {
            DiffUtil.registerAction(action, (JComponent)((Object)this.myMainPanel));
        }
    }

    protected void buildActionPopup(@Nullable List<AnAction> viewerActions) {
        this.collectPopupActions(viewerActions);
        ShowActionGroupPopupAction action = new ShowActionGroupPopupAction();
        DiffUtil.registerAction((AnAction)action, (JComponent)((Object)this.myMainPanel));
    }

    private void setTitle(@Nullable String title) {
        if (this.getContextUserData(DiffUserDataKeys.DO_NOT_CHANGE_WINDOW_TITLE) == Boolean.TRUE) {
            return;
        }
        if (title == null) {
            title = "Diff";
        }
        this.setWindowTitle(title);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component = this.myState.getPreferredFocusedComponent();
        return component != null ? component : this.myToolbar.getComponent();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getContext"));
        }
        return diffContext;
    }

    @NotNull
    protected DiffSettingsHolder.DiffSettings getSettings() {
        DiffSettingsHolder.DiffSettings diffSettings = this.mySettings;
        if (diffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "getSettings"));
        }
        return diffSettings;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected boolean hasNextChange() {
        return false;
    }

    protected boolean hasPrevChange() {
        return false;
    }

    protected void goToNextChange(boolean fromDifferences) {
    }

    protected void goToPrevChange(boolean fromDifferences) {
    }

    protected boolean isNavigationEnabled() {
        return false;
    }

    private void notifyMessage(@NotNull AnActionEvent e, boolean next) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor", "notifyMessage"));
        }
        Editor editor = (Editor)e.getData(DiffDataKeys.CURRENT_EDITOR);
        String message = DiffUtil.createNotificationText(next ? "Press again to go to the next file" : "Press again to go to the previous file", "You can disable this feature in " + DiffUtil.getSettingsConfigurablePath());
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message));
        Point point = new Point(this.myContentPanel.getWidth() / 2, next ? this.myContentPanel.getHeight() - JBUI.scale((int)40) : JBUI.scale((int)40));
        if (editor == null) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            HintHint hintHint = DiffRequestProcessor.createNotifyHint((JComponent)this.myContentPanel, point, next);
            hint.show((JComponent)this.myContentPanel, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
        } else {
            int x = SwingUtilities.convertPoint((Component)this.myContentPanel, (Point)point, (Component)editor.getComponent()).x;
            JComponent header = editor.getHeaderComponent();
            int shift = editor.getScrollingModel().getVerticalScrollOffset() - (header != null ? header.getHeight() : 0);
            LineRange changeRange = (LineRange)e.getData(DiffDataKeys.CURRENT_CHANGE_RANGE);
            LogicalPosition position = changeRange == null ? new LogicalPosition(editor.getCaretModel().getLogicalPosition().line + (next ? 1 : 0), 0) : new LogicalPosition(next ? changeRange.end : changeRange.start, 0);
            int y = editor.logicalPositionToXY((LogicalPosition)position).y - shift;
            Point editorPoint = new Point(x, y);
            HintHint hintHint = DiffRequestProcessor.createNotifyHint(editor.getComponent(), editorPoint, !next);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, editorPoint, 42, 0, false, hintHint);
        }
    }

    @NotNull
    private static HintHint createNotifyHint(@NotNull JComponent component, @NotNull Point point, boolean above) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/impl/DiffRequestProcessor", "createNotifyHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/impl/DiffRequestProcessor", "createNotifyHint"));
        }
        HintHint hintHint = new HintHint(component, point).setPreferredPosition(above ? Balloon.Position.above : Balloon.Position.below).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.INFORMATION_COLOR).setShowImmediately(true);
        if (hintHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor", "createNotifyHint"));
        }
        return hintHint;
    }

    private class WrapperState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;
        @NotNull
        private FrameDiffTool.DiffViewer myWrapperViewer;

        public WrapperState(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull FrameDiffTool tool, DiffViewerWrapper wrapper) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/impl/DiffRequestProcessor$WrapperState", "<init>"));
            }
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/diff/impl/DiffRequestProcessor$WrapperState", "<init>"));
            }
            if (wrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/diff/impl/DiffRequestProcessor$WrapperState", "<init>"));
            }
            this.myViewer = viewer;
            this.myTool = tool;
            this.myWrapperViewer = wrapper.createComponent(DiffRequestProcessor.this.myContext, DiffRequestProcessor.this.myActiveRequest, this.myViewer);
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myWrapperViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents1 = this.myViewer.init();
            FrameDiffTool.ToolbarComponents toolbarComponents2 = this.myWrapperViewer.init();
            ArrayList<AnAction> toolbarActions = new ArrayList<AnAction>();
            if (toolbarComponents1.toolbarActions != null) {
                toolbarActions.addAll(toolbarComponents1.toolbarActions);
            }
            if (toolbarComponents2.toolbarActions != null) {
                if (!toolbarActions.isEmpty() && !toolbarComponents2.toolbarActions.isEmpty()) {
                    toolbarActions.add((AnAction)Separator.getInstance());
                }
                toolbarActions.addAll(toolbarComponents2.toolbarActions);
            }
            DiffRequestProcessor.this.buildToolbar(toolbarActions);
            ArrayList<AnAction> popupActions = new ArrayList<AnAction>();
            if (toolbarComponents1.popupActions != null) {
                popupActions.addAll(toolbarComponents1.popupActions);
            }
            if (toolbarComponents2.popupActions != null) {
                if (!popupActions.isEmpty() && !toolbarComponents2.popupActions.isEmpty()) {
                    popupActions.add((AnAction)Separator.getInstance());
                }
                popupActions.addAll(toolbarComponents2.popupActions);
            }
            DiffRequestProcessor.this.buildActionPopup(popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents1.statusPanel);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
            Disposer.dispose((Disposable)this.myWrapperViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myWrapperViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$WrapperState", "getActiveTool"));
            }
            return frameDiffTool;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (DiffDataKeys.WRAPPING_DIFF_VIEWER.is(dataId)) {
                return this.myWrapperViewer;
            }
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }
    }

    private class DefaultState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;

        public DefaultState(@NotNull FrameDiffTool.DiffViewer viewer, FrameDiffTool tool) {
            if (viewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/impl/DiffRequestProcessor$DefaultState", "<init>"));
            }
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/diff/impl/DiffRequestProcessor$DefaultState", "<init>"));
            }
            this.myViewer = viewer;
            this.myTool = tool;
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents = this.myViewer.init();
            DiffRequestProcessor.this.buildToolbar(toolbarComponents.toolbarActions);
            DiffRequestProcessor.this.buildActionPopup(toolbarComponents.popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$DefaultState", "getActiveTool"));
            }
            return frameDiffTool;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }
    }

    private class ErrorState
    implements ViewerState {
        @Nullable
        private final DiffTool myDiffTool;
        @NotNull
        private final MessageDiffRequest myRequest;
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        final /* synthetic */ DiffRequestProcessor this$0;

        public ErrorState(@NotNull DiffRequestProcessor diffRequestProcessor, MessageDiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor$ErrorState", "<init>"));
            }
            this(diffRequestProcessor, request, null);
        }

        public ErrorState(@NotNull DiffRequestProcessor diffRequestProcessor, @Nullable MessageDiffRequest request, DiffTool diffTool) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor$ErrorState", "<init>"));
            }
            this.this$0 = diffRequestProcessor;
            this.myDiffTool = diffTool;
            this.myRequest = request;
            this.myViewer = ErrorDiffTool.INSTANCE.createComponent(diffRequestProcessor.myContext, (DiffRequest)this.myRequest);
        }

        @Override
        public void init() {
            this.this$0.myContentPanel.setContent(this.myViewer.getComponent());
            FrameDiffTool.ToolbarComponents init = this.myViewer.init();
            this.this$0.buildToolbar(init.toolbarActions);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = this.myDiffTool != null ? this.myDiffTool : ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$ErrorState", "getActiveTool"));
            }
            return errorDiffTool;
        }
    }

    private static class EmptyState
    implements ViewerState {
        private static final EmptyState INSTANCE = new EmptyState();

        private EmptyState() {
        }

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$EmptyState", "getActiveTool"));
            }
            return errorDiffTool;
        }
    }

    private static interface ViewerState {
        public void init();

        public void destroy();

        @Nullable
        public JComponent getPreferredFocusedComponent();

        @Nullable
        public Object getData(@NonNls String var1);

        @NotNull
        public DiffTool getActiveTool();
    }

    private static class ApplyData {
        @NotNull
        private final DiffRequest request;
        private final boolean force;
        @Nullable
        private final DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy;

        public ApplyData(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor$ApplyData", "<init>"));
            }
            this.request = request;
            this.force = force;
            this.scrollToChangePolicy = scrollToChangePolicy;
        }
    }

    private class MyDiffContext
    extends DiffContextEx {
        @NotNull
        private final UserDataHolder myContext;

        public MyDiffContext(UserDataHolder context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/impl/DiffRequestProcessor$MyDiffContext", "<init>"));
            }
            this.myContext = context;
        }

        @Override
        public void reopenDiffRequest() {
            DiffRequestProcessor.this.updateRequest(true);
        }

        @Override
        public void reloadDiffRequest() {
            DiffRequestProcessor.this.reloadRequest();
        }

        @Override
        public void showProgressBar(boolean enabled) {
            if (enabled) {
                DiffRequestProcessor.this.myProgressBar.startProgress();
            } else {
                DiffRequestProcessor.this.myProgressBar.stopProgress();
            }
        }

        @Nullable
        public Project getProject() {
            return DiffRequestProcessor.this.getProject();
        }

        public boolean isFocused() {
            return DiffRequestProcessor.this.isFocused();
        }

        public boolean isWindowFocused() {
            return DiffRequestProcessor.this.isWindowFocused();
        }

        public void requestFocus() {
            DiffRequestProcessor.this.requestFocusInternal();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key2) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/impl/DiffRequestProcessor$MyDiffContext", "getUserData"));
            }
            return (T)this.myContext.getUserData(key2);
        }

        public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/impl/DiffRequestProcessor$MyDiffContext", "putUserData"));
            }
            this.myContext.putUserData(key2, value);
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponentImpl(Container focusCycleRoot) {
            JComponent component = DiffRequestProcessor.this.getPreferredFocusedComponent();
            if (component == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component, this);
        }
    }

    private static class MyProgressBar
    extends JBProgressBar {
        private int myProgressCount = 0;

        public MyProgressBar() {
            this.setIndeterminate(true);
            this.setVisible(false);
        }

        public void startProgress() {
            ++this.myProgressCount;
            this.setVisible(true);
        }

        public void stopProgress() {
            --this.myProgressCount;
            LOG.assertTrue(this.myProgressCount >= 0);
            if (this.myProgressCount == 0) {
                this.setVisible(false);
            }
        }
    }

    private class MyPanel
    extends JBPanelWithEmptyText
    implements DataProvider {
        public MyPanel() {
            super((LayoutManager)new BorderLayout());
        }

        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffPanelSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            Object data;
            DataProvider contentProvider = DataManagerImpl.getDataProviderEx(DiffRequestProcessor.this.myContentPanel.getTargetComponent());
            if (contentProvider != null && (data = contentProvider.getData(dataId)) != null) {
                return data;
            }
            if (OpenInEditorAction.KEY.is(dataId)) {
                return DiffRequestProcessor.this.myOpenInEditorAction;
            }
            if (DiffDataKeys.DIFF_REQUEST.is(dataId)) {
                return DiffRequestProcessor.this.myActiveRequest;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return DiffRequestProcessor.this.myProject;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                if (DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "reference.dialogs.diff.file";
            }
            if (DiffDataKeys.DIFF_CONTEXT.is(dataId)) {
                return DiffRequestProcessor.this.myContext;
            }
            data = DiffRequestProcessor.this.myState.getData(dataId);
            if (data != null) {
                return data;
            }
            DataProvider requestProvider = (DataProvider)DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (requestProvider != null && (data = requestProvider.getData(dataId)) != null) {
                return data;
            }
            DataProvider contextProvider = (DataProvider)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data = contextProvider.getData(dataId)) != null) {
                return data;
            }
            return null;
        }
    }

    protected class MyPrevChangeAction
    extends PrevChangeAction {
        protected MyPrevChangeAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyPrevChangeAction", "update"));
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasPrevChange());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyPrevChangeAction", "actionPerformed"));
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasPrevChange()) {
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(false);
        }
    }

    protected class MyNextChangeAction
    extends NextChangeAction {
        protected MyNextChangeAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyNextChangeAction", "update"));
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasNextChange());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyNextChangeAction", "actionPerformed"));
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasNextChange()) {
                return;
            }
            DiffRequestProcessor.this.goToNextChange(false);
        }
    }

    protected class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        protected MyPrevDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyPrevDifferenceAction", "update"));
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyPrevDifferenceAction", "actionPerformed"));
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoPrev()) {
                iterable.goPrev();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange() && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.PREV) {
                DiffRequestProcessor.this.notifyMessage(e, false);
                DiffRequestProcessor.this.myIterationState = IterationState.PREV;
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(true);
        }
    }

    protected class MyNextDifferenceAction
    extends NextDifferenceAction {
        protected MyNextDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyNextDifferenceAction", "update"));
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$MyNextDifferenceAction", "actionPerformed"));
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoNext()) {
                iterable.goNext();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange() && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.NEXT) {
                DiffRequestProcessor.this.notifyMessage(e, true);
                DiffRequestProcessor.this.myIterationState = IterationState.NEXT;
                return;
            }
            DiffRequestProcessor.this.goToNextChange(true);
        }
    }

    private static enum IterationState {
        NEXT,
        PREV,
        NONE;

    }

    private class ShowActionGroupPopupAction
    extends DumbAwareAction {
        public ShowActionGroupPopupAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowSettingsPopup");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(DiffRequestProcessor.this.myPopupActionGroup.getChildrenCount() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Diff Actions", (ActionGroup)DiffRequestProcessor.this.myPopupActionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup.showInCenterOf((Component)DiffRequestProcessor.this.myPanel);
        }
    }

    private class DiffToolToggleAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final DiffTool myDiffTool;

        private DiffToolToggleAction(DiffTool tool) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/diff/impl/DiffRequestProcessor$DiffToolToggleAction", "<init>"));
            }
            super(tool.getName());
            this.myDiffTool = tool;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/impl/DiffRequestProcessor$DiffToolToggleAction", "actionPerformed"));
            }
            if (DiffRequestProcessor.this.myState.getActiveTool() == this.myDiffTool) {
                return;
            }
            UsageTrigger.trigger("diff.DiffSettings.Tool." + ConvertUsagesUtil.ensureProperKey(this.myDiffTool.getName()));
            DiffRequestProcessor.this.moveToolOnTop(this.myDiffTool);
            DiffRequestProcessor.this.updateRequest(true);
        }
    }

    private class MyChangeDiffToolAction
    extends ComboBoxAction
    implements DumbAware {
        private MyChangeDiffToolAction() {
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            DiffTool activeTool = DiffRequestProcessor.this.myState.getActiveTool();
            presentation.setText(activeTool.getName());
            if (activeTool == ErrorDiffTool.INSTANCE) {
                presentation.setEnabledAndVisible(false);
            }
            for (DiffTool tool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                if (tool == activeTool) continue;
                presentation.setEnabledAndVisible(true);
                return;
            }
            presentation.setEnabledAndVisible(false);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (DiffTool tool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                group.add((AnAction)new DiffToolToggleAction(tool));
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
    }

    private class ShowInExternalToolAction
    extends DumbAwareAction {
        public ShowInExternalToolAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowInExternalTool");
        }

        public void update(AnActionEvent e) {
            if (!ExternalDiffTool.isEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabled(ExternalDiffTool.canShow(DiffRequestProcessor.this.myActiveRequest));
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(AnActionEvent e) {
            try {
                ExternalDiffTool.showRequest(e.getProject(), DiffRequestProcessor.this.myActiveRequest);
            }
            catch (Throwable ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getMessage(), (String)"Can't Show Diff In External Tool");
            }
        }
    }
}

