/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.holders;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryEditorHolder
extends EditorHolder {
    @NotNull
    protected final FileEditor myEditor;
    @NotNull
    protected final FileEditorProvider myEditorProvider;

    public BinaryEditorHolder(@NotNull FileEditor editor, @NotNull FileEditorProvider editorProvider) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/holders/BinaryEditorHolder", "<init>"));
        }
        if (editorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorProvider", "com/intellij/diff/tools/holders/BinaryEditorHolder", "<init>"));
        }
        this.myEditor = editor;
        this.myEditorProvider = editorProvider;
    }

    @NotNull
    public FileEditor getEditor() {
        FileEditor fileEditor = this.myEditor;
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/BinaryEditorHolder", "getEditor"));
        }
        return fileEditor;
    }

    public void dispose() {
        this.myEditorProvider.disposeEditor(this.myEditor);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/BinaryEditorHolder", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void installFocusListener(@NotNull FocusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/diff/tools/holders/BinaryEditorHolder", "installFocusListener"));
        }
        this.myEditor.getComponent().addFocusListener(listener2);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public static class BinaryEditorHolderFactory
    extends EditorHolderFactory<BinaryEditorHolder> {
        public static BinaryEditorHolderFactory INSTANCE = new BinaryEditorHolderFactory();

        @Override
        @NotNull
        public BinaryEditorHolder create(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "create"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "create"));
            }
            Project project2 = context.getProject();
            if (content instanceof FileContent) {
                if (project2 == null) {
                    project2 = ProjectManager.getInstance().getDefaultProject();
                }
                VirtualFile file2 = ((FileContent)content).getFile();
                FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project2, file2);
                if (providers.length == 0) {
                    throw new IllegalStateException("Can't find FileEditorProvider: " + file2.getFileType());
                }
                FileEditorProvider provider = providers[0];
                FileEditor editor = provider.createEditor(project2, file2);
                UIUtil.removeScrollBorder((Component)editor.getComponent());
                BinaryEditorHolder binaryEditorHolder = new BinaryEditorHolder(editor, provider);
                if (binaryEditorHolder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "create"));
                }
                return binaryEditorHolder;
            }
            if (content instanceof DocumentContent) {
                Document document = ((DocumentContent)content).getDocument();
                final EditorEx editor = DiffUtil.createEditor(document, project2, true);
                TextEditorProvider provider = TextEditorProvider.getInstance();
                TextEditor fileEditor = provider.getTextEditor(editor);
                Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){

                    public void dispose() {
                        EditorFactory.getInstance().releaseEditor(editor);
                    }
                });
                BinaryEditorHolder binaryEditorHolder = new BinaryEditorHolder((FileEditor)fileEditor, provider);
                if (binaryEditorHolder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "create"));
                }
                return binaryEditorHolder;
            }
            throw new IllegalArgumentException(content.getClass() + " - " + content.toString());
        }

        @Override
        public boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "canShowContent"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "canShowContent"));
            }
            if (content instanceof DocumentContent) {
                return true;
            }
            if (content instanceof FileContent) {
                VirtualFile file2;
                Project project2 = context.getProject();
                if (project2 == null) {
                    project2 = ProjectManager.getInstance().getDefaultProject();
                }
                if (!(file2 = ((FileContent)content).getFile()).isValid()) {
                    return false;
                }
                if (file2 instanceof VirtualFileWithoutContent) {
                    return false;
                }
                return FileEditorProviderManager.getInstance().getProviders(project2, file2).length != 0;
            }
            return false;
        }

        @Override
        public boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "wantShowContent"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory", "wantShowContent"));
            }
            if (content instanceof FileContent) {
                if (content.getContentType() == null) {
                    return false;
                }
                if (content.getContentType().isBinary()) {
                    return true;
                }
                return content.getContentType() instanceof UIBasedFileType;
            }
            return false;
        }
    }
}

