/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/RunContextAction", "<init>"));
        }
        super(ExecutionBundle.message((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), null, executor.getIcon());
        this.myExecutor = executor;
    }

    @Override
    protected void perform(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        RunManagerEx runManager = (RunManagerEx)context.getRunManager();
        if (configuration == null) {
            configuration = context.getConfiguration();
            if (configuration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration);
        }
        if (Registry.is((String)"select.run.configuration.from.context")) {
            runManager.setSelectedConfiguration(configuration);
        }
        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)this.myExecutor);
    }

    @Override
    protected boolean isEnabledFor(RunConfiguration configuration) {
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner getRunner(RunConfiguration configuration) {
        return RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        if (actionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/RunContextAction", "updatePresentation"));
        }
        presentation.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context);
        presentation.setEnabled(((Boolean)b.first).booleanValue());
        presentation.setVisible(((Boolean)b.second).booleanValue());
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context) {
        ProgramRunner runner;
        RunnerAndConfigurationSettings configuration = context.findExisting();
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        ProgramRunner programRunner = runner = configuration == null ? null : this.getRunner(configuration.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        return Pair.create((Object)(!ExecutorRegistry.getInstance().isStarting(context.getProject(), this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }
}

