/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternBasedFileHyperlinkRawDataFinder
implements FileHyperlinkRawDataFinder {
    private static final int UNKNOWN = -2;
    private final PatternHyperlinkFormat[] myLinkFormats;

    public PatternBasedFileHyperlinkRawDataFinder(@NotNull PatternHyperlinkFormat[] linkFormats) {
        if (linkFormats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkFormats", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "<init>"));
        }
        this.myLinkFormats = linkFormats;
    }

    @Override
    @NotNull
    public List<FileHyperlinkRawData> find(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "find"));
        }
        Pair<Matcher, PatternHyperlinkFormat> pair = this.findMatcher(line);
        if (pair == null) {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "find"));
            }
            return list;
        }
        Matcher matcher = (Matcher)pair.first;
        PatternHyperlinkFormat format = (PatternHyperlinkFormat)pair.second;
        PatternHyperlinkPart[] linkParts = format.getLinkParts();
        int groupCount = matcher.groupCount();
        if (groupCount > linkParts.length) {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "find"));
            }
            return list;
        }
        String path = null;
        int lineNumber = -1;
        int columnNumber = -1;
        int hyperlinkStartInd = -1;
        int hyperlinkEndInd = -1;
        boolean hyperlinkFreezed = false;
        for (int i2 = 1; i2 <= groupCount; ++i2) {
            String value = matcher.group(i2);
            if (value == null) continue;
            PatternHyperlinkPart part = linkParts[i2 - 1];
            if (part == PatternHyperlinkPart.HYPERLINK) {
                hyperlinkStartInd = matcher.start(i2);
                hyperlinkEndInd = matcher.end(i2);
                hyperlinkFreezed = true;
                continue;
            }
            if (part == PatternHyperlinkPart.PATH) {
                path = value;
                if (hyperlinkFreezed) continue;
                hyperlinkStartInd = matcher.start(i2);
                hyperlinkEndInd = matcher.end(i2);
                continue;
            }
            if (part == PatternHyperlinkPart.LINE) {
                value = StringUtil.trimStart((String)value, (String)":");
                lineNumber = StringUtil.parseInt((String)value, (int)-2);
                hyperlinkEndInd = PatternBasedFileHyperlinkRawDataFinder.tryExtendHyperlinkEnd(hyperlinkFreezed, hyperlinkEndInd, matcher.start(i2), matcher.end(i2));
                continue;
            }
            if (part != PatternHyperlinkPart.COLUMN || (columnNumber = StringUtil.parseInt((String)(value = StringUtil.trimStart((String)value, (String)":")), (int)-2)) == -2) continue;
            hyperlinkEndInd = PatternBasedFileHyperlinkRawDataFinder.tryExtendHyperlinkEnd(hyperlinkFreezed, hyperlinkEndInd, matcher.start(i2), matcher.end(i2));
        }
        if (path == null || lineNumber == -2 || columnNumber == -2 || hyperlinkStartInd == -1) {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "find"));
            }
            return list;
        }
        if (!format.isZeroBasedLineNumbering()) {
            --lineNumber;
        }
        if (!format.isZeroBasedColumnNumbering()) {
            --columnNumber;
        }
        lineNumber = Math.max(lineNumber, -1);
        columnNumber = Math.max(columnNumber, -1);
        FileHyperlinkRawData data = new FileHyperlinkRawData(path, lineNumber, columnNumber, hyperlinkStartInd, hyperlinkEndInd);
        List<FileHyperlinkRawData> list = Collections.singletonList(data);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "find"));
        }
        return list;
    }

    private static int tryExtendHyperlinkEnd(boolean hyperlinkFreezed, int hyperlinkEndInd, int groupStartInd, int groupEndInd) {
        if (!(hyperlinkFreezed || hyperlinkEndInd != groupStartInd && hyperlinkEndInd + 1 != groupStartInd)) {
            return groupEndInd;
        }
        return hyperlinkEndInd;
    }

    @Nullable
    private Pair<Matcher, PatternHyperlinkFormat> findMatcher(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder", "findMatcher"));
        }
        for (PatternHyperlinkFormat linkFormat : this.myLinkFormats) {
            Matcher matcher = linkFormat.getPattern().matcher(line);
            if (!matcher.find()) continue;
            return Pair.create((Object)matcher, (Object)linkFormat);
        }
        return null;
    }
}

