/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

class AsyncFilterRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.FilterRunner");
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"console filters", (int)1);
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;

    AsyncFilterRunner(EditorHyperlinkSupport hyperlinks, Editor editor) {
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
    }

    void highlightHyperlinks(Filter customFilter, int startLine, int endLine) {
        if (endLine < 0) {
            return;
        }
        Computable<FilterResults> bgComputation = this.highlightHyperlinksAsync(customFilter, startLine, endLine);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ((FilterResults)bgComputation.compute()).applyHighlights(this.myHyperlinks);
        } else {
            this.runFiltersInBackground(bgComputation);
        }
    }

    private void runFiltersInBackground(Computable<FilterResults> bgComputation) {
        AtomicBoolean handled = new AtomicBoolean();
        Future<FilterResults> future2 = ourExecutor.submit(() -> {
            FilterResults results = this.computeWithWritePriority(bgComputation);
            if (!results.myResults.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> results.applyHighlights(this.myHyperlinks), ModalityState.any(), o -> handled.get());
            }
            return results;
        });
        this.handleSynchronouslyIfQuick(handled, future2);
    }

    @NotNull
    private FilterResults computeWithWritePriority(Computable<FilterResults> bgComputation) {
        Ref applyResults = Ref.create((Object)FilterResults.EMPTY);
        Runnable computeInReadAction = () -> {
            if (this.myEditor.isDisposed()) {
                return;
            }
            applyResults.set(bgComputation.compute());
        };
        while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(computeInReadAction)) {
            TimeoutUtil.sleep((long)10L);
        }
        FilterResults filterResults = (FilterResults)applyResults.get();
        if (filterResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/AsyncFilterRunner", "computeWithWritePriority"));
        }
        return filterResults;
    }

    private void handleSynchronouslyIfQuick(AtomicBoolean handled, Future<FilterResults> future2) {
        try {
            future2.get(5L, TimeUnit.MILLISECONDS).applyHighlights(this.myHyperlinks);
            handled.set(true);
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private Computable<FilterResults> highlightHyperlinksAsync(Filter filter, int startLine, int endLine) {
        Document document = this.myEditor.getDocument();
        int markerOffset = document.getLineEndOffset(endLine);
        RangeMarker marker = document.createRangeMarker(markerOffset, markerOffset);
        List tasks = IntStreamEx.rangeClosed((int)startLine, (int)endLine).mapToObj(line -> AsyncFilterRunner.processLine(document, filter, line)).toList();
        Computable computable = () -> {
            ArrayList<Filter.Result> results = new ArrayList<Filter.Result>();
            for (LineHighlighter task : tasks) {
                ProgressManager.checkCanceled();
                if (!marker.isValid() || marker.getEndOffset() == 0) {
                    return FilterResults.EMPTY;
                }
                ContainerUtil.addIfNotNull(results, (Object)task.compute());
            }
            return new FilterResults(markerOffset, marker, results);
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/AsyncFilterRunner", "highlightHyperlinksAsync"));
        }
        return computable;
    }

    @NotNull
    private static LineHighlighter processLine(Document document, Filter filter, int line) {
        int lineEnd;
        int endOffset = lineEnd + ((lineEnd = document.getLineEndOffset(line)) < document.getTextLength() ? 1 : 0);
        CharSequence text = EditorHyperlinkSupport.getLineSequence(document, line, true);
        LineHighlighter lineHighlighter = () -> AsyncFilterRunner.checkRange(filter, endOffset, filter.applyFilter(text.toString(), endOffset));
        if (lineHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/AsyncFilterRunner", "processLine"));
        }
        return lineHighlighter;
    }

    private static Filter.Result checkRange(Filter filter, int endOffset, Filter.Result result2) {
        if (result2 != null) {
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end >= start && end <= endOffset) continue;
                LOG.error("Filter returned wrong range: start=" + start + "; end=" + end + "; max=" + endOffset + "; filter=" + filter);
            }
        }
        return result2;
    }

    private static class FilterResults {
        static final FilterResults EMPTY = new FilterResults(0, null, Collections.emptyList());
        private int myInitialMarkerOffset;
        private RangeMarker myMarker;
        private List<Filter.Result> myResults;

        FilterResults(int initialMarkerOffset, RangeMarker marker, List<Filter.Result> results) {
            this.myInitialMarkerOffset = initialMarkerOffset;
            this.myMarker = marker;
            this.myResults = results;
        }

        void applyHighlights(EditorHyperlinkSupport hyperlinks) {
            if (this.myResults.isEmpty() || !this.myMarker.isValid()) {
                return;
            }
            int delta = this.myMarker.getStartOffset() - this.myInitialMarkerOffset;
            for (Filter.Result result2 : this.myResults) {
                hyperlinks.highlightHyperlinks(result2, delta);
            }
        }
    }

    private static interface LineHighlighter
    extends NullableComputable<Filter.Result> {
    }
}

