/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandlerFactory;
import org.jetbrains.annotations.NotNull;

public class ProcessHandlerFactoryImpl
extends ProcessHandlerFactory {
    @NotNull
    public OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ProcessHandlerFactoryImpl", "createProcessHandler"));
        }
        OSProcessHandler oSProcessHandler = new OSProcessHandler(commandLine);
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessHandlerFactoryImpl", "createProcessHandler"));
        }
        return oSProcessHandler;
    }

    @NotNull
    public OSProcessHandler createColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/ProcessHandlerFactoryImpl", "createColoredProcessHandler"));
        }
        ColoredProcessHandler coloredProcessHandler = new ColoredProcessHandler(commandLine);
        if (coloredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessHandlerFactoryImpl", "createColoredProcessHandler"));
        }
        return coloredProcessHandler;
    }
}

