/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.NewRunConfigurationPopup;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupRunner;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.execution.startup.ProjectStartupTasksTableModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JBTable myTable;
    private ToolbarDecorator myDecorator;
    private ProjectStartupTasksTableModel myModel;

    public ProjectStartupConfigurable(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public String getId() {
        if ("preferences.startup.tasks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/startup/ProjectStartupConfigurable", "getId"));
        }
        return "preferences.startup.tasks";
    }

    @Nls
    public String getDisplayName() {
        return "Startup Tasks";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.startup.tasks";
    }

    @Nullable
    public JComponent createComponent() {
        this.myModel = new ProjectStartupTasksTableModel(RunManagerEx.getInstanceEx(this.myProject));
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.getEmptyText().setText("Add run configurations with the + button");
        new TableSpeedSearch((JTable)this.myTable);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                int row = ProjectStartupConfigurable.this.myTable.getSelectedRow();
                if (row >= 0 && ProjectStartupConfigurable.this.myModel.isCellEditable(row, 1)) {
                    ProjectStartupConfigurable.this.myModel.setValueAt(!Boolean.TRUE.equals(ProjectStartupConfigurable.this.myTable.getValueAt(row, 1)), row, 1);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{32}), (JComponent)this.myTable);
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ProjectStartupConfigurable.this.editRunConfiguration();
                }
            }
        });
        this.installRenderers();
        this.myDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.selectAndAddConfiguration(button);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.editRunConfiguration();
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ProjectStartupConfigurable.this.myTable.getSelectedRow() >= 0;
            }
        }).disableUpAction().disableDownAction();
        JPanel tasksPanel = this.myDecorator.createPanel();
        JLabel label = new JLabel("Run tasks and tools via run configurations");
        label.setForeground(UIUtil.getInactiveTextColor());
        label.setHorizontalAlignment(4);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)new JLabel("To be started on project opening:"), "West");
        wrapper.add((Component)label, "East");
        wrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)wrapper, "North");
        main.add((Component)tasksPanel, "Center");
        return main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editRunConfiguration() {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        RunnerAndConfigurationSettings selected = this.myModel.getAllConfigurations().get(row);
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        RunnerAndConfigurationSettings was = runManager.getSelectedConfiguration();
        try {
            runManager.setSelectedConfiguration(selected);
            new EditConfigurationsDialog(this.myProject).showAndGet();
        }
        finally {
            runManager.setSelectedConfiguration(was);
        }
        this.myModel.fireTableDataChanged();
        this.refreshDataUpdateSelection(selected);
    }

    private void refreshDataUpdateSelection(RunnerAndConfigurationSettings settings) {
        if (this.myTable.isEmpty()) {
            return;
        }
        this.myModel.reValidateConfigurations(new Processor<RunnerAndConfigurationSettings>(){
            private RunManagerImpl runManager;
            {
                this.runManager = RunManagerImpl.getInstanceImpl(ProjectStartupConfigurable.this.myProject);
            }

            public boolean process(RunnerAndConfigurationSettings settings) {
                return this.runManager.getConfigurationById(settings.getUniqueID()) != null;
            }
        });
        if (settings != null) {
            List<RunnerAndConfigurationSettings> configurations = this.myModel.getAllConfigurations();
            for (int i2 = 0; i2 < configurations.size(); ++i2) {
                RunnerAndConfigurationSettings configuration = configurations.get(i2);
                if (configuration != settings) continue;
                TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i2});
                return;
            }
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{0});
        this.myTable.getSelectionModel().setLeadSelectionIndex(0);
    }

    private ChooseRunConfigurationPopup.ItemWrapper<Void> createNewWrapper(final AnActionButton button) {
        return new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return IconUtil.getAddIcon();
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]));
            }

            @Override
            public void perform(@NotNull Project project2, final @NotNull Executor executor, @NotNull DataContext context) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "perform"));
                }
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "perform"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "perform"));
                }
                final RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project2);
                ConfigurationType[] factories = runManager.getConfigurationFactories();
                Condition<ConfigurationType> filter = new Condition<ConfigurationType>(){
                    private final RunnerRegistry myRegistry = RunnerRegistry.getInstance();

                    public boolean value(ConfigurationType configurationType) {
                        ConfigurationFactory factory;
                        return !UnknownConfigurationType.INSTANCE.equals(configurationType) && (factory = runManager.getFactory(configurationType.getId(), null)) != null && this.myRegistry.getRunner(executor.getId(), (RunProfile)runManager.getConfigurationTemplate(factory).getConfiguration()) != null;
                    }
                };
                List factoriesList = ContainerUtil.filter(Arrays.asList(factories), (Condition)filter);
                ListPopup popup = NewRunConfigurationPopup.createAddPopup(factoriesList, "", (Consumer<ConfigurationFactory>)((Consumer)factory -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "lambda$perform$2"));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "lambda$null$1"));
                        }
                        EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(project2, (ConfigurationFactory)factory);
                        if (dialog2.showAndGet()) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (project2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "lambda$null$0"));
                                }
                                RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project2).getSelectedConfiguration();
                                if (configuration != null) {
                                    ProjectStartupConfigurable.this.addConfiguration(configuration);
                                }
                            }, ModalityState.any(), project2.getDisposed());
                        }
                    }, ModalityState.any(), project2.getDisposed());
                }), null, EmptyRunnable.getInstance(), false);
                ProjectStartupConfigurable.this.showPopup(button, (JBPopup)popup);
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }
        };
    }

    private void addConfiguration(RunnerAndConfigurationSettings configuration) {
        if (!ProjectStartupRunner.canBeRun(configuration)) {
            String message = "Can not add Run Configuration '" + configuration.getName() + "' to Startup Tasks, since it can not be started with 'Run' action.";
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setHideOnClickOutside(true).setFadeoutTime(3000L).setCloseButtonEnabled(true).createBalloon();
            RelativePoint rp = new RelativePoint((Component)this.myDecorator.getActionsPanel(), new Point(5, 5));
            balloon.show(rp, Balloon.Position.atLeft);
            return;
        }
        this.myModel.addConfiguration(configuration);
        this.refreshDataUpdateSelection(configuration);
    }

    private void selectAndAddConfiguration(AnActionButton button) {
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ArrayList<ChooseRunConfigurationPopup.ItemWrapper> wrappers = new ArrayList<ChooseRunConfigurationPopup.ItemWrapper>();
        wrappers.add(this.createNewWrapper(button));
        ChooseRunConfigurationPopup.ItemWrapper[] allSettings = ChooseRunConfigurationPopup.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        }, false);
        HashSet<RunnerAndConfigurationSettings> existing = new HashSet<RunnerAndConfigurationSettings>(this.myModel.getAllConfigurations());
        for (ChooseRunConfigurationPopup.ItemWrapper setting : allSettings) {
            RunnerAndConfigurationSettings settings;
            if (!(setting.getValue() instanceof RunnerAndConfigurationSettings) || (settings = (RunnerAndConfigurationSettings)setting.getValue()).isTemporary() || !ProjectStartupRunner.canBeRun(settings) || existing.contains(settings)) continue;
            wrappers.add(setting);
        }
        JBList list = new JBList(wrappers);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/startup/ProjectStartupConfigurable$9", "customizeCellRenderer"));
                }
                if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
                    this.setIcon(((ChooseRunConfigurationPopup.ItemWrapper)value).getIcon());
                    this.append(((ChooseRunConfigurationPopup.ItemWrapper)value).getText());
                }
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(() -> {
            int index = list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            ChooseRunConfigurationPopup.ItemWrapper at = (ChooseRunConfigurationPopup.ItemWrapper)list.getModel().getElementAt(index);
            if (at.getValue() instanceof RunnerAndConfigurationSettings) {
                RunnerAndConfigurationSettings added = (RunnerAndConfigurationSettings)at.getValue();
                this.addConfiguration(added);
            } else {
                at.perform(this.myProject, executor, button.getDataContext());
            }
        }).createPopup();
        this.showPopup(button, popup);
    }

    private void showPopup(AnActionButton button, JBPopup popup) {
        RelativePoint point = button.getPreferredPopupPoint();
        if (point != null) {
            popup.show(point);
        } else {
            popup.showInCenterOf((Component)this.myDecorator.getActionsPanel());
        }
    }

    public boolean isModified() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        HashSet<RunnerAndConfigurationSettings> shared = new HashSet<RunnerAndConfigurationSettings>(projectStartupTaskManager.getSharedConfigurations());
        ArrayList<RunnerAndConfigurationSettings> list = new ArrayList<RunnerAndConfigurationSettings>(shared);
        list.addAll(projectStartupTaskManager.getLocalConfigurations());
        Collections.sort(list, ProjectStartupTasksTableModel.RunnerAndConfigurationSettingsComparator.getInstance());
        if (!Comparing.equal(list, this.myModel.getAllConfigurations())) {
            return true;
        }
        return !Comparing.equal(shared, this.myModel.getSharedConfigurations());
    }

    public void apply() throws ConfigurationException {
        ArrayList<RunnerAndConfigurationSettings> shared = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> local = new ArrayList<RunnerAndConfigurationSettings>();
        Set<RunnerAndConfigurationSettings> sharedSet = this.myModel.getSharedConfigurations();
        List<RunnerAndConfigurationSettings> allConfigurations = this.myModel.getAllConfigurations();
        for (RunnerAndConfigurationSettings configuration : allConfigurations) {
            if (sharedSet.contains(configuration)) {
                shared.add(configuration);
                continue;
            }
            local.add(configuration);
        }
        ProjectStartupTaskManager.getInstance(this.myProject).setStartupConfigurations(shared, local);
    }

    public void reset() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        this.myModel.setData(projectStartupTaskManager.getSharedConfigurations(), projectStartupTaskManager.getLocalConfigurations());
        this.refreshDataUpdateSelection(null);
    }

    public void disposeUIResources() {
    }

    private void installRenderers() {
        TableColumn checkboxColumn = this.myTable.getColumnModel().getColumn(1);
        String header = checkboxColumn.getHeaderValue().toString();
        FontMetrics fm = this.myTable.getFontMetrics(this.myTable.getTableHeader().getFont());
        int width = -new JBCheckBox().getPreferredSize().width + fm.stringWidth(header + "ww");
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn, (int)width);
        checkboxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        nameColumn.setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                RunnerAndConfigurationSettings settings = ProjectStartupConfigurable.this.myModel.getAllConfigurations().get(row);
                this.setIcon(settings.getConfiguration().getIcon());
                this.append(settings.getName());
            }
        });
    }
}

