/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralIdBasedToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private final HashMap<String, Node> myNodeByIdMap;
    private final Set<Node> myRunningTestNodes;
    private final Set<Node> myRunningSuiteNodes;
    private final SMTestProxy.SMRootTestProxy myTestsRootProxy;
    private final Node myTestsRootNode;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator;
    private TestProxyPrinterProvider myTestProxyPrinterProvider;

    public GeneralIdBasedToSMTRunnerEventsConvertor(Project project2, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        if (testsRootProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRootProxy", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "<init>"));
        }
        super(project2, testFrameworkName);
        this.myNodeByIdMap = new HashMap();
        this.myRunningTestNodes = ContainerUtil.newHashSet();
        this.myRunningSuiteNodes = ContainerUtil.newHashSet();
        this.myIsTestingFinished = false;
        this.myLocator = null;
        this.myTestProxyPrinterProvider = null;
        this.myTestsRootProxy = testsRootProxy;
        this.myTestsRootNode = new Node("0", null, testsRootProxy);
        this.myNodeByIdMap.put((Object)this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void setLocator(@NotNull SMTestLocator locator) {
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "setLocator"));
        }
        this.myLocator = locator;
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(() -> {
            this.myTestsRootNode.setState(State.RUNNING, this);
            this.myTestsRootProxy.setStarted();
            this.fireOnTestingStarted(this.myTestsRootProxy);
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(() -> GeneralIdBasedToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootProxy));
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(() -> {
            if (this.myIsTestingFinished) {
                return;
            }
            this.myIsTestingFinished = true;
            boolean completeTree = GeneralIdBasedToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestNodes, this.myTestsRootProxy);
            if (completeTree) {
                this.myTestsRootProxy.setFinished();
            } else {
                this.myTestsRootProxy.setTerminated();
            }
            if (!this.myRunningTestNodes.isEmpty()) {
                this.logProblem("Unexpected running nodes: " + this.myRunningTestNodes);
            }
            this.myNodeByIdMap.clear();
            this.myRunningTestNodes.clear();
            this.myRunningSuiteNodes.clear();
            this.fireOnTestingFinished(this.myTestsRootProxy);
        });
        this.stopEventProcessing();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printerProvider", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "setPrinterProvider"));
        }
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestStarted"));
        }
        this.addToInvokeLater(() -> {
            if (testStartedEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onTestStarted$3"));
            }
            this.doStartNode(testStartedEvent, false);
        });
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onSuiteStarted"));
        }
        this.addToInvokeLater(() -> {
            if (suiteStartedEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onSuiteStarted$4"));
            }
            this.doStartNode(suiteStartedEvent, true);
        });
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        if (startedNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "doStartNode"));
        }
        Node node = this.findNode(startedNodeEvent);
        if (node != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return;
        }
        String nodeId = this.validateAndGetNodeId(startedNodeEvent);
        if (nodeId == null) {
            return;
        }
        String nodeName = startedNodeEvent.getName();
        SMTestProxy childProxy = new SMTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), true);
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        node = new Node(nodeId, parentNode, childProxy);
        this.myNodeByIdMap.put((Object)startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        if (startedNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findValidParentNode"));
        }
        String parentId = startedNodeEvent.getParentId();
        if (parentId == null) {
            this.logProblem("Parent node id should be defined: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get((Object)parentId);
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestFinished"));
        }
        this.addToInvokeLater(() -> {
            if (testFinishedEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onTestFinished$5"));
            }
            Node node = this.findNodeToTerminate(testFinishedEvent);
            if (node != null) {
                SMTestProxy testProxy = node.getProxy();
                testProxy.setDuration(testFinishedEvent.getDuration());
                testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
                testProxy.setFinished();
                if (node.getState() != State.FAILED) {
                    this.fireOnTestFinished(testProxy);
                }
                this.terminateNode(node, State.FINISHED);
            }
        });
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onSuiteFinished"));
        }
        this.addToInvokeLater(() -> {
            if (suiteFinishedEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onSuiteFinished$6"));
            }
            Node node = this.findNodeToTerminate(suiteFinishedEvent);
            if (node != null) {
                SMTestProxy suiteProxy = node.getProxy();
                suiteProxy.setFinished();
                this.fireOnSuiteFinished(suiteProxy);
                this.terminateNode(node, State.FINISHED);
            }
        });
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findNodeToTerminate"));
        }
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish nonexistent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onUncapturedOutput"));
        }
        this.addToInvokeLater(() -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onUncapturedOutput$7"));
            }
            Node activeNode = this.findActiveNode();
            SMTestProxy activeProxy = activeNode.getProxy();
            if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                activeProxy.addStdErr(text);
            } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                activeProxy.addSystemOutput(text);
            } else {
                activeProxy.addStdOutput(text, outputType);
            }
        });
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onError"));
        }
        this.addToInvokeLater(() -> {
            if (localizedMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onError$8"));
            }
            Node activeNode = this.findActiveNode();
            SMTestProxy activeProxy = activeNode.getProxy();
            activeProxy.addError(localizedMessage, stackTrace, isCritical);
        });
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestFailure"));
        }
        this.addToInvokeLater(() -> {
            if (testFailedEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onTestFailure$9"));
            }
            Node node = this.findNodeToTerminate(testFailedEvent);
            if (node == null) {
                return;
            }
            SMTestProxy testProxy = node.getProxy();
            String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
            String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
            String failureMessage = testFailedEvent.getLocalizedFailureMessage();
            String stackTrace = testFailedEvent.getStacktrace();
            if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText, testFailedEvent.getExpectedFilePath(), testFailedEvent.getActualFilePath());
            } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
            } else {
                this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\nActual:\n" + comparisonFailureActualText);
            }
            long duration = testFailedEvent.getDurationMillis();
            if (duration >= 0L) {
                testProxy.setDuration(duration);
            }
            this.fireOnTestFinished(testProxy);
            this.fireOnTestFailed(testProxy);
            this.terminateNode(node, State.FAILED);
        });
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnoredEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestIgnored"));
        }
        this.addToInvokeLater(() -> {
            if (testIgnoredEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnoredEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onTestIgnored$10"));
            }
            Node node = this.findNodeToTerminate(testIgnoredEvent);
            if (node != null) {
                SMTestProxy testProxy = node.getProxy();
                testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                this.fireOnTestIgnored(testProxy);
                this.terminateNode(node, State.IGNORED);
            }
        });
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testOutputEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestOutput"));
        }
        this.addToInvokeLater(() -> {
            if (testOutputEvent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testOutputEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "lambda$onTestOutput$11"));
            }
            Node node = this.findNode(testOutputEvent);
            if (node == null) {
                this.logProblem("Test wasn't started! But " + testOutputEvent + "!");
                return;
            }
            SMTestProxy testProxy = node.getProxy();
            if (testOutputEvent.isStdOut()) {
                testProxy.addStdOutput(testOutputEvent.getText(), ProcessOutputTypes.STDOUT);
            } else {
                testProxy.addStdErr(testOutputEvent.getText());
            }
        });
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.addToInvokeLater(() -> this.fireOnTestsCountInSuite(count));
    }

    @Nullable
    private String validateAndGetNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "validateAndGetNodeId"));
        }
        String nodeId = treeNodeEvent.getId();
        if (nodeId == null || nodeId.equals("0")) {
            this.logProblem((nodeId == null ? "Missing" : "Illegal") + " nodeId: " + treeNodeEvent, true);
        }
        return nodeId;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findNode"));
        }
        String nodeId = this.validateAndGetNodeId(treeNodeEvent);
        return nodeId != null ? (Node)this.myNodeByIdMap.get((Object)nodeId) : null;
    }

    @Nullable
    public SMTestProxy findProxyById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findProxyById"));
        }
        Node node = (Node)this.myNodeByIdMap.get((Object)id);
        return node != null ? node.getProxy() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(() -> {
            Application application;
            this.disconnectListeners();
            if (!(this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                this.logProblem("Not all events were processed!");
            }
            this.myRunningTestNodes.clear();
            this.myRunningSuiteNodes.clear();
            this.myNodeByIdMap.clear();
        });
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        if (lowestNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowestNode", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "setNodeAndAncestorsRunning"));
        }
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING, this);
            SMTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.myRunningSuiteNodes.add(node);
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "terminateNode"));
        }
        if (terminateState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminateState", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "terminateNode"));
        }
        node.setState(terminateState, this);
        this.myRunningTestNodes.remove(node);
        this.myRunningSuiteNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        if (!this.myRunningTestNodes.isEmpty()) {
            Node node = this.myRunningTestNodes.iterator().next();
            if (node == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findActiveNode"));
            }
            return node;
        }
        if (!this.myRunningSuiteNodes.isEmpty()) {
            Node node = this.myRunningSuiteNodes.iterator().next();
            if (node == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findActiveNode"));
            }
            return node;
        }
        Node node = this.myTestsRootNode;
        if (node == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findActiveNode"));
        }
        return node;
    }

    @Override
    public void onRootPresentationAdded(String rootName, String comment, String rootLocation) {
        this.addToInvokeLater(() -> {
            this.myTestsRootProxy.setPresentation(rootName);
            this.myTestsRootProxy.setComment(comment);
            this.myTestsRootProxy.setRootLocationUrl(rootLocation);
            if (this.myLocator != null) {
                this.myTestsRootProxy.setLocator(this.myLocator);
            }
        });
    }

    private static class Node {
        private final String myId;
        private final Node myParentNode;
        private final SMTestProxy myProxy;
        private State myState;

        Node(@NotNull String id, @Nullable Node parentNode, @NotNull SMTestProxy proxy) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "<init>"));
            }
            if (proxy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "<init>"));
            }
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "getId"));
            }
            return string;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public SMTestProxy getProxy() {
            SMTestProxy sMTestProxy = this.myProxy;
            if (sMTestProxy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "getProxy"));
            }
            return sMTestProxy;
        }

        @NotNull
        public State getState() {
            State state = this.myState;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "getState"));
            }
            return state;
        }

        public void setState(@NotNull State newState, @NotNull GeneralIdBasedToSMTRunnerEventsConvertor convertor) {
            if (newState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "setState"));
            }
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "setState"));
            }
            if (this.myState == State.NOT_RUNNING && newState != State.RUNNING && newState != State.IGNORED || this.myState == State.RUNNING && newState != State.FINISHED && newState != State.FAILED && newState != State.IGNORED || this.myState == State.FINISHED && newState != State.FAILED || this.myState == State.FAILED && newState != State.FINISHED || this.myState == State.IGNORED && newState != State.FINISHED) {
                convertor.logProblem("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString(), false);
            }
            if (this.myState.ordinal() < newState.ordinal()) {
                this.myState = newState;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId.hashCode();
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

