/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.facetType;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.facet.impl.ui.facetType.DefaultFacetSettingsConfigurable;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurableGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTypeEditor
extends UnnamedConfigurableGroup {
    private final Project myProject;
    private final StructureConfigurableContext myContext;
    private final FacetType<?, ?> myFacetType;
    private Configurable myDefaultSettingsConfigurable;
    private MultipleFacetSettingsEditor myAllFacetsEditor;
    private List<Configurable> myCurrentConfigurables;
    private TabbedPaneWrapper myTabbedPane;
    private final Disposable myDisposable;

    public <C extends FacetConfiguration> FacetTypeEditor(@NotNull Project project2, StructureConfigurableContext context, @NotNull FacetType<?, C> facetType) {
        FacetConfiguration configuration;
        DefaultFacetSettingsEditor defaultSettingsEditor;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/impl/ui/facetType/FacetTypeEditor", "<init>"));
        }
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/facet/impl/ui/facetType/FacetTypeEditor", "<init>"));
        }
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project2;
        this.myContext = context;
        this.myFacetType = facetType;
        if (!(facetType instanceof InvalidFacetType) && (defaultSettingsEditor = facetType.createDefaultConfigurationEditor(project2, configuration = ProjectFacetManager.getInstance((Project)project2).createDefaultConfiguration(facetType))) != null) {
            this.myDefaultSettingsConfigurable = new DefaultFacetSettingsConfigurable<FacetConfiguration>(facetType, project2, defaultSettingsEditor, configuration);
            this.add((UnnamedConfigurable)this.myDefaultSettingsConfigurable);
        }
    }

    public boolean isVisible() {
        return this.myDefaultSettingsConfigurable != null || this.myAllFacetsEditor != null;
    }

    @Nullable
    private MultipleFacetSettingsEditor createAllFacetsEditor() {
        ProjectFacetsConfigurator facetsConfigurator = this.myContext.myModulesConfigurator.getFacetsConfigurator();
        ArrayList facets = new ArrayList();
        for (Module module2 : this.myContext.getModules()) {
            facets.addAll(facetsConfigurator.getFacetsByType(module2, this.myFacetType.getId()));
        }
        if (!facets.isEmpty()) {
            FacetEditor[] editors = new FacetEditor[facets.size()];
            for (int i2 = 0; i2 < facets.size(); ++i2) {
                editors[i2] = facetsConfigurator.getOrCreateEditor((Facet)facets.get(i2));
            }
            return this.myFacetType.createMultipleConfigurationsEditor(this.myProject, editors);
        }
        return null;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
        super.disposeUIResources();
    }

    public JComponent createComponent() {
        MultipleFacetSettingsEditor allFacetsEditor = this.createAllFacetsEditor();
        if (this.myAllFacetsEditor != null) {
            this.myAllFacetsEditor.disposeUIResources();
        }
        this.myAllFacetsEditor = allFacetsEditor;
        this.myCurrentConfigurables = new ArrayList<Configurable>();
        if (this.myDefaultSettingsConfigurable != null) {
            this.myCurrentConfigurables.add(this.myDefaultSettingsConfigurable);
        }
        if (this.myAllFacetsEditor != null) {
            this.myCurrentConfigurables.add(new AllFacetsConfigurable(this.myAllFacetsEditor));
        }
        if (this.myCurrentConfigurables.isEmpty()) {
            return new JPanel();
        }
        if (this.myCurrentConfigurables.size() == 1) {
            return this.myCurrentConfigurables.get(0).createComponent();
        }
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        for (Configurable configurable : this.myCurrentConfigurables) {
            this.myTabbedPane.addTab(configurable.getDisplayName(), configurable.createComponent());
        }
        return this.myTabbedPane.getComponent();
    }

    @Nullable
    public String getHelpTopic() {
        int selectedTab;
        int n = selectedTab = this.myTabbedPane != null ? this.myTabbedPane.getSelectedIndex() : 0;
        if (this.myCurrentConfigurables != null && 0 <= selectedTab && selectedTab < this.myCurrentConfigurables.size()) {
            return this.myCurrentConfigurables.get(selectedTab).getHelpTopic();
        }
        return null;
    }

    private static class AllFacetsConfigurable
    implements Configurable {
        private final MultipleFacetSettingsEditor myEditor;

        public AllFacetsConfigurable(MultipleFacetSettingsEditor editor) {
            this.myEditor = editor;
        }

        public String getDisplayName() {
            return ProjectBundle.message((String)"tab.name.all.facets", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            return this.myEditor.getHelpTopic();
        }

        public JComponent createComponent() {
            return this.myEditor.createComponent();
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        public void reset() {
        }

        public void disposeUIResources() {
            this.myEditor.disposeUIResources();
        }
    }
}

