/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.BlockProcessor;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.ExtraRangesProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/formatting/AdditionalRangesExtractor;", "Lcom/intellij/formatting/BlockProcessor;", "info", "Lcom/intellij/formatting/FormattingRangesInfo;", "(Lcom/intellij/formatting/FormattingRangesInfo;)V", "totalNewRanges", "", "Lcom/intellij/openapi/util/TextRange;", "getTotalNewRanges", "()Ljava/util/List;", "extractRanges", "", "block", "Lcom/intellij/formatting/Block;", "processCompositeBlock", "processLeafBlock", "lang-impl"})
public final class AdditionalRangesExtractor
implements BlockProcessor {
    @NotNull
    private final List<TextRange> totalNewRanges;
    private final FormattingRangesInfo info;

    @NotNull
    public final List<TextRange> getTotalNewRanges() {
        return this.totalNewRanges;
    }

    @Override
    public void processLeafBlock(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.extractRanges(block);
    }

    @Override
    public void processCompositeBlock(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.extractRanges(block);
    }

    private final void extractRanges(Block block) {
        List<TextRange> newRanges;
        if (block instanceof ExtraRangesProvider && (newRanges = ((ExtraRangesProvider)block).getExtraRangesToFormat(this.info)) != null) {
            this.totalNewRanges.addAll((Collection<TextRange>)newRanges);
        }
    }

    public AdditionalRangesExtractor(@NotNull FormattingRangesInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        this.info = info;
        this.totalNewRanges = CollectionsKt.mutableListOf((Object[])new TextRange[0]);
    }
}

