/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class FormatTextRange {
    @NotNull
    private TextRange formattingRange;
    private final boolean processHeadingWhitespace;

    public FormatTextRange(@NotNull TextRange range, boolean processHeadingSpace) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/FormatTextRange", "<init>"));
        }
        this.formattingRange = range;
        this.processHeadingWhitespace = processHeadingSpace;
    }

    public boolean isProcessHeadingWhitespace() {
        return this.processHeadingWhitespace;
    }

    public boolean isWhitespaceReadOnly(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/FormatTextRange", "isWhitespaceReadOnly"));
        }
        if (range.getStartOffset() >= this.formattingRange.getEndOffset()) {
            return true;
        }
        if (this.processHeadingWhitespace && range.getEndOffset() == this.formattingRange.getStartOffset()) {
            return false;
        }
        return range.getEndOffset() <= this.formattingRange.getStartOffset();
    }

    public int getStartOffset() {
        return this.formattingRange.getStartOffset();
    }

    public boolean isReadOnly(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/FormatTextRange", "isReadOnly"));
        }
        return range.getStartOffset() > this.formattingRange.getEndOffset() || range.getEndOffset() < this.formattingRange.getStartOffset();
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.formattingRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatTextRange", "getTextRange"));
        }
        return textRange;
    }

    public void setTextRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/FormatTextRange", "setTextRange"));
        }
        this.formattingRange = range;
    }

    public TextRange getNonEmptyTextRange() {
        int endOffset = this.formattingRange.getStartOffset() == this.formattingRange.getEndOffset() ? this.formattingRange.getEndOffset() + 1 : this.formattingRange.getEndOffset();
        return new TextRange(this.formattingRange.getStartOffset(), endOffset);
    }

    public String toString() {
        return this.formattingRange.toString() + (this.processHeadingWhitespace ? "+" : "");
    }
}

