/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingStateId;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingProgressTask
extends SequentialModalProgressTask
implements FormattingProgressCallback {
    public static final ThreadLocal<Boolean> FORMATTING_CANCELLED_FLAG = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final double MAX_PROGRESS_VALUE = 1.0;
    private static final double TOTAL_WEIGHT = Arrays.stream(FormattingStateId.values()).mapToDouble(FormattingStateId::getProgressWeight).sum();
    private final ConcurrentMap<FormattingProgressCallback.EventType, Collection<Runnable>> myCallbacks;
    private final WeakReference<VirtualFile> myFile;
    private final WeakReference<Document> myDocument;
    private final int myFileTextLength;
    @NotNull
    private FormattingStateId myLastState;
    private long myDocumentModificationStampBefore;
    private int myBlocksToModifyNumber;
    private int myModifiedBlocksNumber;

    public FormattingProgressTask(@Nullable Project project2, @NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/FormattingProgressTask", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/formatting/FormattingProgressTask", "<init>"));
        }
        super(project2, FormattingProgressTask.getTitle(file2));
        this.myCallbacks = ContainerUtil.newConcurrentMap();
        this.myLastState = FormattingStateId.WRAPPING_BLOCKS;
        this.myDocumentModificationStampBefore = -1L;
        this.myFile = new WeakReference<VirtualFile>(file2.getVirtualFile());
        this.myDocument = new WeakReference<Document>(document);
        this.myFileTextLength = file2.getTextLength();
        this.addCallback(FormattingProgressCallback.EventType.CANCEL, new MyCancelCallback());
    }

    @NotNull
    private static String getTitle(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/FormattingProgressTask", "getTitle"));
        }
        VirtualFile virtualFile = file2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            String string = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormattingProgressTask", "getTitle"));
            }
            return string;
        }
        String string = CodeInsightBundle.message((String)"reformat.progress.file.with.known.name.text", (Object[])new Object[]{virtualFile.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormattingProgressTask", "getTitle"));
        }
        return string;
    }

    @Override
    protected void prepare(@NotNull SequentialTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/formatting/FormattingProgressTask", "prepare"));
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/formatting/FormattingProgressTask", "lambda$prepare$0"));
            }
            Document document = (Document)this.myDocument.get();
            if (document != null) {
                this.myDocumentModificationStampBefore = document.getModificationStamp();
            }
            task.prepare();
        });
    }

    @Override
    public boolean addCallback(@NotNull FormattingProgressCallback.EventType eventType, @NotNull Runnable callback) {
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/formatting/FormattingProgressTask", "addCallback"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/formatting/FormattingProgressTask", "addCallback"));
        }
        return this.getCallbacks(eventType).add(callback);
    }

    public void onSuccess() {
        for (Runnable callback : this.getCallbacks(FormattingProgressCallback.EventType.SUCCESS)) {
            callback.run();
        }
    }

    public void onCancel() {
        for (Runnable callback : this.getCallbacks(FormattingProgressCallback.EventType.CANCEL)) {
            callback.run();
        }
    }

    public void onError(@NotNull Exception error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/formatting/FormattingProgressTask", "onError"));
        }
        super.onError(error);
        for (Runnable callback : this.getCallbacks(FormattingProgressCallback.EventType.CANCEL)) {
            callback.run();
        }
    }

    private Collection<Runnable> getCallbacks(@NotNull FormattingProgressCallback.EventType eventType) {
        Collection<Runnable> candidate;
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/formatting/FormattingProgressTask", "getCallbacks"));
        }
        Collection<Runnable> result2 = (Collection<Runnable>)this.myCallbacks.get((Object)eventType);
        if (result2 == null && (candidate = this.myCallbacks.putIfAbsent(eventType, result2 = ContainerUtil.newConcurrentSet())) != null) {
            result2 = candidate;
        }
        return result2;
    }

    @Override
    public void afterWrappingBlock(@NotNull LeafBlockWrapper wrapped) {
        if (wrapped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "com/intellij/formatting/FormattingProgressTask", "afterWrappingBlock"));
        }
        this.update(FormattingStateId.WRAPPING_BLOCKS, 1.0 * (double)wrapped.getEndOffset() / (double)this.myFileTextLength);
    }

    @Override
    public void afterProcessingBlock(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormattingProgressTask", "afterProcessingBlock"));
        }
        this.update(FormattingStateId.PROCESSING_BLOCKS, 1.0 * (double)block.getEndOffset() / (double)this.myFileTextLength);
    }

    @Override
    public void beforeApplyingFormatChanges(@NotNull Collection<LeafBlockWrapper> modifiedBlocks) {
        if (modifiedBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedBlocks", "com/intellij/formatting/FormattingProgressTask", "beforeApplyingFormatChanges"));
        }
        this.myBlocksToModifyNumber = modifiedBlocks.size();
        this.updateTextIfNecessary(FormattingStateId.APPLYING_CHANGES);
        this.setCancelText(IdeBundle.message((String)"action.stop", (Object[])new Object[0]));
    }

    @Override
    public void afterApplyingChange(@NotNull LeafBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormattingProgressTask", "afterApplyingChange"));
        }
        if (this.myModifiedBlocksNumber++ >= this.myBlocksToModifyNumber) {
            return;
        }
        this.update(FormattingStateId.APPLYING_CHANGES, 1.0 * (double)this.myModifiedBlocksNumber / (double)this.myBlocksToModifyNumber);
    }

    private void update(@NotNull FormattingStateId state, double completionRate) {
        double currentFraction;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/formatting/FormattingProgressTask", "update"));
        }
        ProgressIndicator indicator = this.getIndicator();
        if (indicator == null) {
            return;
        }
        this.updateTextIfNecessary(state);
        this.myLastState = state;
        double newFraction = 0.0;
        for (FormattingStateId prevState : state.getPreviousStates()) {
            newFraction += 1.0 * prevState.getProgressWeight() / TOTAL_WEIGHT;
        }
        if ((newFraction += completionRate * state.getProgressWeight() / TOTAL_WEIGHT) - (currentFraction = indicator.getFraction()) < 0.01) {
            return;
        }
        indicator.setFraction(newFraction);
    }

    private void updateTextIfNecessary(@NotNull FormattingStateId currentState) {
        if (currentState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentState", "com/intellij/formatting/FormattingProgressTask", "updateTextIfNecessary"));
        }
        ProgressIndicator indicator = this.getIndicator();
        if (this.myLastState != currentState && indicator != null) {
            indicator.setText(currentState.getDescription());
        }
    }

    private class MyCancelCallback
    implements Runnable {
        private MyCancelCallback() {
        }

        @Override
        public void run() {
            FORMATTING_CANCELLED_FLAG.set(true);
            VirtualFile file2 = (VirtualFile)FormattingProgressTask.this.myFile.get();
            Document document = (Document)FormattingProgressTask.this.myDocument.get();
            if (file2 == null || document == null || FormattingProgressTask.this.myDocumentModificationStampBefore < 0L) {
                return;
            }
            FileEditor editor = FileEditorManager.getInstance((Project)FormattingProgressTask.this.myProject).getSelectedEditor(file2);
            if (editor == null) {
                return;
            }
            UndoManager manager = UndoManager.getInstance((Project)FormattingProgressTask.this.myProject);
            while (manager.isUndoAvailable(editor) && document.getModificationStamp() != FormattingProgressTask.this.myDocumentModificationStampBefore) {
                manager.undo(editor);
            }
        }
    }
}

