/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class CreateTemplateInPackageAction<T extends PsiElement>
extends CreateFromTemplateAction<T> {
    private Set<? extends JpsModuleSourceRootType<?>> mySourceRootTypes;

    protected CreateTemplateInPackageAction(String text, String description, Icon icon, Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        super(text, description, icon);
        this.mySourceRootTypes = rootTypes;
    }

    @Override
    @Nullable
    protected T createFile(String name, String templateName, PsiDirectory dir) {
        return this.checkOrCreate(name, dir, templateName);
    }

    @Nullable
    protected abstract PsiElement getNavigationElement(@NotNull T var1);

    @Override
    protected boolean isAvailable(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project2 == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        if (this.mySourceRootTypes == null) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), this.mySourceRootTypes) || !this.checkPackageExists(dir)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean checkPackageExists(PsiDirectory var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T checkOrCreate(String newName, PsiDirectory directory, String templateName) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        String className = this.removeExtension(templateName, newName);
        if (className.contains(".")) {
            String[] names = className.split("\\.");
            for (int i2 = 0; i2 < names.length - 1; ++i2) {
                String name = names[i2];
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            className = names[names.length - 1];
        }
        DumbService service = DumbService.getInstance((Project)dir.getProject());
        service.setAlternativeResolveEnabled(true);
        try {
            T t = this.doCreate(dir, className, templateName);
            return t;
        }
        finally {
            service.setAlternativeResolveEnabled(false);
        }
    }

    protected String removeExtension(String templateName, String className) {
        String extension = StringUtil.getShortName((String)templateName);
        if (StringUtil.isNotEmpty((String)extension)) {
            className = StringUtil.trimEnd((String)className, (String)("." + extension));
        }
        return className;
    }

    @Nullable
    protected abstract T doCreate(PsiDirectory var1, String var2, String var3) throws IncorrectOperationException;
}

