/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchyTreeStructure
extends AbstractTreeStructure {
    protected HierarchyNodeDescriptor myBaseDescriptor;
    private HierarchyNodeDescriptor myRoot;
    @NotNull
    protected final Project myProject;

    protected HierarchyTreeStructure(@NotNull Project project2, HierarchyNodeDescriptor baseDescriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/hierarchy/HierarchyTreeStructure", "<init>"));
        }
        this.myBaseDescriptor = baseDescriptor;
        this.myProject = project2;
        this.myRoot = baseDescriptor;
    }

    public final HierarchyNodeDescriptor getBaseDescriptor() {
        return this.myBaseDescriptor;
    }

    protected final void setBaseElement(@NotNull HierarchyNodeDescriptor baseElement) {
        if (baseElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseElement", "com/intellij/ide/hierarchy/HierarchyTreeStructure", "setBaseElement"));
        }
        this.myBaseDescriptor = baseElement;
        this.myRoot = baseElement;
        while (this.myRoot.getParentDescriptor() != null) {
            this.myRoot = (HierarchyNodeDescriptor)this.myRoot.getParentDescriptor();
        }
    }

    @NotNull
    public final NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor = (HierarchyNodeDescriptor)((Object)element);
            if (hierarchyNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/HierarchyTreeStructure", "createDescriptor"));
            }
            return hierarchyNodeDescriptor;
        }
        if (element instanceof String) {
            TextInfoNodeDescriptor textInfoNodeDescriptor = new TextInfoNodeDescriptor(parentDescriptor, (String)element, this.myProject);
            if (textInfoNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/HierarchyTreeStructure", "createDescriptor"));
            }
            return textInfoNodeDescriptor;
        }
        throw new IllegalArgumentException("Unknown element type: " + element);
    }

    public final boolean isToBuildChildrenInBackground(Object element) {
        HierarchyNodeDescriptor descriptor;
        Object[] cachedChildren;
        return element instanceof HierarchyNodeDescriptor && (cachedChildren = (descriptor = (HierarchyNodeDescriptor)((Object)element)).getCachedChildren()) == null && descriptor.isValid();
    }

    public final Object[] getChildElements(Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor.getCachedChildren();
            if (cachedChildren == null) {
                if (descriptor.isValid()) {
                    descriptor.setCachedChildren(this.buildChildren(descriptor));
                } else {
                    descriptor.setCachedChildren(ArrayUtil.EMPTY_OBJECT_ARRAY);
                }
            }
            return descriptor.getCachedChildren();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public final Object getParentElement(Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            return ((HierarchyNodeDescriptor)((Object)element)).getParentDescriptor();
        }
        return null;
    }

    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public final boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = HierarchyTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/HierarchyTreeStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    @NotNull
    protected abstract Object[] buildChildren(@NotNull HierarchyNodeDescriptor var1);

    public final Object getRootElement() {
        return this.myRoot;
    }

    protected SearchScope getSearchScope(String scopeType, PsiElement thisClass) {
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            searchScope = new LocalSearchScope(thisClass);
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            searchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject);
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            searchScope = GlobalSearchScopesCore.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        return searchScope;
    }

    protected boolean isInScope(PsiElement baseClass, PsiElement srcElement, String scopeType) {
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            if (!PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)srcElement, (boolean)true)) {
                return false;
            }
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            if (virtualFile != null && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject)) {
                return false;
            }
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            if (virtualFile != null && !TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject)) {
                return false;
            }
        } else if (!HierarchyBrowserBaseEx.SCOPE_ALL.equals(scopeType)) {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
            if (namedScope == null) {
                return false;
            }
            PackageSet namedScopePattern = namedScope.getValue();
            if (namedScopePattern == null) {
                return false;
            }
            PsiFile psiFile = srcElement.getContainingFile();
            if (psiFile != null && !namedScopePattern.contains(psiFile, NamedScopesHolder.getHolder((Project)this.myProject, (String)scopeType, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.myProject)))) {
                return false;
            }
        }
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    private static final class TextInfoNodeDescriptor
    extends NodeDescriptor {
        public TextInfoNodeDescriptor(NodeDescriptor parentDescriptor, String text, Project project2) {
            super(project2, parentDescriptor);
            this.myName = text;
            this.myColor = JBColor.RED;
        }

        public final Object getElement() {
            return this.myName;
        }

        public final boolean update() {
            return true;
        }
    }
}

