/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PatchProjectUtil {
    private PatchProjectUtil() {
    }

    public static void patchProject(Project project2) {
        final Map<Pattern, Set<Pattern>> excludePatterns = PatchProjectUtil.loadPatterns("idea.exclude.patterns");
        final Map<Pattern, Set<Pattern>> includePatterns = PatchProjectUtil.loadPatterns("idea.include.patterns");
        if (excludePatterns.isEmpty() && includePatterns.isEmpty()) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        ModifiableModuleModel modulesModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
        final Module[] modules = modulesModel.getModules();
        ModifiableRootModel[] models = new ModifiableRootModel[modules.length];
        for (int i2 = 0; i2 < modules.length; ++i2) {
            ContentEntry[] contentEntries;
            models[i2] = ModuleRootManager.getInstance((Module)modules[i2]).getModifiableModel();
            final int idx = i2;
            for (final ContentEntry contentEntry : contentEntries = models[i2].getContentEntries()) {
                final VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                final HashSet<VirtualFile> included = new HashSet<VirtualFile>();
                PatchProjectUtil.iterate(contentRoot, new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        Set dirPatterns;
                        String relativeName = VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)contentRoot, (char)'/');
                        for (Pattern module2 : excludePatterns.keySet()) {
                            if (module2 != null && !module2.matcher(modules[idx].getName()).matches()) continue;
                            dirPatterns = (Set)excludePatterns.get(module2);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                contentEntry.addExcludeFolder(fileOrDir);
                                return false;
                            }
                        }
                        if (includePatterns.isEmpty()) {
                            return true;
                        }
                        for (Pattern module2 : includePatterns.keySet()) {
                            if (module2 != null && !module2.matcher(modules[idx].getName()).matches()) continue;
                            dirPatterns = (Set)includePatterns.get(module2);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                included.add(fileOrDir);
                                return true;
                            }
                        }
                        return true;
                    }
                }, index);
                PatchProjectUtil.processIncluded(contentEntry, included);
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> ModifiableModelCommitter.multiCommit(models, modulesModel));
    }

    public static void processIncluded(ContentEntry contentEntry, Set<VirtualFile> included) {
        if (included.isEmpty()) {
            return;
        }
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VirtualFile file2 : included) {
            if (Comparing.equal((Object)file2, (Object)contentEntry.getFile())) {
                return;
            }
            VirtualFile parent = file2.getParent();
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
            for (VirtualFile toExclude : parent.getChildren()) {
                boolean toExcludeSibling = true;
                for (VirtualFile includeRoot : included) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)toExclude, (VirtualFile)includeRoot, (boolean)false)) continue;
                    toExcludeSibling = false;
                }
                if (!toExcludeSibling) continue;
                contentEntry.addExcludeFolder(toExclude);
            }
        }
        PatchProjectUtil.processIncluded(contentEntry, parents);
    }

    public static void iterate(VirtualFile contentRoot, final ContentIterator iterator, final ProjectFileIndex idx) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)contentRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/impl/PatchProjectUtil$2", "visitFile"));
                }
                if (!iterator.processFile(file2)) {
                    return false;
                }
                return idx.getModuleForFile(file2) != null;
            }
        });
    }

    public static Map<Pattern, Set<Pattern>> loadPatterns(@NonNls String propertyKey) {
        HashMap<Pattern, Set<Pattern>> result2 = new HashMap<Pattern, Set<Pattern>>();
        String patterns = System.getProperty(propertyKey);
        if (patterns != null) {
            String[] pathPatterns;
            for (String excludedPattern : pathPatterns = patterns.split(";")) {
                String module2 = null;
                int idx = 0;
                if (excludedPattern.startsWith("[")) {
                    idx = excludedPattern.indexOf("]") + 1;
                    module2 = excludedPattern.substring(1, idx - 1);
                }
                Pattern modulePattern = module2 != null ? Pattern.compile(StringUtil.replace(module2, (String)"*", (String)".*")) : null;
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)excludedPattern.substring(idx)));
                HashSet<Pattern> dirPatterns = (HashSet<Pattern>)result2.get(modulePattern);
                if (dirPatterns == null) {
                    dirPatterns = new HashSet<Pattern>();
                    result2.put(modulePattern, dirPatterns);
                }
                dirPatterns.add(pattern);
            }
        }
        return result2;
    }
}

