/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ModuleGroup {
    public static final DataKey<ModuleGroup[]> ARRAY_DATA_KEY = DataKey.create((String)"moduleGroup.array");
    private final String[] myGroupPath;

    public ModuleGroup(@NotNull String[] groupPath) {
        if (groupPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPath", "com/intellij/ide/projectView/impl/ModuleGroup", "<init>"));
        }
        this.myGroupPath = groupPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroup)) {
            return false;
        }
        ModuleGroup moduleGroup = (ModuleGroup)o;
        return Arrays.equals(this.myGroupPath, moduleGroup.myGroupPath);
    }

    public int hashCode() {
        return this.myGroupPath[this.myGroupPath.length - 1].hashCode();
    }

    public String[] getGroupPath() {
        return this.myGroupPath;
    }

    @NotNull
    public Collection<Module> modulesInGroup(Project project2, boolean recursively) {
        Module[] allModules = ModuleManager.getInstance((Project)project2).getModules();
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module2 : allModules) {
            Object[] group = ModuleManager.getInstance((Project)project2).getModuleGroupPath(module2);
            if (group == null || !Arrays.equals(this.myGroupPath, group) && (!recursively || !ModuleGroup.isChild(this.myGroupPath, (String[])group))) continue;
            result2.add(module2);
        }
        ArrayList<Module> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ModuleGroup", "modulesInGroup"));
        }
        return arrayList;
    }

    public Collection<ModuleGroup> childGroups(Project project2) {
        return this.childGroups(null, project2);
    }

    public Collection<ModuleGroup> childGroups(DataContext dataContext) {
        return this.childGroups((ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext), (Project)CommonDataKeys.PROJECT.getData(dataContext));
    }

    public Collection<ModuleGroup> childGroups(ModifiableModuleModel model, Project project2) {
        Module[] allModules = model != null ? model.getModules() : ModuleManager.getInstance((Project)project2).getModules();
        THashSet result2 = new THashSet();
        for (Module module2 : allModules) {
            String[] directChild;
            String[] group = model != null ? model.getModuleGroupPath(module2) : ModuleManager.getInstance((Project)project2).getModuleGroupPath(module2);
            if (group == null || (directChild = ModuleGroup.directChild(this.myGroupPath, group)) == null) continue;
            result2.add(new ModuleGroup(directChild));
        }
        return result2;
    }

    private static boolean isChild(String[] parent, String[] descendant) {
        if (parent.length >= descendant.length) {
            return false;
        }
        for (int i2 = 0; i2 < parent.length; ++i2) {
            String group = parent[i2];
            if (group.equals(descendant[i2])) continue;
            return false;
        }
        return true;
    }

    private static String[] directChild(String[] parent, String[] descendant) {
        if (!ModuleGroup.isChild(parent, descendant)) {
            return null;
        }
        return (String[])ArrayUtil.append((Object[])parent, (Object)descendant[parent.length]);
    }

    public String presentableText() {
        return "'" + this.myGroupPath[this.myGroupPath.length - 1] + "'";
    }

    public String toString() {
        return this.myGroupPath[this.myGroupPath.length - 1];
    }
}

