/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;

public abstract class ShowModulesAction
extends ToggleAction {
    private final Project myProject;

    public ShowModulesAction(Project project2) {
        super(IdeBundle.message((String)"action.show.modules", (Object[])new Object[0]), IdeBundle.message((String)"action.description.show.modules", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowModules);
        this.myProject = project2;
    }

    public boolean isSelected(AnActionEvent event) {
        return ProjectView.getInstance(this.myProject).isShowModules(this.getId());
    }

    @NotNull
    protected abstract String getId();

    public void setSelected(AnActionEvent event, boolean flag) {
        ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance(this.myProject);
        projectView.setShowModules(flag, this.getId());
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance(this.myProject);
        presentation.setVisible(ShowModulesAction.hasModules() && Comparing.strEqual((String)projectView.getCurrentViewId(), (String)this.getId()));
    }

    private static boolean hasModules() {
        return PlatformUtils.isIntelliJ();
    }
}

