/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaLambdaTreeElement;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaLambdaNodeProvider
implements FileStructureNodeProvider<JavaLambdaTreeElement>,
PropertyOwner {
    public static final String ID = "SHOW_LAMBDA";
    public static final String JAVA_LAMBDA_PROPERTY_NAME = "java.lambda.provider";

    @NotNull
    public List<JavaLambdaTreeElement> provideNodes(@NotNull TreeElement node) {
        Object el;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "provideNodes"));
        }
        if ((node instanceof PsiMethodTreeElement || node instanceof PsiFieldTreeElement || node instanceof ClassInitializerTreeElement || node instanceof JavaLambdaTreeElement) && (el = ((PsiTreeElementBase)node).getElement()) != null) {
            final ArrayList<JavaLambdaTreeElement> result2 = new ArrayList<JavaLambdaTreeElement>();
            el.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    super.visitLambdaExpression(expression);
                    result2.add(new JavaLambdaTreeElement(expression));
                }

                public void visitClass(PsiClass aClass) {
                }
            });
            ArrayList<JavaLambdaTreeElement> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "provideNodes"));
            }
            return arrayList;
        }
        List<JavaLambdaTreeElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "provideNodes"));
        }
        return list;
    }

    @NotNull
    public String getCheckBoxText() {
        if ("Show Lambdas" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "getCheckBoxText"));
        }
        return "Show Lambdas";
    }

    @NotNull
    public Shortcut[] getShortcut() {
        Shortcut[] shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)(SystemInfo.isMac ? "meta L" : "control L"))};
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "getShortcut"));
        }
        return shortcutArray;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(this.getCheckBoxText(), null, AllIcons.Nodes.Function);
        if (actionPresentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "getPresentation"));
        }
        return actionPresentationData;
    }

    @NotNull
    public String getName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "getName"));
        }
        return ID;
    }

    @NotNull
    public String getPropertyName() {
        if (JAVA_LAMBDA_PROPERTY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaLambdaNodeProvider", "getPropertyName"));
        }
        return JAVA_LAMBDA_PROPERTY_NAME;
    }
}

