/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel");
    protected final Project myProject;
    private final ChooseByNameContributor[] myContributors;
    private final ConcurrentMap<ChooseByNameContributor, TIntHashSet> myContributorToItsSymbolsMap;
    private volatile IdFilter myIdFilter;
    private volatile boolean myIdFilterForLibraries;

    protected ContributorsBasedGotoByModel(@NotNull Project project2, @NotNull ChooseByNameContributor[] contributors) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "<init>"));
        }
        if (contributors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributors", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "<init>"));
        }
        this.myContributorToItsSymbolsMap = ContainerUtil.newConcurrentMap();
        this.myProject = project2;
        this.myContributors = contributors;
        assert (!Arrays.asList(contributors).contains(null));
    }

    public ListCellRenderer getListCellRenderer() {
        return new NavigationItemListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == "non-prefix matches:") {
                    Object previousElement = index > 0 ? list.getModel().getElementAt(index - 1) : null;
                    return ChooseByNameBase.renderNonPrefixSeparatorComponent(1.getBackgroundColor(previousElement));
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    public boolean sameNamesForProjectAndLibraries() {
        return !ChooseByNameBase.ourLoadNamesEachTime;
    }

    @Override
    public void processNames(final Processor<String> nameProcessor, final boolean checkBoxState) {
        long start = System.currentTimeMillis();
        List<ChooseByNameContributor> liveContribs = this.filterDumb(this.myContributors);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor2 = new ReadActionProcessor<ChooseByNameContributor>(){

            public boolean processInReadAction(@NotNull ChooseByNameContributor contributor) {
                if (contributor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel$2", "processInReadAction"));
                }
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        TIntHashSet filter = new TIntHashSet(1000);
                        ContributorsBasedGotoByModel.this.myContributorToItsSymbolsMap.put(contributor, filter);
                        if (contributor instanceof ChooseByNameContributorEx) {
                            ((ChooseByNameContributorEx)contributor).processNames((Processor<String>)((Processor)s -> {
                                if (nameProcessor.process(s)) {
                                    filter.add(s.hashCode());
                                }
                                return true;
                            }), FindSymbolParameters.searchScopeFor(ContributorsBasedGotoByModel.this.myProject, checkBoxState), ContributorsBasedGotoByModel.this.getIdFilter(checkBoxState));
                        } else {
                            String[] names;
                            for (String element : names = contributor.getNames(ContributorsBasedGotoByModel.this.myProject, checkBoxState)) {
                                if (!nameProcessor.process((Object)element)) continue;
                                filter.add(element.hashCode());
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException contributorStarted) {
                }
                catch (IndexNotReadyException contributorStarted) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(liveContribs, indicator, true, processor2)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start) + "ms;");
        }
    }

    IdFilter getIdFilter(boolean withLibraries) {
        IdFilter idFilter = this.myIdFilter;
        if (idFilter == null || this.myIdFilterForLibraries != withLibraries) {
            this.myIdFilter = idFilter = IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)withLibraries);
            this.myIdFilterForLibraries = withLibraries;
        }
        return idFilter;
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        THashSet allNames = ContainerUtil.newTroveSet();
        Collection result2 = Collections.synchronizedCollection(allNames);
        this.processNames((Processor<String>)Processors.cancelableCollectProcessor(result2), checkBoxState);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)allNames);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getNames"));
        }
        return stringArray;
    }

    private List<ChooseByNameContributor> filterDumb(ChooseByNameContributor[] contributors) {
        if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
            return Arrays.asList(contributors);
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.length);
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware((Object)contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    @NotNull
    public Object[] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        if (canceled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        long elementByNameStarted = System.currentTimeMillis();
        List items = Collections.synchronizedList(new ArrayList());
        Processor processor2 = contributor -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "lambda$getElementsByName$1"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "lambda$getElementsByName$1"));
            }
            if (canceled == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "lambda$getElementsByName$1"));
            }
            if (this.myProject.isDisposed()) {
                return true;
            }
            TIntHashSet filter = (TIntHashSet)this.myContributorToItsSymbolsMap.get(contributor);
            if (filter != null && !filter.contains(name.hashCode())) {
                return true;
            }
            try {
                boolean searchInLibraries = parameters.getSearchScope().isSearchInLibraries();
                long contributorStarted = System.currentTimeMillis();
                if (contributor instanceof ChooseByNameContributorEx) {
                    ((ChooseByNameContributorEx)contributor).processElementsWithName(name, (Processor<NavigationItem>)((Processor)item -> {
                        if (canceled == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "lambda$null$0"));
                        }
                        canceled.checkCanceled();
                        if (this.acceptItem((NavigationItem)item)) {
                            items.add(item);
                        }
                        return true;
                    }), parameters);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + ",");
                    }
                } else {
                    NavigationItem[] itemsByName;
                    for (NavigationItem item2 : itemsByName = contributor.getItemsByName(name, parameters.getLocalPatternName(), this.myProject, searchInLibraries)) {
                        canceled.checkCanceled();
                        if (item2 == null) {
                            PluginId pluginId = PluginManager.getPluginByClassName(contributor.getClass().getName());
                            if (pluginId != null) {
                                LOG.error((Throwable)new PluginException("null item from contributor " + contributor + " for name " + name, pluginId));
                                continue;
                            }
                            LOG.error("null item from contributor " + contributor + " for name " + name);
                            continue;
                        }
                        if (!this.acceptItem(item2)) continue;
                        items.add(item2);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + "," + itemsByName.length);
                    }
                }
            }
            catch (ProcessCanceledException searchInLibraries) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.filterDumb(this.myContributors), canceled, true, processor2)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items.size() + " for " + (System.currentTimeMillis() - elementByNameStarted));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(items);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        return objectArray;
    }

    @NotNull
    public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
        Object[] objectArray = this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        return objectArray;
    }

    public String getElementName(Object element) {
        if (!(element instanceof NavigationItem)) {
            throw new AssertionError((Object)(element + " of " + element.getClass()));
        }
        return ((NavigationItem)element).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.myContributors;
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "removeModelSpecificMarkup"));
        }
        String string = pattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "removeModelSpecificMarkup"));
        }
        return string;
    }
}

