/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SLRUMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RareLogger
extends Logger {
    private final SLRUMap<Object, Long> myCache;
    private final List<LogFilter> myConvertors;
    private final LogFilter myProxy;
    private final Logger myLogger;

    private RareLogger(final Logger logger, final boolean fairSynch) {
        this.myLogger = logger;
        final Object lock = new Object();
        this.myCache = new SLRUMap<Object, Long>(64, 32){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long get(Object key2) {
                if (fairSynch) {
                    Object object = lock;
                    synchronized (object) {
                        return (Long)super.get(key2);
                    }
                }
                return (Long)super.get(key2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void put(Object key2, @NotNull Long value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/idea/RareLogger$1", "put"));
                }
                if (fairSynch) {
                    Object object = lock;
                    synchronized (object) {
                        super.put(key2, (Object)value);
                        return;
                    }
                }
                super.put(key2, (Object)value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean remove(Object key2) {
                if (fairSynch) {
                    Object object = lock;
                    synchronized (object) {
                        return super.remove(key2);
                    }
                }
                return super.remove(key2);
            }
        };
        this.myConvertors = new LinkedList<LogFilter>();
        this.myProxy = new LogFilter(){

            @Override
            @NotNull
            public Integer getAllowedLoggingInterval(Level level, String message, Throwable t, String[] details) {
                Integer n = -1;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/RareLogger$2", "getAllowedLoggingInterval"));
                }
                return n;
            }

            @Override
            public Object getKey(@NotNull Level level, @NonNls String message, @Nullable Throwable t, String ... details) {
                if (level == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/idea/RareLogger$2", "getKey"));
                }
                if (Level.DEBUG.equals((Object)level)) {
                    logger.debug(message, t);
                } else if (Level.INFO.equals((Object)level)) {
                    logger.info(message, t);
                } else if (Level.WARN.equals((Object)level)) {
                    logger.warn(message, t);
                } else if (Level.ERROR.equals((Object)level)) {
                    logger.error(message, t, details);
                }
                return null;
            }
        };
    }

    public void addFilter(LogFilter logFilter) {
        this.myConvertors.add(logFilter);
    }

    public static Logger wrap(Logger logger, boolean fairSynch) {
        return new RareLogger(logger, fairSynch);
    }

    public static Logger wrap(Logger logger, boolean fairSynch, LogFilter ... filters) {
        RareLogger rareLogger = new RareLogger(logger, fairSynch);
        for (LogFilter filter : filters) {
            rareLogger.addFilter(filter);
        }
        return rareLogger;
    }

    public void debug(@NonNls String message) {
        this.process(Level.DEBUG, message, null, new String[0]);
    }

    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    public void debug(Throwable t) {
        this.process(Level.DEBUG, null, t, new String[0]);
    }

    public void debug(@NonNls String message, Throwable t) {
        this.process(Level.DEBUG, message, t, new String[0]);
    }

    public boolean isTraceEnabled() {
        return this.myLogger.isTraceEnabled();
    }

    public void trace(String message) {
        this.process(Level.TRACE, message, null, new String[0]);
    }

    public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/idea/RareLogger", "error"));
        }
        this.process(Level.ERROR, message, t, details);
    }

    public void info(@NonNls String message) {
        this.process(Level.INFO, message, null, new String[0]);
    }

    public void info(@NonNls String message, Throwable t) {
        this.process(Level.INFO, message, t, new String[0]);
    }

    public void warn(@NonNls String message, Throwable t) {
        this.process(Level.WARN, message, t, new String[0]);
    }

    public void setLevel(Level level) {
        this.myLogger.setLevel(level);
    }

    private void process(@NotNull Level level, @NonNls @Nullable String message, @Nullable Throwable t, String ... details) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/idea/RareLogger", "process"));
        }
        if (!Level.ERROR.equals((Object)level)) {
            for (LogFilter convertor : this.myConvertors) {
                Object key2 = convertor.getKey(level, message, t, details);
                if (key2 == null) continue;
                Long latestMoment = (Long)this.myCache.get(key2);
                if (latestMoment != null && System.currentTimeMillis() - latestMoment < (long)convertor.getAllowedLoggingInterval(level, message, t, details).intValue()) {
                    return;
                }
                this.myCache.put(key2, (Object)System.currentTimeMillis());
                break;
            }
        }
        this.myProxy.getKey(level, message, t, details);
    }

    public static interface LogFilter {
        @Nullable
        public Object getKey(@NotNull Level var1, @NonNls String var2, @Nullable Throwable var3, String ... var4);

        @NotNull
        public Integer getAllowedLoggingInterval(Level var1, String var2, Throwable var3, String[] var4);
    }
}

