/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.Set;
import org.jdesktop.swingx.util.OS;
import org.jetbrains.annotations.NotNull;

public class ScaleInfoUsageCollector
extends UsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        float scale = JBUI.SYSTEM_DEF_SCALE;
        if (OS.isMacOSX()) {
            scale = UIUtil.isRetina() ? 2.0f : 1.0f;
        } else {
            int scaleBase = (int)Math.floor(scale);
            float scaleFract = scale - (float)scaleBase;
            scaleFract = scaleFract == 0.0f ? 0.0f : (scaleFract < 0.375f ? 0.25f : (scaleFract < 0.625f ? 0.5f : 0.75f));
            scale = (float)scaleBase + scaleFract;
        }
        String os = OS.isWindows() ? "Windows" : (OS.isLinux() ? "Linux" : (OS.isMacOSX() ? "Mac" : "Unknown OS"));
        Set<UsageDescriptor> set2 = Collections.singleton(new UsageDescriptor(os + " " + scale, 1));
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ScaleInfoUsageCollector", "getUsages"));
        }
        return set2;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("user.ui.screen.scale");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ScaleInfoUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

