/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.cyberneko.html.parsers.DOMParser;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class FindJarFix<T extends PsiElement>
implements IntentionAction,
Iconable {
    private static final Logger LOG = Logger.getInstance(FindJarFix.class);
    private static final String CLASS_ROOT_URL = "http://findjar.com/class/";
    private static final String CLASS_PAGE_EXT = ".html";
    private static final String SERVICE_URL = "http://findjar.com";
    private static final String LINK_TAG_NAME = "a";
    private static final String LINK_ATTR_NAME = "href";
    protected final T myRef;
    protected final Module myModule;
    protected JComponent myEditorComponent;

    public FindJarFix(T ref) {
        this.myRef = ref;
        this.myModule = ModuleUtil.findModuleForPsiElement(ref);
    }

    @NotNull
    public String getText() {
        if ("Find JAR on web" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/FindJarFix", "getText"));
        }
        return "Find JAR on web";
    }

    @NotNull
    public String getFamilyName() {
        if ("Family name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/FindJarFix", "getFamilyName"));
        }
        return "Family name";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarFinder/FindJarFix", "isAvailable"));
        }
        return this.myRef.isValid() && JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Object", file2.getResolveScope()) != null && this.myModule != null && FindJarFix.isFqnsOk(project2, this.getPossibleFqns(this.myRef));
    }

    private static boolean isFqnsOk(Project project2, List<String> fqns) {
        if (fqns.isEmpty()) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        for (String fqn : fqns) {
            if (facade.findClass(fqn, scope) == null) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarFinder/FindJarFix", "invoke"));
        }
        List<String> fqns = this.getPossibleFqns(this.myRef);
        this.myEditorComponent = editor.getComponent();
        if (fqns.size() > 1) {
            JBList listOfFqns = new JBList(fqns);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)listOfFqns).setTitle("Select Qualified Name").setItemChoosenCallback(() -> {
                Object value = listOfFqns.getSelectedValue();
                if (value instanceof String) {
                    this.findJarsForFqn((String)value, editor);
                }
            }).createPopup().showInBestPositionFor(editor);
        } else if (fqns.size() == 1) {
            this.findJarsForFqn(fqns.get(0), editor);
        }
    }

    private void findJarsForFqn(final String fqn, final Editor editor) {
        final HashMap libs = new HashMap();
        final Runnable runnable2 = () -> {
            try {
                DOMParser parser = new DOMParser();
                parser.parse(CLASS_ROOT_URL + fqn.replace('.', '/') + CLASS_PAGE_EXT);
                Document doc = parser.getDocument();
                if (doc != null) {
                    NodeList links = doc.getElementsByTagName(LINK_TAG_NAME);
                    for (int i2 = 0; i2 < links.getLength(); ++i2) {
                        String pathToJar;
                        Node href;
                        Node link = links.item(i2);
                        String libName = link.getTextContent();
                        NamedNodeMap attributes = link.getAttributes();
                        if (attributes == null || (href = attributes.getNamedItem(LINK_ATTR_NAME)) == null || (pathToJar = href.getTextContent()) == null || !pathToJar.startsWith("/jar/") && !pathToJar.startsWith("/class/../")) continue;
                        libs.put(libName, SERVICE_URL + pathToJar);
                    }
                }
            }
            catch (IOException parser) {
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        };
        Task.Modal task = new Task.Modal(editor.getProject(), "Looking for libraries", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/FindJarFix$1", "run"));
                }
                indicator.setIndeterminate(true);
                FindJarFix.runUncanceledRunnableWithProgress(runnable2, indicator);
            }

            public void onSuccess() {
                super.onSuccess();
                if (libs.isEmpty()) {
                    HintManager.getInstance().showInformationHint(editor, "No libraries found for '" + fqn + "'");
                } else {
                    ArrayList variants = new ArrayList(libs.keySet());
                    Collections.sort(variants, (o1, o2) -> o1.compareTo((String)o2));
                    JBList libNames = new JBList(variants);
                    libNames.installCellRenderer(o -> new JLabel(o.toString(), PlatformIcons.JAR_ICON, 2));
                    if (libs.size() == 1) {
                        String jarName = (String)libs.keySet().iterator().next();
                        String url = (String)libs.get(jarName);
                        FindJarFix.this.initiateDownload(url, jarName);
                    } else {
                        JBPopupFactory.getInstance().createListPopupBuilder((JList)libNames).setTitle("Select a JAR file").setItemChoosenCallback(() -> {
                            String jarName;
                            String url;
                            Object value = libNames.getSelectedValue();
                            if (value instanceof String && (url = (String)libs.get(jarName = (String)value)) != null) {
                                FindJarFix.this.initiateDownload(url, jarName);
                            }
                        }).createPopup().showInBestPositionFor(editor);
                    }
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void initiateDownload(String url, String jarName) {
        DOMParser parser = new DOMParser();
        try {
            NodeList links;
            parser.parse(url);
            Document doc = parser.getDocument();
            if (doc != null && (links = doc.getElementsByTagName(LINK_TAG_NAME)) != null) {
                for (int i2 = 0; i2 < links.getLength(); ++i2) {
                    String jarUrl;
                    Node link;
                    NamedNodeMap attributes;
                    Node item = links.item(i2);
                    if (item == null || (attributes = item.getAttributes()) == null || (link = attributes.getNamedItem(LINK_ATTR_NAME)) == null || (jarUrl = link.getTextContent()) == null || !jarUrl.endsWith(jarName)) continue;
                    this.downloadJar(jarUrl, jarName);
                }
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void runUncanceledRunnableWithProgress(Runnable run, ProgressIndicator indicator) {
        Thread t = new Thread(run, "FindJar download thread");
        t.setDaemon(true);
        t.start();
        try {
            while (t.isAlive()) {
                t.join(500L);
                indicator.checkCanceled();
            }
        }
        catch (InterruptedException e) {
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadJar(String jarUrl, String jarName) {
        Project project2 = this.myModule.getProject();
        String dirPath = PropertiesComponent.getInstance((Project)project2).getValue("findjar.last.used.dir");
        VirtualFile toSelect = dirPath == null ? null : LocalFileSystem.getInstance().findFileByIoFile(new File(dirPath));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)project2, (VirtualFile)toSelect);
        if (file2 != null) {
            PropertiesComponent.getInstance((Project)project2).setValue("findjar.last.used.dir", file2.getPath());
            DownloadableFileService downloader = DownloadableFileService.getInstance();
            DownloadableFileDescription description = downloader.createFileDescription(jarUrl, jarName);
            List jars = downloader.createDownloader(Arrays.asList(description), jarName).downloadFilesWithProgress(file2.getPath(), project2, this.myEditorComponent);
            if (jars != null && jars.size() == 1) {
                AccessToken token = WriteAction.start();
                try {
                    OrderEntryFix.addJarToRoots(((VirtualFile)jars.get(0)).getPresentableUrl(), this.myModule, this.myRef);
                }
                finally {
                    token.finish();
                }
            }
        }
    }

    protected abstract Collection<String> getFqns(@NotNull T var1);

    protected List<String> getPossibleFqns(T ref) {
        Collection<String> fqns = this.getFqns(ref);
        ArrayList<String> res = new ArrayList<String>(fqns.size());
        for (String fqn : fqns) {
            String className;
            int index;
            if (fqn.startsWith("java.") || fqn.startsWith("javax.swing.") || (index = fqn.lastIndexOf(46)) == -1 || (className = fqn.substring(index + 1)).length() == 0 || Character.isLowerCase(className.charAt(0))) continue;
            res.add(fqn);
        }
        return res;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.WEB_ICON;
    }
}

