/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.ide.TypePresentationService;
import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageViewBundle;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesProvider
implements FindUsagesProvider {
    public static final String DEFAULT_PACKAGE_NAME = UsageViewBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);

    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/java/JavaFindUsagesProvider", "canFindUsagesFor"));
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage != null && psiPackage.getQualifiedName().length() != 0;
        }
        return element instanceof PsiClass || element instanceof PsiVariable || element instanceof PsiMethod || element instanceof PsiPackage || element instanceof PsiJavaModule || element instanceof PsiLabeledStatement || ThrowSearchUtil.isSearchable(element) || element instanceof PsiMetaOwner && ((PsiMetaOwner)element).getMetaData() != null;
    }

    public String getHelpId(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/java/JavaFindUsagesProvider", "getHelpId"));
        }
        if (element instanceof PsiPackage) {
            return "reference.dialogs.findUsages.package";
        }
        if (element instanceof PsiClass) {
            return "reference.dialogs.findUsages.class";
        }
        if (element instanceof PsiMethod) {
            return "reference.dialogs.findUsages.method";
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            return "reference.dialogs.findUsages.throwUsages";
        }
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
        }
        if (element instanceof PsiDirectory) {
            String string = LangBundle.message("terms.directory", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiFile) {
            String string = LangBundle.message("terms.file", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string = LangBundle.message("java.terms.exception", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = LangBundle.message("java.terms.package", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = LangBundle.message("java.terms.label", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiClass) {
            if (((PsiClass)element).isAnnotationType()) {
                String string = LangBundle.message("java.terms.annotation.interface", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
                }
                return string;
            }
            if (((PsiClass)element).isEnum()) {
                String string = LangBundle.message("java.terms.enum", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
                }
                return string;
            }
            if (((PsiClass)element).isInterface()) {
                String string = LangBundle.message("java.terms.interface", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
                }
                return string;
            }
            if (element instanceof PsiTypeParameter) {
                String string = LangBundle.message("java.terms.type.parameter", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
                }
                return string;
            }
            String string = LangBundle.message("java.terms.class", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiField) {
            String string = LangBundle.message("java.terms.field", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiParameter) {
            String string = LangBundle.message("java.terms.parameter", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiLocalVariable) {
            String string = LangBundle.message("java.terms.variable", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            boolean isConstructor = psiMethod.isConstructor();
            if (isConstructor) {
                String string = LangBundle.message("java.terms.constructor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
                }
                return string;
            }
            String string = LangBundle.message("java.terms.method", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiExpression) {
            String string = LangBundle.message("java.terms.expression", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PsiJavaModule) {
            String string = LangBundle.message("java.terms.module", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        String name = TypePresentationService.getService().getTypePresentableName(element.getClass());
        if (name != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getType"));
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string = ThrowSearchUtil.getSearchableTypeName(element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiDirectory) {
            String string = JavaFindUsagesProvider.getPackageName((PsiDirectory)element, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = JavaFindUsagesProvider.getPackageName((PsiPackage)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiFile) {
            String string = ((PsiFile)element).getVirtualFile().getPresentableUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = ((PsiLabeledStatement)element).getLabelIdentifier().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiClass) {
            if (element instanceof PsiAnonymousClass) {
                String name = ((PsiAnonymousClass)element).getBaseClassReference().getReferenceName();
                String string = "anonymous " + StringUtil.notNullize((String)name, (String)"class");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            String string = qName == null ? aClass.getName() : qName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            String formatted = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)131074);
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass != null) {
                String string = JavaFindUsagesProvider.getContainingClassDescription(psiClass, formatted);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            String string = formatted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiField) {
            PsiField psiField = (PsiField)element;
            String formatted = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass != null) {
                String string = JavaFindUsagesProvider.getContainingClassDescription(psiClass, formatted);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            String string = formatted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiVariable) {
            String string = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiLiteralExpression) {
            String string = element.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiJavaModule) {
            String string = ((PsiJavaModule)element).getModuleName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getDescriptiveName"));
        }
        return "";
    }

    private static String getContainingClassDescription(PsiClass aClass, String formatted) {
        String className;
        if (aClass instanceof PsiAnonymousClass) {
            return LangBundle.message("java.terms.of.anonymous.class", formatted);
        }
        String qualifiedName = aClass.getQualifiedName();
        String string = className = qualifiedName != null ? qualifiedName : aClass.getName();
        if (aClass.isInterface()) {
            return LangBundle.message("java.terms.of.interface", formatted, className);
        }
        if (aClass.isEnum()) {
            return LangBundle.message("java.terms.of.enum", formatted, className);
        }
        if (aClass.isAnnotationType()) {
            return LangBundle.message("java.terms.of.annotation.type", formatted, className);
        }
        return LangBundle.message("java.terms.of.class", formatted, className);
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
        }
        if (element instanceof PsiDirectory) {
            String string = JavaFindUsagesProvider.getPackageName((PsiDirectory)element, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = JavaFindUsagesProvider.getPackageName((PsiPackage)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiFile) {
            String string = useFullName ? ((PsiFile)element).getVirtualFile().getPresentableUrl() : ((PsiFile)element).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = ((PsiLabeledStatement)element).getLabelIdentifier().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            String string = ThrowSearchUtil.getSearchableTypeName(element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (useFullName) {
                String qName;
                String s = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)3);
                PsiClass psiClass = psiMethod.getContainingClass();
                if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
                    s = psiClass.isInterface() ? LangBundle.message("java.terms.of.interface", s, qName) : LangBundle.message("java.terms.of.class", s, qName);
                }
                String string = s;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
            String string = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            String s = LangBundle.message("java.terms.variable.of.method", PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatMethod((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2));
            PsiClass psiClass = method2.getContainingClass();
            if (psiClass != null && psiClass.getQualifiedName() != null) {
                s = psiClass.isInterface() ? LangBundle.message("java.terms.of.interface", s, psiClass.getQualifiedName()) : LangBundle.message("java.terms.of.class", s, psiClass.getQualifiedName());
            }
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiField) {
            String qName;
            PsiField psiField = (PsiField)element;
            String s = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
                s = psiClass.isInterface() ? LangBundle.message("java.terms.of.interface", s, qName) : LangBundle.message("java.terms.of.class", s, qName);
            }
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PsiVariable) {
            String string = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaFindUsagesProvider", "getNodeText"));
        }
        return "";
    }

    public static String getPackageName(PsiDirectory directory, boolean includeRootDir) {
        String rootDir;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return directory.getVirtualFile().getPresentableUrl();
        }
        String packageName = JavaFindUsagesProvider.getPackageName(aPackage);
        if (includeRootDir && (rootDir = JavaFindUsagesProvider.getRootDirectoryForPackage(directory)) != null) {
            return UsageViewBundle.message((String)"usage.target.package.in.directory", (Object[])new Object[]{packageName, rootDir});
        }
        return packageName;
    }

    public static String getRootDirectoryForPackage(PsiDirectory directory) {
        PsiManager manager = directory.getManager();
        VirtualFile virtualFile = directory.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)manager.getProject()).getFileIndex();
        VirtualFile root = fileIndex.getSourceRootForFile(virtualFile);
        if (root == null) {
            root = fileIndex.getClassRootForFile(virtualFile);
        }
        if (root != null) {
            return root.getPresentableUrl();
        }
        return null;
    }

    public static String getPackageName(PsiPackage psiPackage) {
        if (psiPackage == null) {
            return null;
        }
        String name = psiPackage.getQualifiedName();
        if (name.length() > 0) {
            return name;
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public WordsScanner getWordsScanner() {
        return null;
    }
}

