/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import io.netty.util.internal.SystemPropertyUtil;
import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Object LOCK = new Object();
    private static final IdeEventQueue ourEventQueue = IdeEventQueue.getInstance();
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static WeakHashMap<Project, List<Dialog>> projectToModalEntities = new WeakHashMap();
    private static WeakHashMap<Project, Stack<ModalityState>> projectToModalEntitiesStack = new WeakHashMap();
    private static final Stack<ModalityState> ourModalityStack = new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL});
    private static final List<RunnableInfo> ourQueue = new ArrayList<RunnableInfo>();
    private static volatile int ourQueueSkipCount;
    private static final FlushQueue ourFlushQueueRunnable;
    private static final Stack<AWTEvent> ourEventStack;
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster;
    private static final AtomicBoolean FLUSHER_SCHEDULED;
    private static final Object RUN_LOCK;

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/application/impl/LaterInvocator", "addModalityStateListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/application/impl/LaterInvocator", "addModalityStateListener"));
        }
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    public static void removeModalityStateListener(@NotNull ModalityStateListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/application/impl/LaterInvocator", "removeModalityStateListener"));
        }
        ourModalityStateMulticaster.removeListener((EventListener)listener2);
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
        }
        int index = ourModalEntities.indexOf(window);
        if (index < 0) {
            Window owner = window.getOwner();
            if (owner == null) {
                ModalityStateEx modalityStateEx = (ModalityStateEx)ApplicationManager.getApplication().getNoneModalityState();
                if (modalityStateEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
                }
                return modalityStateEx;
            }
            ModalityStateEx ownerState = LaterInvocator.modalityStateForWindow(owner);
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                ModalityStateEx modalityStateEx = ownerState.appendEntity(window);
                if (modalityStateEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
                }
                return modalityStateEx;
            }
            ModalityStateEx modalityStateEx = ownerState;
            if (modalityStateEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
            }
            return modalityStateEx;
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object entity : ourModalEntities) {
            if (!(entity instanceof Window) && (!(entity instanceof ProgressIndicator) || !((ProgressIndicator)entity).isModal())) continue;
            result2.add(entity);
        }
        ModalityStateEx modalityStateEx = new ModalityStateEx(result2.toArray());
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "modalityStateForWindow"));
        }
        return modalityStateEx;
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable2, modalityState, expired);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ActionCallback actionCallback = LaterInvocator.invokeLater(runnable2, modalityState, Conditions.FALSE);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        ActionCallback callback = new ActionCallback();
        RunnableInfo runnableInfo = new RunnableInfo(runnable2, modalityState, expired, callback);
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(runnableInfo);
        }
        LaterInvocator.requestFlush();
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "invokeLater"));
        }
        return actionCallback;
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/LaterInvocator", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/impl/LaterInvocator", "invokeAndWait"));
        }
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLater(runnable1, modalityState);
        semaphore.waitFor();
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemPropertyUtil.getBoolean((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        TransactionGuardImpl guard;
        if (modalEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "com/intellij/openapi/application/impl/LaterInvocator", "enterModal"));
        }
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
        ourModalityStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
        TransactionGuardImpl transactionGuardImpl = guard = IdeaApplication.isLoaded() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality((ModalityState)ourModalityStack.peek());
        }
    }

    public static void enterModal(Project project2, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog2.getName() + " ; for project: " + project2.getName());
        }
        if (project2 == null) {
            LaterInvocator.enterModal(dialog2);
            return;
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        List modalEntitiesList = (List)projectToModalEntities.getOrDefault((Object)project2, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        projectToModalEntities.put((Object)project2, (Object)modalEntitiesList);
        modalEntitiesList.add(dialog2);
        Stack modalEntitiesStack = (Stack)projectToModalEntitiesStack.getOrDefault((Object)project2, (Object)new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL}));
        projectToModalEntitiesStack.put((Object)project2, (Object)modalEntitiesStack);
        modalEntitiesStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
    }

    public static void leaveModal(Project project2, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog2.getName() + " ; for project: " + project2.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(dialog2);
        if (index != -1) {
            ourModalEntities.remove(index);
            ourModalityStack.remove(index + 1);
            for (int i2 = 1; i2 < ourModalityStack.size(); ++i2) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i2))).removeModality(dialog2);
            }
        } else if (project2 != null) {
            List dialogs = (List)projectToModalEntities.get((Object)project2);
            int perProjectIndex = dialogs.indexOf(dialog2);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack states = (Stack)projectToModalEntitiesStack.get((Object)project2);
            states.remove(perProjectIndex + 1);
            for (int i3 = 1; i3 < states.size(); ++i3) {
                ((ModalityStateEx)((Object)states.get(i3))).removeModality(dialog2);
            }
        }
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "com/intellij/openapi/application/impl/LaterInvocator", "leaveModal"));
        }
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        ourModalEntities.remove(index);
        ourModalityStack.remove(index + 1);
        for (int i2 = 1; i2 < ourModalityStack.size(); ++i2) {
            ((ModalityStateEx)((Object)ourModalityStack.get(i2))).removeModality(modalEntity);
        }
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static void leaveAllModals() {
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.NON_MODAL, (Object)LaterInvocator.getCurrentModalityState());
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static Object[] getCurrentModalEntitiesForProject(Project project2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null || !ourModalEntities.isEmpty()) {
            return ArrayUtil.toObjectArray(ourModalEntities);
        }
        return ArrayUtil.toObjectArray((Collection)((Collection)projectToModalEntities.get((Object)project2)));
    }

    @NotNull
    public static Object[] getCurrentModalEntities() {
        Object[] objectArray = LaterInvocator.getCurrentModalEntitiesForProject(null);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "getCurrentModalEntities"));
        }
        return objectArray;
    }

    @NotNull
    public static ModalityState getCurrentModalityState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ModalityState modalityState = (ModalityState)ourModalityStack.peek();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/LaterInvocator", "getCurrentModalityState"));
        }
        return modalityState;
    }

    public static boolean isInModalContextForProject(Project project2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread());
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        List<Dialog> modalEntitiesForProject = LaterInvocator.getModalEntitiesForProject(project2);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    private static List<Dialog> getModalEntitiesForProject(Project project2) {
        return (List)projectToModalEntities.get((Object)project2);
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    public static boolean ensureFlushRequested() {
        if (LaterInvocator.getNextEvent(false) != null) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo getNextEvent(boolean remove) {
        Object object = LOCK;
        synchronized (object) {
            ModalityState currentModality = LaterInvocator.getCurrentModalityState();
            while (ourQueueSkipCount < ourQueue.size()) {
                RunnableInfo info = ourQueue.get(ourQueueSkipCount);
                if (info.expired.value(null)) {
                    ourQueue.remove(ourQueueSkipCount);
                    info.callback.setDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    if (remove) {
                        ourQueue.remove(ourQueueSkipCount);
                    }
                    return info;
                }
                ++ourQueueSkipCount;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RunnableInfo> getLaterInvocatorQueue() {
        Object object = LOCK;
        synchronized (object) {
            return ContainerUtil.newArrayList(ourQueue);
        }
    }

    static /* synthetic */ RunnableInfo access$600(boolean x0) {
        return LaterInvocator.getNextEvent(x0);
    }

    static /* synthetic */ Object access$700() {
        return RUN_LOCK;
    }

    static /* synthetic */ IdeEventQueue access$800() {
        return ourEventQueue;
    }

    static /* synthetic */ Stack access$900() {
        return ourEventStack;
    }

    static /* synthetic */ Logger access$1100() {
        return LOG;
    }

    static /* synthetic */ boolean access$1200() {
        return DEBUG;
    }

    static {
        ourFlushQueueRunnable = new FlushQueue();
        ourEventStack = new Stack();
        ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
        FLUSHER_SCHEDULED = new AtomicBoolean(false);
        RUN_LOCK = new Object();
    }

    private static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        private FlushQueue() {
        }

        @Override
        public void run() {
            FLUSHER_SCHEDULED.set(false);
            if (this.runNextEvent()) {
                LaterInvocator.requestFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean runNextEvent() {
            block13: {
                this.myLastInfo = lastInfo = LaterInvocator.access$600(true);
                if (lastInfo == null) break block13;
                var2_2 = LaterInvocator.access$700();
                synchronized (var2_2) {
                    event = LaterInvocator.access$800().getTrueCurrentEvent();
                    LaterInvocator.access$900().push((Object)event);
                    stackSize = LaterInvocator.access$900().size();
                    try {
                        RunnableInfo.access$1000(lastInfo).run();
                        RunnableInfo.access$200(lastInfo).setDone();
                    }
                    catch (ProcessCanceledException var5_5) {
                        LaterInvocator.access$1100().assertTrue(LaterInvocator.access$900().size() == stackSize);
                        LaterInvocator.access$900().pop();
                        if (!LaterInvocator.access$1200()) {
                            this.myLastInfo = null;
                        }
                    }
                    catch (Throwable t) {
                        LaterInvocator.access$1100().error(t);
                        {
                            catch (Throwable var6_7) {
                                LaterInvocator.access$1100().assertTrue(LaterInvocator.access$900().size() == stackSize);
                                LaterInvocator.access$900().pop();
                                if (!LaterInvocator.access$1200()) {
                                    this.myLastInfo = null;
                                }
                                throw var6_7;
                            }
                        }
                        LaterInvocator.access$1100().assertTrue(LaterInvocator.access$900().size() == stackSize);
                        LaterInvocator.access$900().pop();
                        if (!LaterInvocator.access$1200()) {
                            this.myLastInfo = null;
                        } else {
                            ** GOTO lbl45
                        }
                    }
                    LaterInvocator.access$1100().assertTrue(LaterInvocator.access$900().size() == stackSize);
                    LaterInvocator.access$900().pop();
                    if (!LaterInvocator.access$1200()) {
                        this.myLastInfo = null;
                    }
lbl45:
                    // 3 sources

                }
            }
            return lastInfo != null;
        }

        public String toString() {
            return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
        }
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @NotNull
        private final ActionCallback callback;

        RunnableInfo(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull ActionCallback callback) {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            if (modalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            if (expired == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo", "<init>"));
            }
            this.runnable = runnable2;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback;
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }

        static /* synthetic */ Runnable access$1000(RunnableInfo x0) {
            return x0.runnable;
        }
    }
}

