/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;

class ReadMostlyRWLock {
    private final Thread writeThread;
    private volatile boolean writeRequested;
    private volatile boolean writeAcquired;
    private final ConcurrentList<Reader> readers;
    private final ThreadLocal<Reader> R;
    private static final int SPIN_TO_WAIT_FOR_LOCK = 100;

    ReadMostlyRWLock(@NotNull Thread writeThread) {
        if (writeThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeThread", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "<init>"));
        }
        this.readers = ContainerUtil.createConcurrentList();
        this.R = new ThreadLocal<Reader>(){

            @Override
            protected Reader initialValue() {
                Reader status = new Reader(Thread.currentThread());
                boolean added = ReadMostlyRWLock.this.readers.addIfAbsent((Object)status);
                assert (added) : ReadMostlyRWLock.access$000(ReadMostlyRWLock.this) + "; " + Thread.currentThread();
                return status;
            }
        };
        this.writeThread = writeThread;
    }

    boolean isWriteThread() {
        return Thread.currentThread() == this.writeThread;
    }

    boolean isReadLockedByThisThread() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        return status.readRequested;
    }

    void readLock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        if (this.tryReadLock(status)) {
            return;
        }
        int iter = 0;
        while (!this.tryReadLock(status)) {
            ProgressManager.checkCanceled();
            if (iter > 100) {
                status.blocked = true;
                try {
                    LockSupport.parkNanos(this, 1000000L);
                }
                finally {
                    status.blocked = false;
                }
            } else {
                Thread.yield();
            }
            ++iter;
        }
        return;
    }

    void readUnlock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        status.readRequested = false;
        if (this.writeRequested) {
            LockSupport.unpark(this.writeThread);
        }
    }

    boolean tryReadLock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        return this.tryReadLock(status);
    }

    private boolean tryReadLock(Reader status) {
        if (!this.writeRequested) {
            status.readRequested = true;
            if (!this.writeRequested) {
                return true;
            }
            status.readRequested = false;
        }
        return false;
    }

    void writeLock() {
        this.checkWriteThreadAccess();
        assert (!this.writeRequested);
        assert (!this.writeAcquired);
        this.writeRequested = true;
        int iter = 0;
        while (true) {
            if (this.areAllReadersIdle()) break;
            if (iter > 100) {
                LockSupport.parkNanos(this, 1000000L);
            } else {
                Thread.yield();
            }
            ++iter;
        }
        this.writeAcquired = true;
    }

    void writeUnlock() {
        this.checkWriteThreadAccess();
        this.writeAcquired = false;
        this.writeRequested = false;
        ArrayList<Reader> dead = new ArrayList<Reader>(this.readers.size());
        for (Reader reader : this.readers) {
            if (reader.blocked) {
                LockSupport.unpark(reader.thread);
                continue;
            }
            if (reader.thread.isAlive()) continue;
            dead.add(reader);
        }
        this.readers.removeAll(dead);
    }

    private void checkWriteThreadAccess() {
        if (Thread.currentThread() != this.writeThread) {
            throw new IllegalStateException("Current thread: " + Thread.currentThread() + "; expected: " + this.writeThread);
        }
    }

    private void checkReadThreadAccess() {
        if (Thread.currentThread() == this.writeThread) {
            throw new IllegalStateException("Must not start read from the write thread: " + Thread.currentThread());
        }
    }

    boolean tryWriteLock() {
        this.checkWriteThreadAccess();
        assert (!this.writeRequested);
        assert (!this.writeAcquired);
        this.writeRequested = true;
        if (this.areAllReadersIdle()) {
            this.writeAcquired = true;
            return true;
        }
        this.writeRequested = false;
        return false;
    }

    private boolean areAllReadersIdle() {
        for (Reader reader : this.readers) {
            if (!reader.readRequested) continue;
            return false;
        }
        return true;
    }

    boolean isWriteLocked() {
        return this.writeAcquired;
    }

    private static class Reader {
        @NotNull
        private final Thread thread;
        private volatile boolean readRequested;
        private volatile boolean blocked;

        Reader(@NotNull Thread readerThread) {
            if (readerThread == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerThread", "com/intellij/openapi/application/impl/ReadMostlyRWLock$Reader", "<init>"));
            }
            this.thread = readerThread;
        }
    }
}

