/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
implements EditorColorsScheme,
SerializableScheme {
    private static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    protected float myLineSpacing;
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);
    @NotNull
    private final FontPreferences myFontPreferences = new FontPreferences();
    @NotNull
    private final FontPreferences myConsoleFontPreferences = new FontPreferences();
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String myFallbackFontName;
    private String mySchemeName;
    private float myConsoleLineSpacing = -1.0f;
    private boolean myIsSaveNeeded;
    private boolean myCanBeDeleted = true;
    private int myVersion = 142;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = new THashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.red, (Object)ColorUtil.fromHex((String)"CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.yellow, (Object)ColorUtil.fromHex((String)"EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of((Object)Color.blue, (Object)ColorUtil.fromHex((String)"3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"CCCFFF"), (Object)ColorUtil.fromHex((String)"BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"FFCCE5"), (Object)ColorUtil.fromHex((String)"F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"586E75"), (Object)ColorUtil.fromHex((String)"71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"268BD2"), (Object)ColorUtil.fromHex((String)"54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
        this.myFontPreferences.setChangeListener(() -> this.initFonts());
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultBackground"));
        }
        return color;
    }

    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultForeground"));
        }
        return color;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getName"));
        }
        return string;
    }

    public void setFont(EditorFontType key2, Font font) {
        this.myFonts.put(key2, font);
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        this.myFontPreferences.copyTo(newScheme.myFontPreferences);
        newScheme.myLineSpacing = this.myLineSpacing;
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        this.myConsoleFontPreferences.copyTo(newScheme.myConsoleFontPreferences);
        newScheme.myConsoleLineSpacing = this.myConsoleLineSpacing;
        Set<EditorFontType> types = this.myFonts.keySet();
        for (EditorFontType type : types) {
            Font font = this.myFonts.get(type);
            newScheme.setFont(type, font);
        }
        newScheme.myAttributesMap = new THashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    public void setEditorFontName(String fontName) {
        int editorFontSize = this.getEditorFontSize();
        this.myFontPreferences.clear();
        this.myFontPreferences.register(fontName, editorFontSize);
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.myFontPreferences.register(this.getEditorFontName(), fontSize);
        this.initFonts();
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setQuickDocFontSize"));
        }
        if (this.myQuickDocFontSize != fontSize) {
            this.myQuickDocFontSize = fontSize;
            this.myIsSaveNeeded = true;
        }
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    public Font getFont(EditorFontType key2) {
        if (UISettings.getInstance().PRESENTATION_MODE) {
            Font font = this.myFonts.get(key2);
            return new Font(font.getName(), font.getStyle(), UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
        }
        return this.myFonts.get(key2);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setName"));
        }
        this.mySchemeName = name;
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFontPreferences"));
        }
        return fontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setFontPreferences"));
        }
        preferences.copyTo(this.myFontPreferences);
        this.initFonts();
    }

    public String getEditorFontName() {
        if (this.myFallbackFontName != null) {
            return this.myFallbackFontName;
        }
        return this.myFontPreferences.getFontFamily();
    }

    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.getEditorFontName());
    }

    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    public float getLineSpacing() {
        float spacing = this.myLineSpacing;
        return spacing <= 0.0f ? 1.0f : spacing;
    }

    protected void initFonts() {
        String editorFontName = this.getEditorFontName();
        int editorFontSize = this.getEditorFontSize();
        this.myFallbackFontName = FontPreferences.getFallbackName((String)editorFontName, (int)editorFontSize, (EditorColorsScheme)this.myParentScheme);
        if (this.myFallbackFontName != null) {
            editorFontName = this.myFallbackFontName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = this.getConsoleFontName();
        int consoleFontSize = this.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    public String toString() {
        return this.getName();
    }

    public void readExternal(Element parentNode) {
        UISettings settings = UISettings.getInstance();
        ColorBlindness blindness = settings == null ? null : settings.COLOR_BLINDNESS;
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            for (Element element : parentNode.getChildren(SCHEME_ELEMENT)) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault);
                    break;
                }
                case "font": {
                    this.readFontSettings(childNode, this.myFontPreferences, isDefault);
                    break;
                }
                case "console-font": {
                    this.readFontSettings(childNode, this.myConsoleFontPreferences, isDefault);
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        DefaultColorSchemesManager manager = DefaultColorSchemesManager.getInstance();
        EditorColorsScheme defaultScheme = manager.getScheme(name);
        if (defaultScheme == null) {
            defaultScheme = EmptyColorScheme.INSTANCE;
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        return editorColorsScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaInfoElement", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readMetaInfo"));
        }
        this.myMetaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readAttributes"));
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            Element valueElement = e.getChild(VALUE_ELEMENT);
            TextAttributesKey key2 = TextAttributesKey.find((String)e.getAttributeValue("name"));
            if (valueElement == null) {
                if (e.getAttributeValue(BASE_ATTRIBUTES_ATTR) == null) continue;
                this.myAttributesMap.put(key2, TextAttributes.USE_INHERITED_MARKER);
                continue;
            }
            TextAttributes attr = this.myValueReader.read(TextAttributes.class, valueElement);
            this.myAttributesMap.put(key2, attr);
            this.migrateErrorStripeColorFrom14(key2, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m != null && Comparing.equal((Object)m.first, (Object)attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m.second);
        }
    }

    private void readColors(Element childNode) {
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            String colorName = colorElement.getAttributeValue("name");
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readSettings"));
        }
        switch (childNode.getAttributeValue("name")) {
            case "LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.myLineSpacing = value.floatValue();
                break;
            }
            case "EDITOR_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault);
                if (value <= 0) break;
                this.setEditorFontSize(value);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setEditorFontName(value);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setConsoleLineSpacing(value.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault);
                if (value <= 0) break;
                this.setConsoleFontSize(value);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setConsoleFontName(value);
                break;
            }
            case "EDITOR_QUICK_DOC_FONT_SIZE": {
                FontSize value = this.myValueReader.read(FontSize.class, childNode);
                if (value == null) break;
                this.myQuickDocFontSize = value;
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.myFontPreferences.setUseLigatures(value.booleanValue());
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.myConsoleFontPreferences.setUseLigatures(value.booleanValue());
                break;
            }
        }
    }

    private int readFontSize(Element element, boolean isDefault) {
        Integer size = this.myValueReader.read(Integer.class, element);
        return size == null ? -1 : (!isDefault ? size : JBUI.scaleFontSize((int)size));
    }

    private void readFontSettings(@NotNull Element element, @NotNull FontPreferences preferences, boolean isDefaultScheme) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        List children2 = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children2) {
            Element e = (Element)child;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        if (this.getLineSpacing() != 1.0f) {
            JdomKt.addOptionTag(parentNode, LINE_SPACING, String.valueOf(this.getLineSpacing()));
        }
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (useOldFontFormat) {
            JdomKt.addOptionTag(parentNode, EDITOR_FONT_SIZE, String.valueOf(this.getEditorFontSize()));
        } else {
            AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
        }
        AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        if (!this.myFontPreferences.equals((Object)this.myConsoleFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag(parentNode, CONSOLE_FONT_NAME, this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag(parentNode, CONSOLE_FONT_SIZE, Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
        }
        if (this.getConsoleLineSpacing() != this.getLineSpacing()) {
            JdomKt.addOptionTag(parentNode, CONSOLE_LINE_SPACING, Float.toString(this.getConsoleLineSpacing()));
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            JdomKt.addOptionTag(parentNode, EDITOR_QUICK_JAVADOC_FONT_SIZE, this.getQuickDocFontSize().toString());
        }
        if (useOldFontFormat) {
            JdomKt.addOptionTag(parentNode, EDITOR_FONT_NAME, this.getEditorFontName());
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag(parentNode, optionName, String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key2, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key2);
            JdomKt.addOptionTag(element, EDITOR_FONT_NAME, fontFamily);
            JdomKt.addOptionTag(element, EDITOR_FONT_SIZE, String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element);
        }
    }

    private boolean isParentOverwritingInheritance(@NotNull TextAttributesKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isParentOverwritingInheritance"));
        }
        TextAttributes parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key2) : null;
        return parentAttributes != null && parentAttributes != TextAttributes.USE_INHERITED_MARKER;
    }

    private void writeAttributes(@NotNull Element attrElements) throws WriteExternalException {
        if (attrElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrElements", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeAttributes"));
        }
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        list.sort(null);
        for (TextAttributesKey key2 : list) {
            TextAttributes attributes = this.myAttributesMap.get(key2);
            TextAttributesKey baseKey = key2.getFallbackAttributeKey();
            if (attributes == TextAttributes.USE_INHERITED_MARKER) {
                if (baseKey == null || !this.isParentOverwritingInheritance(key2)) continue;
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key2.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey.getExternalName()));
                continue;
            }
            if (this.myParentScheme != null) {
                TextAttributes parentAttributes;
                TextAttributes textAttributes = parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key2) : this.myParentScheme.getAttributes(key2);
                if (parentAttributes != null && attributes.equals((Object)parentAttributes)) continue;
            }
            Element valueElement = new Element(VALUE_ELEMENT);
            attributes.writeExternal(valueElement);
            attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key2.getExternalName()).addContent(valueElement));
        }
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.myParentScheme;
        if (parentScheme == null) {
            return;
        }
        for (TextAttributesKey key2 : new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet())) {
            TextAttributes attributes = this.myAttributesMap.get(key2);
            if (attributes == TextAttributes.USE_INHERITED_MARKER) {
                if (key2.getFallbackAttributeKey() != null) continue;
                this.myAttributesMap.remove(key2);
                continue;
            }
            TextAttributes parentAttributes = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes(key2, false) : parentScheme.getAttributes(key2);
            if (!Comparing.equal((Object)parentAttributes, (Object)attributes)) continue;
            this.myAttributesMap.remove(key2);
        }
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element = metaInfoElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "metaInfoToElement"));
        }
        return element;
    }

    protected Color getOwnColor(ColorKey key2) {
        return this.myColorsMap.get(key2);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        list.sort(null);
        for (ColorKey key2 : list) {
            if (!this.haveToWrite(key2)) continue;
            Color value = this.myColorsMap.get(key2);
            String value1 = value == null ? "" : Integer.toString(value.getRGB() & 0xFFFFFF, 16);
            JdomKt.addOptionTag(colorElements, key2.getExternalName(), value1);
        }
    }

    private boolean haveToWrite(@NotNull ColorKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "haveToWrite"));
        }
        Color value = this.myColorsMap.get(key2);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal((Object)((AbstractColorsScheme)this.myParentScheme).getOwnColor(key2), (Object)value) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key2) : Comparing.equal((Object)this.myParentScheme.getColor(key2), (Object)value));
    }

    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getConsoleFontPreferences"));
        }
        return fontPreferences;
    }

    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setConsoleFontPreferences"));
        }
        preferences.copyTo(this.myConsoleFontPreferences);
        this.initFonts();
    }

    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    public void setConsoleFontName(String fontName) {
        int consoleFontSize = this.getConsoleFontSize();
        this.myConsoleFontPreferences.clear();
        this.myConsoleFontPreferences.register(fontName, consoleFontSize);
    }

    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstance();
        if ((uiSettings == null || !uiSettings.PRESENTATION_MODE) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    public void setConsoleFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.myConsoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    public float getConsoleLineSpacing() {
        float consoleLineSpacing = this.myConsoleLineSpacing;
        if (consoleLineSpacing == -1.0f) {
            return this.getLineSpacing();
        }
        return consoleLineSpacing;
    }

    public void setConsoleLineSpacing(float lineSpacing) {
        this.myConsoleLineSpacing = lineSpacing;
    }

    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallbackKey", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFallbackAttributes"));
        }
        TextAttributes fallbackAttributes = this.getDirectlyDefinedAttributes(fallbackKey);
        TextAttributesKey fallbackKeyFallbackKey = fallbackKey.getFallbackAttributeKey();
        if (fallbackAttributes != null && (fallbackAttributes != TextAttributes.USE_INHERITED_MARKER || fallbackKeyFallbackKey == null)) {
            return fallbackAttributes;
        }
        return fallbackKeyFallbackKey == null ? null : this.getFallbackAttributes(fallbackKeyFallbackKey);
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDirectlyDefinedAttributes"));
        }
        TextAttributes attributes = this.myAttributesMap.get(key2);
        if (attributes != null) {
            return attributes;
        }
        return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key2) : null;
    }

    public boolean isSaveNeeded() {
        return this.myIsSaveNeeded;
    }

    public void setSaveNeeded(boolean isSaveNeeded) {
        this.myIsSaveNeeded = isSaveNeeded;
    }

    public boolean isReadOnly() {
        return false;
    }

    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.myMetaInfo;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getMetaProperties"));
        }
        return properties;
    }

    public boolean canBeDeleted() {
        return this.myCanBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.myCanBeDeleted = canBeDeleted;
    }

    public boolean isVisible() {
        return true;
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_ELEMENT, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isVisible"));
        }
        return !(scheme2 instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme2).isVisible();
    }

    public static String getDisplayName(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_ELEMENT, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDisplayName"));
        }
        String schemeName = scheme2.getName();
        return schemeName.startsWith("_@user_") ? schemeName.substring("_@user_".length()) : schemeName;
    }

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = EditorColorsManager.getInstance().getScheme(originalSchemeName)) instanceof AbstractColorsScheme) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeScheme"));
        }
        return element;
    }

    public boolean isEqualToBundled(AbstractColorsScheme bundledScheme) {
        if (this.myParentScheme != bundledScheme.myParentScheme && this.myParentScheme != bundledScheme) {
            return false;
        }
        for (String propertyName : this.myMetaInfo.stringPropertyNames()) {
            if (propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Comparing.equal((String)this.myMetaInfo.getProperty(propertyName), (String)bundledScheme.myMetaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return this.getLineSpacing() == bundledScheme.getLineSpacing() && this.getConsoleLineSpacing() == bundledScheme.getConsoleLineSpacing() && this.getQuickDocFontSize() == bundledScheme.getQuickDocFontSize() && this.myFontPreferences.getRealFontFamilies().equals(bundledScheme.myFontPreferences.getRealFontFamilies()) && this.myFontPreferences.useLigatures() == bundledScheme.myFontPreferences.useLigatures() && this.myConsoleFontPreferences.useLigatures() == bundledScheme.myConsoleFontPreferences.useLigatures() && this.myConsoleFontPreferences.getRealFontFamilies().equals(bundledScheme.myConsoleFontPreferences.getRealFontFamilies()) && this.myColorsMap.equals(bundledScheme.myColorsMap) && this.myAttributesMap.equals(bundledScheme.myAttributesMap) && this.myFontPreferences.equals((Object)bundledScheme.myFontPreferences) && this.myConsoleFontPreferences.equals((Object)bundledScheme.myConsoleFontPreferences);
    }
}

