/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.EventDispatcher;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlayModelImpl
implements InlayModel,
Disposable {
    private static final Comparator<Inlay> INLAY_COMPARATOR = Comparator.comparingInt(Inlay::getOffset).thenComparingInt(i2 -> ((InlayImpl)i2).myOriginalOffset);
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher;
    final RangeMarkerTree<InlayImpl> myInlayTree;
    boolean myStickToLargerOffsetsOnUpdate;

    InlayModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/InlayModelImpl", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
        this.myEditor = editor;
        this.myInlayTree = new RangeMarkerTree<InlayImpl>((Document)editor.getDocument()){

            @Override
            @NotNull
            protected RangeMarkerTree.RMNode<InlayImpl> createNewNode(@NotNull InlayImpl key2, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
                if (key2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/InlayModelImpl$1", "createNewNode"));
                }
                RangeMarkerTree.RMNode<InlayImpl> rMNode = new RangeMarkerTree.RMNode<InlayImpl>((RangeMarkerTree)this, key2, start, end, greedyToLeft, greedyToRight){

                    @Override
                    protected Getter<InlayImpl> createGetter(@NotNull InlayImpl interval) {
                        if (interval == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/InlayModelImpl$1$1", "createGetter"));
                        }
                        return interval;
                    }
                };
                if (rMNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/InlayModelImpl$1", "createNewNode"));
                }
                return rMNode;
            }

            @Override
            void fireBeforeRemoved(@NotNull InlayImpl markerEx, @NotNull @NonNls Object reason) {
                if (markerEx == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerEx", "com/intellij/openapi/editor/impl/InlayModelImpl$1", "fireBeforeRemoved"));
                }
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/editor/impl/InlayModelImpl$1", "fireBeforeRemoved"));
                }
                if (markerEx.myOffsetBeforeDisposal == -1) {
                    InlayModelImpl.this.notifyRemoved(markerEx);
                }
            }
        };
        this.myEditor.getDocument().addDocumentListener(new PrioritizedDocumentListener(){

            @Override
            public int getPriority() {
                return 150;
            }

            public void beforeDocumentChange(DocumentEvent event) {
                if (InlayModelImpl.this.myEditor.getDocument().isInBulkUpdate()) {
                    return;
                }
                int offset = event.getOffset();
                if (event.getOldLength() == 0 && offset == InlayModelImpl.this.myEditor.getCaretModel().getOffset() && InlayModelImpl.this.hasInlineElementAt(offset) && InlayModelImpl.this.myEditor.getCaretModel().getVisualPosition().equals((Object)InlayModelImpl.this.myEditor.offsetToVisualPosition(offset, false, false))) {
                    InlayModelImpl.this.myStickToLargerOffsetsOnUpdate = true;
                }
            }

            public void documentChanged(DocumentEvent event) {
                InlayModelImpl.this.myStickToLargerOffsetsOnUpdate = false;
            }
        }, this);
    }

    void reinitSettings() {
        this.myInlayTree.process(inlay -> {
            inlay.updateSize();
            return true;
        });
    }

    public void dispose() {
        this.myInlayTree.dispose();
    }

    @Nullable
    public Inlay addInlineElement(int offset, @NotNull EditorCustomElementRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/editor/impl/InlayModelImpl", "addInlineElement"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        InlayImpl inlay = new InlayImpl(this.myEditor, offset, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public List<Inlay> getInlineElementsInRange(int startOffset, int endOffset) {
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        this.myInlayTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            result2.add((Inlay)inlay);
            return true;
        });
        Collections.sort(result2, INLAY_COMPARATOR);
        ArrayList<Inlay> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/InlayModelImpl", "getInlineElementsInRange"));
        }
        return arrayList;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlayTree.processOverlappingWith(offset, offset, inlay -> false);
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        if (visualPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visualPosition", "com/intellij/openapi/editor/impl/InlayModelImpl", "hasInlineElementAt"));
        }
        int offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition));
        if (!this.hasInlineElementAt(offset)) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.equals((Object)inlayStartPosition);
    }

    @Nullable
    public Inlay getElementAt(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/editor/impl/InlayModelImpl", "getElementAt"));
        }
        if (this.myInlayTree.size() == 0) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(point));
        List<Inlay> inlays = this.getInlineElementsInRange(offset, offset);
        if (inlays.isEmpty()) {
            return null;
        }
        VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
        int x = this.myEditor.visualPositionToXY((VisualPosition)startVisualPosition).x;
        for (Inlay inlay : inlays) {
            int endX = x + inlay.getWidthInPixels();
            if (point.x >= x && point.x < endX) {
                return inlay;
            }
            x = endX;
        }
        return null;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/InlayModelImpl", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/editor/impl/InlayModelImpl", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    private void notifyAdded(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded((Inlay)inlay);
    }

    void notifyChanged(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated((Inlay)inlay);
    }

    void notifyRemoved(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved((Inlay)inlay);
    }
}

