/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Getter;
import org.jetbrains.annotations.NotNull;

public class RangeHighlighterTree
extends RangeMarkerTree<RangeHighlighterEx> {
    private final MarkupModelEx myMarkupModel;

    public RangeHighlighterTree(@NotNull Document document, @NotNull MarkupModelEx markupModel) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "<init>"));
        }
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "<init>"));
        }
        super(document);
        this.myMarkupModel = markupModel;
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i1, @NotNull IntervalTreeImpl.IntervalNode<RangeHighlighterEx> i2) {
        if (i1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i1", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "compareEqualStartIntervals"));
        }
        if (i2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i2", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "compareEqualStartIntervals"));
        }
        RHNode o1 = (RHNode)i1;
        RHNode o2 = (RHNode)i2;
        int d = o2.myLayer - o1.myLayer;
        if (d != 0) {
            return d;
        }
        return super.compareEqualStartIntervals(i1, i2);
    }

    @NotNull
    protected RHNode createNewNode(@NotNull RangeHighlighterEx key2, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "createNewNode"));
        }
        RHNode rHNode = new RHNode(this, key2, start, end, greedyToLeft, greedyToRight, layer);
        if (rHNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "createNewNode"));
        }
        return rHNode;
    }

    @Override
    void fireBeforeRemoved(@NotNull RangeHighlighterEx markerEx, @NotNull Object reason) {
        if (markerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerEx", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "fireBeforeRemoved"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/editor/impl/RangeHighlighterTree", "fireBeforeRemoved"));
        }
        this.myMarkupModel.fireBeforeRemoved(markerEx);
    }

    static class RHNode
    extends RangeMarkerTree.RMNode<RangeHighlighterEx> {
        final int myLayer;

        public RHNode(@NotNull RangeHighlighterTree rangeMarkerTree, @NotNull RangeHighlighterEx key2, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
            if (rangeMarkerTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarkerTree", "com/intellij/openapi/editor/impl/RangeHighlighterTree$RHNode", "<init>"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeHighlighterTree$RHNode", "<init>"));
            }
            super(rangeMarkerTree, key2, start, end, greedyToLeft, greedyToRight);
            this.myLayer = layer;
        }

        @Override
        protected Getter<RangeHighlighterEx> createGetter(@NotNull RangeHighlighterEx interval) {
            if (interval == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/RangeHighlighterTree$RHNode", "createGetter"));
            }
            return (Getter)interval;
        }
    }
}

