/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractMappingStrategy<T>
implements MappingStrategy<T> {
    protected final EditorEx myEditor;
    protected final SoftWrapsStorage myStorage;
    protected final List<CacheEntry> myCache;
    private EditorPosition myInitialPosition;
    private CacheEntry myTargetEntry;
    private T myEagerMatch;
    private int myLastEntryOffset;

    AbstractMappingStrategy(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage2, @NotNull List<CacheEntry> cache) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        this.myEditor = editor;
        this.myStorage = storage2;
        this.myCache = cache;
    }

    @Override
    @Nullable
    public T eagerMatch() {
        return this.myEagerMatch;
    }

    protected void setEagerMatch(@Nullable T eagerMatch) {
        this.myEagerMatch = eagerMatch;
    }

    protected void setFirstInitialPosition() {
        this.myInitialPosition = new EditorPosition(new LogicalPosition(0, 0), 0, this.myEditor);
    }

    @Nullable
    protected CacheEntry getTargetEntry() {
        return this.myTargetEntry;
    }

    protected void setTargetEntry(@NotNull CacheEntry targetEntry, boolean anchorToStart) {
        if (targetEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetEntry", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "setTargetEntry"));
        }
        this.myTargetEntry = targetEntry;
        this.myInitialPosition = anchorToStart ? targetEntry.buildStartLinePosition() : targetEntry.buildEndLinePosition();
    }

    protected void reset() {
        this.myEagerMatch = null;
        this.myTargetEntry = null;
        this.myInitialPosition = null;
        if (!this.myCache.isEmpty()) {
            this.myLastEntryOffset = this.myCache.get((int)(this.myCache.size() - 1)).endOffset;
        }
    }

    protected void setInitialPosition(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "setInitialPosition"));
        }
        this.myInitialPosition = position;
    }

    @Override
    @NotNull
    public EditorPosition buildInitialPosition() {
        EditorPosition editorPosition = this.myInitialPosition;
        if (editorPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "buildInitialPosition"));
        }
        return editorPosition;
    }

    @Nullable
    protected FoldingData getFoldRegionData(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "getFoldRegionData"));
        }
        int i2 = MappingUtil.getCacheEntryIndexForOffset(foldRegion.getStartOffset(), this.myEditor.getDocument(), this.myCache);
        if (i2 < 0 || i2 >= this.myCache.size()) {
            return null;
        }
        CacheEntry cacheEntry = this.myCache.get(i2);
        return cacheEntry.getFoldingData(foldRegion);
    }

    @Override
    public T advance(@NotNull EditorPosition position, int offset) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "advance"));
        }
        DocumentEx document = this.myEditor.getDocument();
        if (offset >= this.myLastEntryOffset || offset >= document.getTextLength()) {
            return this.build(position);
        }
        T result2 = this.buildIfExceeds(position, offset);
        if (result2 != null) {
            return result2;
        }
        int linesDiff = document.getLineNumber(offset) - position.logicalLine;
        position.logicalLine += linesDiff;
        position.visualLine += linesDiff;
        if (linesDiff <= 0) {
            int columnsDiff = offset - position.offset;
            position.visualColumn += columnsDiff;
            position.logicalColumn += columnsDiff;
        } else {
            int column;
            int lineStartOffset = document.getLineStartOffset(position.logicalLine);
            position.visualColumn = column = offset - lineStartOffset;
            position.logicalColumn = column;
            position.softWrapLinesBefore += position.softWrapLinesCurrent;
            position.softWrapLinesCurrent = 0;
            position.softWrapColumnDiff = 0;
            position.foldingColumnDiff = 0;
        }
        position.offset = offset;
        return null;
    }

    @Nullable
    protected abstract T buildIfExceeds(EditorPosition var1, int var2);

    @Override
    public T processFoldRegion(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "processFoldRegion"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "processFoldRegion"));
        }
        T result2 = this.buildIfExceeds(position, foldRegion);
        if (result2 != null) {
            return result2;
        }
        this.advancePositionOnFolding(position, foldRegion);
        return null;
    }

    protected void advancePositionOnFolding(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "advancePositionOnFolding"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "advancePositionOnFolding"));
        }
        DocumentEx document = this.myEditor.getDocument();
        int endOffsetLogicalLine = document.getLineNumber(foldRegion.getEndOffset());
        if (position.logicalLine != endOffsetLogicalLine) {
            position.softWrapColumnDiff = 0;
            position.softWrapLinesBefore += position.softWrapLinesCurrent;
            position.softWrapLinesCurrent = 0;
        }
        int collapsedSymbolsWidthInColumns = -1;
        FoldingData foldingData = this.getFoldRegionData(foldRegion);
        if (foldingData != null) {
            collapsedSymbolsWidthInColumns = foldingData.getCollapsedSymbolsWidthInColumns();
        }
        position.advance(foldRegion, collapsedSymbolsWidthInColumns);
    }

    @Nullable
    protected abstract T buildIfExceeds(@NotNull EditorPosition var1, @NotNull FoldRegion var2);

    @Override
    public T processTabulation(@NotNull EditorPosition position, TabData tabData) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "processTabulation"));
        }
        T result2 = this.buildIfExceeds(position, tabData);
        if (result2 != null) {
            return result2;
        }
        position.visualColumn += tabData.widthInColumns;
        position.logicalColumn += tabData.widthInColumns;
        ++position.offset;
        return null;
    }

    @Nullable
    protected abstract T buildIfExceeds(EditorPosition var1, TabData var2);
}

