/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import com.intellij.openapi.util.Ref;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CacheEntry
implements Comparable<CacheEntry>,
Cloneable {
    private static final TIntObjectHashMap<FoldingData> DUMMY = new TIntObjectHashMap();
    public int visualLine;
    public int startLogicalLine;
    public int startLogicalColumn;
    public int startOffset;
    public int startSoftWrapLinesBefore;
    public int startSoftWrapLinesCurrent;
    public int startSoftWrapColumnDiff;
    public int startFoldedLines;
    public int startFoldingColumnDiff;
    public int endOffset;
    public int endLogicalLine;
    public int endLogicalColumn;
    public int endVisualColumn;
    public int endSoftWrapLinesBefore;
    public int endSoftWrapLinesCurrent;
    public int endSoftWrapColumnDiff;
    public int endFoldedLines;
    public int endFoldingColumnDiff;
    private final Editor myEditor;
    private List<TabData> myTabPositions;
    private TIntObjectHashMap<FoldingData> myFoldingData;

    CacheEntry(int visualLine, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "<init>"));
        }
        this.myTabPositions = Collections.EMPTY_LIST;
        this.myFoldingData = DUMMY;
        this.visualLine = visualLine;
        this.myEditor = editor;
    }

    public void setLineStartPosition(@NotNull EditorPosition context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "setLineStartPosition"));
        }
        assert (context.visualColumn == 0);
        this.startLogicalLine = context.logicalLine;
        this.startLogicalColumn = context.logicalColumn;
        this.visualLine = context.visualLine;
        this.startOffset = context.offset;
        this.startSoftWrapLinesBefore = context.softWrapLinesBefore;
        this.startSoftWrapLinesCurrent = context.softWrapLinesCurrent;
        this.startSoftWrapColumnDiff = context.softWrapColumnDiff;
        this.startFoldedLines = context.foldedLines;
        this.startFoldingColumnDiff = context.foldingColumnDiff;
    }

    public void setLineEndPosition(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "setLineEndPosition"));
        }
        this.endOffset = position.offset;
        this.endLogicalLine = position.logicalLine;
        this.endLogicalColumn = position.logicalColumn;
        this.endVisualColumn = position.visualColumn;
        this.endSoftWrapLinesBefore = position.softWrapLinesBefore;
        this.endSoftWrapLinesCurrent = position.softWrapLinesCurrent;
        this.endSoftWrapColumnDiff = position.softWrapColumnDiff;
        this.endFoldedLines = position.foldedLines;
        this.endFoldingColumnDiff = position.foldingColumnDiff;
    }

    public EditorPosition buildStartLinePosition() {
        EditorPosition result2 = new EditorPosition(this.myEditor);
        result2.logicalLine = this.startLogicalLine;
        result2.logicalColumn = this.startLogicalColumn;
        result2.offset = this.startOffset;
        result2.visualLine = this.visualLine;
        result2.visualColumn = 0;
        result2.softWrapLinesBefore = this.startSoftWrapLinesBefore;
        result2.softWrapLinesCurrent = this.startSoftWrapLinesCurrent;
        result2.softWrapColumnDiff = this.startSoftWrapColumnDiff;
        result2.foldedLines = this.startFoldedLines;
        result2.foldingColumnDiff = this.startFoldingColumnDiff;
        return result2;
    }

    public EditorPosition buildEndLinePosition() {
        EditorPosition result2 = new EditorPosition(this.myEditor);
        result2.logicalLine = this.endLogicalLine;
        result2.logicalColumn = this.endLogicalColumn;
        result2.offset = this.endOffset;
        result2.visualLine = this.visualLine;
        result2.visualColumn = this.endVisualColumn;
        result2.softWrapLinesBefore = this.endSoftWrapLinesBefore;
        result2.softWrapLinesCurrent = this.endSoftWrapLinesCurrent;
        result2.softWrapColumnDiff = this.endSoftWrapColumnDiff;
        result2.foldedLines = this.endFoldedLines;
        result2.foldingColumnDiff = this.endFoldingColumnDiff;
        return result2;
    }

    public void removeAllDataAtOrAfter(final int offset) {
        int i2;
        if (this.myFoldingData != DUMMY && !this.myFoldingData.isEmpty()) {
            this.myFoldingData.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<FoldingData>(){

                public boolean execute(int a, FoldingData b) {
                    return a < offset;
                }
            });
        }
        for (i2 = 0; i2 < this.myTabPositions.size() && this.myTabPositions.get((int)i2).offset < offset; ++i2) {
        }
        this.myTabPositions.subList(i2, this.myTabPositions.size()).clear();
    }

    @Nullable
    public FoldingData getFoldingData(final @NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "getFoldingData"));
        }
        FoldingData candidate = (FoldingData)this.myFoldingData.get(region.getStartOffset());
        if (candidate != null) {
            return candidate;
        }
        final Ref result2 = new Ref();
        this.myFoldingData.forEachValue((TObjectProcedure)new TObjectProcedure<FoldingData>(){

            public boolean execute(FoldingData data) {
                if (data.getFoldRegion().equals(region)) {
                    result2.set((Object)data);
                    return false;
                }
                return true;
            }
        });
        return (FoldingData)result2.get();
    }

    public void store(FoldingData foldData, int offset) {
        if (this.myFoldingData == DUMMY) {
            this.myFoldingData = new TIntObjectHashMap();
        }
        this.myFoldingData.put(offset, (Object)foldData);
    }

    public List<TabData> getTabData() {
        return this.myTabPositions;
    }

    public void storeTabData(TabData tabData) {
        if (this.myTabPositions == Collections.EMPTY_LIST) {
            this.myTabPositions = new ArrayList<TabData>();
        }
        this.myTabPositions.add(tabData);
    }

    public void advance(final int offsetDiff) {
        this.startOffset += offsetDiff;
        this.endOffset += offsetDiff;
        for (int i2 = 0; i2 < this.myTabPositions.size(); ++i2) {
            this.myTabPositions.get((int)i2).offset += offsetDiff;
        }
        if (this.myFoldingData.isEmpty()) {
            return;
        }
        final TIntObjectHashMap newFoldingData = new TIntObjectHashMap(this.myFoldingData.size());
        this.myFoldingData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<FoldingData>(){

            public boolean execute(int offset, FoldingData foldingData) {
                newFoldingData.put(offset + offsetDiff, (Object)foldingData);
                return true;
            }
        });
        this.myFoldingData = newFoldingData;
    }

    public TIntObjectHashMap<FoldingData> getFoldingData() {
        return this.myFoldingData;
    }

    @Override
    public int compareTo(CacheEntry e) {
        return this.visualLine - e.visualLine;
    }

    public String toString() {
        return String.format("%d - visual line: %d, offsets: %d-%d, logical lines: %d-%d, logical columns: %d-%d, end visual column: %d, fold regions: %s, tab data: %s", System.identityHashCode(this), this.visualLine, this.startOffset, this.endOffset, this.startLogicalLine, this.endLogicalLine, this.startLogicalColumn, this.endLogicalColumn, this.endVisualColumn, Arrays.toString(this.myFoldingData.getValues()), this.myTabPositions);
    }

    protected CacheEntry clone() {
        final CacheEntry result2 = new CacheEntry(this.visualLine, this.myEditor);
        result2.startLogicalLine = this.startLogicalLine;
        result2.startLogicalColumn = this.startLogicalColumn;
        result2.startOffset = this.startOffset;
        result2.startSoftWrapLinesBefore = this.startSoftWrapLinesBefore;
        result2.startSoftWrapLinesCurrent = this.startSoftWrapLinesCurrent;
        result2.startSoftWrapColumnDiff = this.startSoftWrapColumnDiff;
        result2.startFoldedLines = this.startFoldedLines;
        result2.startFoldingColumnDiff = this.startFoldingColumnDiff;
        result2.endOffset = this.endOffset;
        result2.endLogicalLine = this.endLogicalLine;
        result2.endLogicalColumn = this.endLogicalColumn;
        result2.endVisualColumn = this.endVisualColumn;
        result2.endSoftWrapLinesBefore = this.endSoftWrapLinesBefore;
        result2.endSoftWrapLinesCurrent = this.endSoftWrapLinesCurrent;
        result2.endSoftWrapColumnDiff = this.endSoftWrapColumnDiff;
        result2.endFoldedLines = this.endFoldedLines;
        result2.endFoldingColumnDiff = this.endFoldingColumnDiff;
        this.myFoldingData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<FoldingData>(){

            public boolean execute(int offset, FoldingData foldData) {
                result2.store(foldData, offset);
                return true;
            }
        });
        for (TabData tabPosition : this.myTabPositions) {
            result2.storeTabData(tabPosition);
        }
        return result2;
    }
}

