/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.impl.softwrap.mapping.DataProvider;
import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CompositeDataProvider {
    private final DataProvider<? extends Comparable<?>, ?>[] myProviders;

    public CompositeDataProvider(DataProvider<? extends Comparable<?>, ?> ... providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/editor/impl/softwrap/mapping/CompositeDataProvider", "<init>"));
        }
        for (int i2 = 0; i2 < providers.length; ++i2) {
            DataProvider<Comparable<?>, ?> provider = providers[i2];
            if (provider.getData() != null) continue;
            providers[i2] = null;
        }
        this.myProviders = providers;
        this.sort();
    }

    public boolean hasData() {
        for (DataProvider<Comparable<?>, ?> dataProvider : this.myProviders) {
            if (dataProvider == null) continue;
            return true;
        }
        return false;
    }

    public void advance(int sortingKey) {
        for (int i2 = 0; i2 < this.myProviders.length; ++i2) {
            DataProvider<Comparable<?>, ?> provider = this.myProviders[i2];
            if (provider == null) continue;
            provider.advance(sortingKey);
            if (provider.getData() != null) continue;
            this.myProviders[i2] = null;
        }
        this.sort();
    }

    @NotNull
    public <K, V> Pair<K, V> getData() throws IllegalStateException {
        if (!this.hasData()) {
            throw new IllegalStateException("No more data is available within the current provider.");
        }
        DataProvider<Comparable<?>, ?> provider = this.myProviders[0];
        Pair<? extends Comparable<?>, ?> result2 = provider.getData();
        if (result2 == null) {
            throw new IllegalStateException(String.format("Programming error detected - registered data provider doesn't have data (%s). Registered providers: %s", provider, Arrays.toString(this.myProviders)));
        }
        Pair<? extends Comparable<?>, ?> pair = result2;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CompositeDataProvider", "getData"));
        }
        return pair;
    }

    public int getSortingKey() throws IllegalStateException {
        if (!this.hasData()) {
            throw new IllegalStateException("No more data is available within the current provider");
        }
        return this.myProviders[0].getSortingKey();
    }

    public boolean next() {
        if (!this.hasData()) {
            return false;
        }
        DataProvider<Comparable<?>, ?> provider = this.myProviders[0];
        if (!provider.next()) {
            this.myProviders[0] = null;
        }
        if (this.hasData()) {
            this.sort();
            return true;
        }
        return false;
    }

    private void sort() {
        if (this.myProviders.length <= 0) {
            return;
        }
        int i2 = 0;
        DataProvider<Comparable<?>, ?> dataProvider = this.myProviders[0];
        for (int j = 1; j < this.myProviders.length; ++j) {
            DataProvider<Comparable<?>, ?> candidate = this.myProviders[j];
            if (candidate == null || dataProvider != null && CompositeDataProvider.compare(dataProvider, candidate) <= 0) continue;
            i2 = j;
            dataProvider = candidate;
        }
        if (i2 > 0) {
            this.myProviders[i2] = this.myProviders[0];
            this.myProviders[0] = dataProvider;
        }
    }

    private static int compare(DataProvider<? extends Comparable<?>, ?> o1, DataProvider<? extends Comparable<?>, ?> o2) {
        int result2 = o1.getSortingKey() - o2.getSortingKey();
        if (result2 != 0) {
            return result2;
        }
        Pair<? extends Comparable<?>, ?> d1 = o1.getData();
        Pair<? extends Comparable<?>, ?> d2 = o2.getData();
        if (d1 != null && d2 != null) {
            return ((Comparable)d1.first).compareTo(d2.first);
        }
        return result2;
    }
}

