/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapDataProviderKeys;
import org.jetbrains.annotations.Nullable;

public class FoldingDataProvider
extends AbstractDataProvider<SoftWrapDataProviderKeys, FoldRegion> {
    private final FoldRegion[] myFoldRegions;
    private int myIndex;

    public FoldingDataProvider(@Nullable FoldRegion[] foldRegions) {
        super(SoftWrapDataProviderKeys.COLLAPSED_FOLDING);
        this.myFoldRegions = foldRegions;
        this.scrollToInterested();
    }

    @Override
    protected FoldRegion doGetData() {
        if (this.myFoldRegions == null || this.myIndex >= this.myFoldRegions.length) {
            return null;
        }
        return this.myFoldRegions[this.myIndex];
    }

    @Override
    public boolean next() {
        ++this.myIndex;
        this.scrollToInterested();
        return this.doGetData() != null;
    }

    private void scrollToInterested() {
        FoldRegion foldRegion;
        if (this.myFoldRegions == null) {
            return;
        }
        while (this.myIndex < this.myFoldRegions.length && ((foldRegion = this.myFoldRegions[this.myIndex]).isExpanded() || !foldRegion.isValid())) {
            ++this.myIndex;
        }
    }

    @Override
    public void advance(int sortingKey) {
        int start = this.myIndex;
        int end = this.myFoldRegions.length - 1;
        while (start <= end) {
            int i2 = end + start >>> 1;
            FoldRegion foldRegion = this.myFoldRegions[i2];
            if (foldRegion.getStartOffset() < sortingKey) {
                start = i2 + 1;
                continue;
            }
            if (foldRegion.getStartOffset() > sortingKey) {
                end = i2 - 1;
                continue;
            }
            this.myIndex = i2;
            this.scrollToInterested();
            return;
        }
        this.myIndex = start;
        this.scrollToInterested();
    }

    @Override
    public int getSortingKey() {
        if (this.myFoldRegions == null || this.myIndex >= this.myFoldRegions.length) {
            return 0;
        }
        return this.myFoldRegions[this.myIndex].getStartOffset();
    }
}

